/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.r2dbc.CredentialsHelper;
import com.google.cloud.spanner.r2dbc.SpannerConnectionConfiguration;
import com.google.cloud.spanner.r2dbc.util.Assert;
import com.google.cloud.spanner.r2dbc.v2.SpannerClientLibraryConnectionFactory;
import com.google.common.annotations.VisibleForTesting;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.ConnectionFactoryProvider;
import io.r2dbc.spi.Option;
import java.util.HashSet;

public class SpannerConnectionFactoryProvider
implements ConnectionFactoryProvider {
    public static final String DRIVER_NAME = "cloudspanner";
    @Deprecated
    public static final String SHORT_DRIVER_NAME = "spanner";
    public static final Option<String> PROJECT = Option.valueOf((String)"project");
    public static final Option<String> INSTANCE = Option.valueOf((String)"instance");
    public static final Option<String> URL = Option.valueOf((String)"url");
    public static final Option<String> OPTIMIZER_VERSION = Option.valueOf((String)"optimizerVersion");
    public static final Option<GoogleCredentials> GOOGLE_CREDENTIALS = Option.valueOf((String)"google_credentials");
    public static final Option<Boolean> AUTOCOMMIT = Option.valueOf((String)"autocommit");
    public static final Option<Boolean> READONLY = Option.valueOf((String)"readonly");
    public static final Option<String> CREDENTIALS = Option.valueOf((String)"credentials");
    public static final Option<Boolean> USE_PLAIN_TEXT = Option.valueOf((String)"usePlainText");
    public static final Option<String> OAUTH_TOKEN = Option.valueOf((String)"oauthToken");
    private static final Option[] SECURITY_OPTIONS = new Option[]{OAUTH_TOKEN, CREDENTIALS, GOOGLE_CREDENTIALS};
    private CredentialsHelper credentialsHelper = new CredentialsHelper();

    public ConnectionFactory create(ConnectionFactoryOptions connectionFactoryOptions) {
        SpannerConnectionConfiguration config = this.createConfiguration(connectionFactoryOptions);
        return new SpannerClientLibraryConnectionFactory(config);
    }

    public boolean supports(ConnectionFactoryOptions connectionFactoryOptions) {
        Assert.requireNonNull(connectionFactoryOptions, "connectionFactoryOptions must not be null");
        String driver = (String)connectionFactoryOptions.getValue(ConnectionFactoryOptions.DRIVER);
        return DRIVER_NAME.equals(driver) || SHORT_DRIVER_NAME.equals(driver);
    }

    public String getDriver() {
        return DRIVER_NAME;
    }

    @VisibleForTesting
    SpannerConnectionConfiguration createConfiguration(ConnectionFactoryOptions options) {
        SpannerConnectionConfiguration.Builder config = new SpannerConnectionConfiguration.Builder();
        if (options.hasOption(URL)) {
            config.setUrl((String)options.getValue(URL));
        } else if (options.hasOption(ConnectionFactoryOptions.DATABASE) && SpannerConnectionConfiguration.FQDN_PATTERN_PARSE.matcher((CharSequence)options.getValue(ConnectionFactoryOptions.DATABASE)).matches()) {
            config.setFullyQualifiedDatabaseName((String)options.getValue(ConnectionFactoryOptions.DATABASE));
        } else {
            config.setProjectId((String)options.getRequiredValue(PROJECT)).setInstanceName((String)options.getRequiredValue(INSTANCE)).setDatabaseName((String)options.getRequiredValue(ConnectionFactoryOptions.DATABASE));
        }
        config.setCredentials(this.extractCredentials(options));
        if (options.hasOption(USE_PLAIN_TEXT)) {
            config.setUsePlainText(true);
        }
        if (options.hasOption(OPTIMIZER_VERSION)) {
            config.setOptimizerVersion((String)options.getValue(OPTIMIZER_VERSION));
        }
        if (options.hasOption(AUTOCOMMIT)) {
            config.setAutocommit(this.getBooleanFlag(options.getValue(AUTOCOMMIT)));
        }
        if (options.hasOption(READONLY)) {
            config.setReadonly(this.getBooleanFlag(options.getValue(READONLY)));
        }
        return config.build();
    }

    private boolean getBooleanFlag(Object value) {
        Assert.requireNonNull(value, "Non-null option value expected");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        throw new IllegalStateException("Flag type expected to be Boolean or String for " + value);
    }

    private OAuth2Credentials extractCredentials(ConnectionFactoryOptions options) {
        HashSet<Option> foundSecurityOptions = new HashSet<Option>();
        for (Option option : SECURITY_OPTIONS) {
            if (!options.hasOption(option)) continue;
            foundSecurityOptions.add(option);
        }
        if (foundSecurityOptions.size() > 1) {
            throw new IllegalArgumentException("Please provide at most one authentication option. Found: " + foundSecurityOptions);
        }
        if (options.hasOption(OAUTH_TOKEN)) {
            return this.credentialsHelper.getOauthCredentials((String)options.getValue(OAUTH_TOKEN));
        }
        if (options.hasOption(CREDENTIALS)) {
            return this.credentialsHelper.getFileCredentials((String)options.getValue(CREDENTIALS));
        }
        if (options.hasOption(GOOGLE_CREDENTIALS)) {
            return (OAuth2Credentials)options.getValue(GOOGLE_CREDENTIALS);
        }
        if (options.hasOption(USE_PLAIN_TEXT)) {
            return NoCredentials.getInstance();
        }
        return this.credentialsHelper.getDefaultCredentials();
    }

    @VisibleForTesting
    public void setCredentialsHelper(CredentialsHelper credentialsHelper) {
        this.credentialsHelper = credentialsHelper;
    }
}

