/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.v2;

import com.google.cloud.spanner.r2dbc.ConversionFailureException;
import com.google.cloud.spanner.r2dbc.v2.LongIntegerConverter;
import com.google.cloud.spanner.r2dbc.v2.SpannerClientLibrariesConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

class SpannerClientLibraryConverters {
    private static final List<SpannerClientLibrariesConverter<?>> converters = SpannerClientLibraryConverters.createConverters();

    SpannerClientLibraryConverters() {
    }

    private static List<SpannerClientLibrariesConverter<?>> createConverters() {
        ArrayList converters = new ArrayList();
        converters.add(new LongIntegerConverter());
        return converters;
    }

    static <T> T convert(Object value, Class<T> type) {
        Optional<SpannerClientLibrariesConverter> converter = converters.stream().filter(candidate -> candidate.canConvert(value.getClass(), type)).findFirst();
        if (!converter.isPresent()) {
            throw new ConversionFailureException(String.format("Unable to convert %s to %s", value.getClass(), type));
        }
        return converter.get().convert(value);
    }
}

