/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.v2;

import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.r2dbc.v2.SpannerClientLibraryColumnMetadata;
import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.RowMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

class SpannerClientLibraryRowMetadata
implements RowMetadata {
    private final List<ColumnMetadata> columnMetadatas;
    private final List<String> columnNames;
    private final HashMap<String, Integer> columnNameIndex = new HashMap();

    public SpannerClientLibraryRowMetadata(List<Type.StructField> structFields) {
        ArrayList<SpannerClientLibraryColumnMetadata> tmpColumnMetadata = new ArrayList<SpannerClientLibraryColumnMetadata>();
        ArrayList<String> tmpColumnNames = new ArrayList<String>();
        for (int i = 0; i < structFields.size(); ++i) {
            Type.StructField field = structFields.get(i);
            SpannerClientLibraryColumnMetadata metadata = new SpannerClientLibraryColumnMetadata(field);
            tmpColumnMetadata.add(metadata);
            tmpColumnNames.add(field.getName());
            String columnName = field.getName().toLowerCase();
            if (this.columnNameIndex.containsKey(columnName)) continue;
            this.columnNameIndex.put(columnName, i);
        }
        this.columnMetadatas = Collections.unmodifiableList(tmpColumnMetadata);
        this.columnNames = Collections.unmodifiableList(tmpColumnNames);
    }

    public ColumnMetadata getColumnMetadata(int index) {
        return this.columnMetadatas.get(index);
    }

    public ColumnMetadata getColumnMetadata(String identifier) {
        int index = this.getColumnIndexByName(identifier);
        return this.columnMetadatas.get(index);
    }

    public Iterable<? extends ColumnMetadata> getColumnMetadatas() {
        return this.columnMetadatas;
    }

    public Collection<String> getColumnNames() {
        return this.columnNames;
    }

    protected int getColumnIndexByName(String name) {
        String identifier = name.toLowerCase();
        if (!this.columnNameIndex.containsKey(identifier)) {
            throw new IllegalArgumentException("The column name " + name + " does not exist for the Spanner row. Available columns: " + this.columnNameIndex.keySet());
        }
        return this.columnNameIndex.get(identifier);
    }
}

