/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.ValueBinder;
import com.google.cloud.spanner.r2dbc.BindingFailureException;
import java.math.BigDecimal;
import java.util.EnumMap;
import java.util.Map;

public abstract class SpannerType
implements io.r2dbc.spi.Type {
    private Type type;
    private static final Map<Type.Code, Class<?>> SPANNER_TO_JAVA_TYPES = SpannerType.buildTypeMap();
    private static final Map<Type.Code, IterableStatementBinder> ARRAY_BINDERS = SpannerType.buildArrayBinderMap();

    private SpannerType(Type type) {
        this.type = type;
    }

    public abstract boolean isArray();

    public void bindIterable(ValueBinder<Statement.Builder> binder, Iterable<?> value) {
        if (!this.isArray()) {
            throw new BindingFailureException("Iterable cannot be bound to a non-array Spanner type.");
        }
        IterableStatementBinder typedBinder = ARRAY_BINDERS.get(this.type.getArrayElementType().getCode());
        if (typedBinder == null) {
            throw new BindingFailureException("Array binder not found for type " + this.type);
        }
        typedBinder.bind(binder, value);
    }

    public static SpannerType of(final Type type) {
        return new SpannerType(type){

            public Class<?> getJavaType() {
                return (Class)SPANNER_TO_JAVA_TYPES.get(type.getCode());
            }

            public String getName() {
                return type.toString();
            }

            @Override
            public boolean isArray() {
                return type.getCode() == Type.Code.ARRAY;
            }
        };
    }

    private static Map<Type.Code, Class<?>> buildTypeMap() {
        EnumMap map = new EnumMap(Type.Code.class);
        map.put(Type.Code.BOOL, Boolean.class);
        map.put(Type.Code.BYTES, ByteArray.class);
        map.put(Type.Code.DATE, Date.class);
        map.put(Type.Code.FLOAT64, Double.class);
        map.put(Type.Code.NUMERIC, BigDecimal.class);
        map.put(Type.Code.INT64, Long.class);
        map.put(Type.Code.STRING, String.class);
        map.put(Type.Code.STRUCT, Struct.class);
        map.put(Type.Code.TIMESTAMP, Timestamp.class);
        map.put(Type.Code.ARRAY, Iterable.class);
        return map;
    }

    private static Map<Type.Code, IterableStatementBinder> buildArrayBinderMap() {
        EnumMap<Type.Code, IterableStatementBinder> map = new EnumMap<Type.Code, IterableStatementBinder>(Type.Code.class);
        map.put(Type.Code.BOOL, (b, i) -> {
            Statement.Builder cfr_ignored_0 = (Statement.Builder)b.toBoolArray(i);
        });
        map.put(Type.Code.INT64, (b, i) -> {
            Statement.Builder cfr_ignored_0 = (Statement.Builder)b.toInt64Array(i);
        });
        map.put(Type.Code.NUMERIC, (b, i) -> {
            Statement.Builder cfr_ignored_0 = (Statement.Builder)b.toNumericArray(i);
        });
        map.put(Type.Code.FLOAT64, (b, i) -> {
            Statement.Builder cfr_ignored_0 = (Statement.Builder)b.toFloat64Array(i);
        });
        map.put(Type.Code.STRING, (b, i) -> {
            Statement.Builder cfr_ignored_0 = (Statement.Builder)b.toStringArray(i);
        });
        map.put(Type.Code.BYTES, (b, i) -> {
            Statement.Builder cfr_ignored_0 = (Statement.Builder)b.toBytesArray(i);
        });
        map.put(Type.Code.TIMESTAMP, (b, i) -> {
            Statement.Builder cfr_ignored_0 = (Statement.Builder)b.toTimestampArray(i);
        });
        map.put(Type.Code.DATE, (b, i) -> {
            Statement.Builder cfr_ignored_0 = (Statement.Builder)b.toDateArray(i);
        });
        return map;
    }

    @FunctionalInterface
    private static interface IterableStatementBinder {
        public void bind(ValueBinder<Statement.Builder> var1, Iterable<?> var2);
    }
}

