/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.v2;

import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.r2dbc.statement.TypedNull;
import com.google.cloud.spanner.r2dbc.v2.ClientLibraryBinder;
import com.google.cloud.spanner.r2dbc.v2.DatabaseClientReactiveAdapter;
import com.google.cloud.spanner.r2dbc.v2.SpannerClientLibraryResult;
import com.google.spanner.v1.ExecuteSqlRequest;
import io.r2dbc.spi.Result;
import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class AbstractSpannerClientLibraryStatement
implements io.r2dbc.spi.Statement {
    protected final DatabaseClientReactiveAdapter clientLibraryAdapter;
    private Statement.Builder currentStatementBuilder;
    private boolean startedBinding = false;
    private List<Statement> statements;
    private final String query;
    private final ExecuteSqlRequest.QueryOptions queryOptions;

    public AbstractSpannerClientLibraryStatement(DatabaseClientReactiveAdapter clientLibraryAdapter, String query) {
        this.clientLibraryAdapter = clientLibraryAdapter;
        this.query = query;
        this.queryOptions = this.clientLibraryAdapter.getQueryOptions();
        this.currentStatementBuilder = AbstractSpannerClientLibraryStatement.createStatementBuilder(this.query, this.queryOptions);
    }

    private static Statement.Builder createStatementBuilder(String query, ExecuteSqlRequest.QueryOptions options) {
        Statement.Builder builder = Statement.newBuilder((String)query);
        if (options != null) {
            builder = builder.withQueryOptions(options);
        }
        return builder;
    }

    public io.r2dbc.spi.Statement add() {
        if (this.statements == null) {
            this.statements = new ArrayList<Statement>();
        }
        this.statements.add(this.currentStatementBuilder.build());
        this.currentStatementBuilder = AbstractSpannerClientLibraryStatement.createStatementBuilder(this.query, this.queryOptions);
        this.startedBinding = false;
        return this;
    }

    public Publisher<? extends Result> execute() {
        if (this.statements != null) {
            if (this.startedBinding) {
                this.statements.add(this.currentStatementBuilder.build());
                this.startedBinding = false;
                this.currentStatementBuilder = null;
            }
            return this.executeMultiple(this.statements);
        }
        return this.executeSingle(this.currentStatementBuilder.build());
    }

    protected abstract Mono<SpannerClientLibraryResult> executeSingle(Statement var1);

    protected abstract Flux<SpannerClientLibraryResult> executeMultiple(List<Statement> var1);

    public io.r2dbc.spi.Statement bind(int index, Object value) {
        throw new UnsupportedOperationException();
    }

    public io.r2dbc.spi.Statement bind(String name, Object value) {
        ClientLibraryBinder.bind(this.currentStatementBuilder, name, value);
        this.startedBinding = true;
        return this;
    }

    public io.r2dbc.spi.Statement bindNull(int index, Class<?> type) {
        throw new UnsupportedOperationException();
    }

    public io.r2dbc.spi.Statement bindNull(String name, Class<?> type) {
        ClientLibraryBinder.bind(this.currentStatementBuilder, name, new TypedNull(type));
        return this;
    }
}

