/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.core.CloudSqlConnectionFactory;
import com.google.cloud.sql.core.ConnectionConfig;
import com.google.cloud.sql.core.GcpConnectionFactoryProvider;
import com.google.cloud.sql.core.InternalConnectorRegistry;
import io.netty.handler.ssl.SslContextBuilder;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.mariadb.r2dbc.MariadbConnectionFactoryProvider;

public class GcpConnectionFactoryProviderMariadb
extends GcpConnectionFactoryProvider {
    boolean supportedProtocol(String protocol) {
        return protocol.equals("mariadb");
    }

    ConnectionFactory tcpSocketConnectionFactory(ConnectionConfig config, ConnectionFactoryOptions.Builder builder, Function<SslContextBuilder, SslContextBuilder> customizer) {
        UnaryOperator unaryCustomizer = sslContextBuilder -> (SslContextBuilder)customizer.apply((SslContextBuilder)sslContextBuilder);
        builder.option(MariadbConnectionFactoryProvider.SSL_TUNNEL_DISABLE_HOST_VERIFICATION, (Object)true).option(MariadbConnectionFactoryProvider.SSL_CONTEXT_BUILDER_CUSTOMIZER, (Object)unaryCustomizer).option(MariadbConnectionFactoryProvider.TCP_KEEP_ALIVE, (Object)true).option(MariadbConnectionFactoryProvider.SSL_MODE, (Object)"tunnel");
        return new CloudSqlConnectionFactory(config, MariadbConnectionFactoryProvider::new, builder);
    }

    ConnectionFactory unixSocketConnectionFactory(ConnectionFactoryOptions.Builder optionBuilder, String socket) {
        optionBuilder.option(MariadbConnectionFactoryProvider.SOCKET, (Object)socket);
        return new MariadbConnectionFactoryProvider().create(optionBuilder.build());
    }

    ConnectionFactoryOptions.Builder createBuilder(ConnectionFactoryOptions connectionFactoryOptions) {
        return connectionFactoryOptions.mutate().option(ConnectionFactoryOptions.DRIVER, (Object)"mariadb").option(ConnectionFactoryOptions.PROTOCOL, (Object)"none");
    }

    static {
        InternalConnectorRegistry.addArtifactId((String)"cloud-sql-connector-r2dbc-mariadb");
    }
}

