/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc;

import com.google.api.client.util.Strings;
import com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import java.io.Serializable;

public class BigtableClusterName
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String BIGTABLE_V1_CLUSTER_FMT = "projects/%s/zones/%s/clusters/%s";
    public static final String TABLE_SEPARATOR = "tables";
    private final String clusterName;

    public BigtableClusterName(String projectId, String zoneId, String clusterId) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty((String)projectId), "projectId must be supplied");
        Preconditions.checkArgument(!Strings.isNullOrEmpty((String)zoneId), "zoneId must be supplied");
        Preconditions.checkArgument(!Strings.isNullOrEmpty((String)clusterId), "clusterId must be supplied");
        this.clusterName = String.format(BIGTABLE_V1_CLUSTER_FMT, projectId, zoneId, clusterId);
    }

    public String toString() {
        return this.clusterName;
    }

    public String toTableId(String tableName) {
        Preconditions.checkNotNull(tableName, "Table name cannot be null");
        String tablesPrefix = this.clusterName + "/" + TABLE_SEPARATOR + "/";
        Preconditions.checkState(tableName.startsWith(tablesPrefix), "'%s' does not start with '%s'", tableName, tablesPrefix);
        String tableId = tableName.substring(tablesPrefix.length()).trim();
        Preconditions.checkState(!tableId.isEmpty(), "Table id is blank");
        return tableId;
    }

    public String toTableNameStr(String tableId) {
        return this.clusterName + "/" + TABLE_SEPARATOR + "/" + tableId;
    }

    public BigtableTableName toTableName(String tableId) {
        return new BigtableTableName(this.toTableNameStr(tableId));
    }
}

