/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.api.services.datastore.DatastoreV1;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

@Deprecated
public class EntityCoder
extends AtomicCoder<DatastoreV1.Entity> {
    private static final EntityCoder INSTANCE = new EntityCoder();

    @JsonCreator
    public static EntityCoder of() {
        return INSTANCE;
    }

    private EntityCoder() {
    }

    @Override
    public void encode(DatastoreV1.Entity value, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null Entity");
        }
        outStream.write(ByteBuffer.allocate(4).putInt(value.getSerializedSize()).array());
        value.writeTo(outStream);
        outStream.flush();
    }

    @Override
    public DatastoreV1.Entity decode(InputStream inStream, Coder.Context context) throws IOException {
        byte[] entitySize = new byte[4];
        inStream.read(entitySize, 0, 4);
        int size = ByteBuffer.wrap(entitySize).getInt();
        byte[] data = new byte[size];
        inStream.read(data, 0, size);
        return DatastoreV1.Entity.parseFrom((byte[])data);
    }

    @Override
    protected long getEncodedElementByteSize(DatastoreV1.Entity value, Coder.Context context) throws Exception {
        return value.getSerializedSize();
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException(this, "Datastore encodings can hold arbitrary Object instances");
    }
}

