/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.KvCoderBase;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.util.common.ElementByteSizeObserver;
import com.google.cloud.dataflow.sdk.values.KV;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class KvCoder<K, V>
extends KvCoderBase<KV<K, V>> {
    private final Coder<K> keyCoder;
    private final Coder<V> valueCoder;

    public static <K, V> KvCoder<K, V> of(Coder<K> keyCoder, Coder<V> valueCoder) {
        return new KvCoder<K, V>(keyCoder, valueCoder);
    }

    @JsonCreator
    public static KvCoder<?, ?> of(@JsonProperty(value="component_encodings") List<Coder<?>> components) {
        Preconditions.checkArgument(components.size() == 2, "Expecting 2 components, got " + components.size());
        return KvCoder.of(components.get(0), components.get(1));
    }

    public static <K, V> List<Object> getInstanceComponents(KV<K, V> exampleValue) {
        return Arrays.asList(exampleValue.getKey(), exampleValue.getValue());
    }

    public Coder<K> getKeyCoder() {
        return this.keyCoder;
    }

    public Coder<V> getValueCoder() {
        return this.valueCoder;
    }

    private KvCoder(Coder<K> keyCoder, Coder<V> valueCoder) {
        this.keyCoder = keyCoder;
        this.valueCoder = valueCoder;
    }

    @Override
    public void encode(KV<K, V> kv, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        if (kv == null) {
            throw new CoderException("cannot encode a null KV");
        }
        Coder.Context nestedContext = context.nested();
        this.keyCoder.encode(kv.getKey(), outStream, nestedContext);
        this.valueCoder.encode(kv.getValue(), outStream, nestedContext);
    }

    @Override
    public KV<K, V> decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
        Coder.Context nestedContext = context.nested();
        K key = this.keyCoder.decode(inStream, nestedContext);
        V value = this.valueCoder.decode(inStream, nestedContext);
        return KV.of(key, value);
    }

    @Override
    public List<? extends Coder<?>> getCoderArguments() {
        return Arrays.asList(this.keyCoder, this.valueCoder);
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.verifyDeterministic("Key coder must be deterministic", this.getKeyCoder());
        this.verifyDeterministic("Value coder must be deterministic", this.getValueCoder());
    }

    @Override
    public boolean consistentWithEquals() {
        return this.keyCoder.consistentWithEquals() && this.valueCoder.consistentWithEquals();
    }

    @Override
    public Object structuralValue(KV<K, V> kv) throws Exception {
        if (this.consistentWithEquals()) {
            return kv;
        }
        return KV.of(this.getKeyCoder().structuralValue(kv.getKey()), this.getValueCoder().structuralValue(kv.getValue()));
    }

    @Override
    public CloudObject asCloudObject() {
        CloudObject result = super.asCloudObject();
        Structs.addBoolean((Map<String, Object>)((Object)result), "is_pair_like", true);
        return result;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(KV<K, V> kv, Coder.Context context) {
        return this.keyCoder.isRegisterByteSizeObserverCheap(kv.getKey(), context.nested()) && this.valueCoder.isRegisterByteSizeObserverCheap(kv.getValue(), context.nested());
    }

    @Override
    public void registerByteSizeObserver(KV<K, V> kv, ElementByteSizeObserver observer, Coder.Context context) throws Exception {
        if (kv == null) {
            throw new CoderException("cannot encode a null KV");
        }
        this.keyCoder.registerByteSizeObserver(kv.getKey(), observer, context.nested());
        this.valueCoder.registerByteSizeObserver(kv.getValue(), observer, context.nested());
    }
}

