/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.io;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.io.FileBasedSource;
import com.google.cloud.dataflow.sdk.io.Read;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.io.ByteStreams;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.primitives.Ints;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.NoSuchElementException;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class CompressedSource<T>
extends FileBasedSource<T> {
    private final FileBasedSource<T> sourceDelegate;
    private final DecompressingChannelFactory channelFactory;

    public static <T> Read.Bounded<T> readFromSource(FileBasedSource<T> sourceDelegate, DecompressingChannelFactory channelFactory) {
        return Read.from(new CompressedSource<T>(sourceDelegate, channelFactory));
    }

    public static <T> CompressedSource<T> from(FileBasedSource<T> sourceDelegate) {
        return new CompressedSource<T>(sourceDelegate, new DecompressAccordingToFilename());
    }

    public CompressedSource<T> withDecompression(DecompressingChannelFactory channelFactory) {
        return new CompressedSource<T>(this.sourceDelegate, channelFactory);
    }

    private CompressedSource(FileBasedSource<T> sourceDelegate, DecompressingChannelFactory channelFactory) {
        super(sourceDelegate.getFileOrPatternSpec(), Long.MAX_VALUE);
        this.sourceDelegate = sourceDelegate;
        this.channelFactory = channelFactory;
    }

    private CompressedSource(FileBasedSource<T> sourceDelegate, DecompressingChannelFactory channelFactory, String filePatternOrSpec, long minBundleSize, long startOffset, long endOffset) {
        super(filePatternOrSpec, minBundleSize, startOffset, endOffset);
        this.sourceDelegate = sourceDelegate;
        this.channelFactory = channelFactory;
        try {
            Preconditions.checkArgument(this.isSplittable() || startOffset == 0L, "CompressedSources must start reading at offset 0. Requested offset: " + startOffset);
        }
        catch (Exception e) {
            throw new RuntimeException("Error checking whether source " + sourceDelegate + " is splittable");
        }
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkNotNull(this.sourceDelegate);
        this.sourceDelegate.validate();
        Preconditions.checkNotNull(this.channelFactory);
    }

    @Override
    protected FileBasedSource<T> createForSubrangeOfFile(String fileName, long start, long end) {
        return new CompressedSource<T>(this.sourceDelegate.createForSubrangeOfFile(fileName, start, end), this.channelFactory, fileName, this.sourceDelegate.getMinBundleSize(), start, end);
    }

    @Override
    protected final boolean isSplittable() throws Exception {
        if (this.channelFactory instanceof FileNameBasedDecompressingChannelFactory) {
            FileNameBasedDecompressingChannelFactory fileNameBasedChannelFactory = (FileNameBasedDecompressingChannelFactory)this.channelFactory;
            return !fileNameBasedChannelFactory.isCompressed(this.getFileOrPatternSpec());
        }
        return false;
    }

    @Override
    protected final FileBasedSource.FileBasedReader<T> createSingleFileReader(PipelineOptions options) {
        FileNameBasedDecompressingChannelFactory fileNameBasedChannelFactory;
        if (this.channelFactory instanceof FileNameBasedDecompressingChannelFactory && !(fileNameBasedChannelFactory = (FileNameBasedDecompressingChannelFactory)this.channelFactory).isCompressed(this.getFileOrPatternSpec())) {
            return this.sourceDelegate.createSingleFileReader(options);
        }
        return new CompressedReader<T>(this, this.sourceDelegate.createSingleFileReader(options));
    }

    @Override
    public final boolean producesSortedKeys(PipelineOptions options) throws Exception {
        return this.sourceDelegate.producesSortedKeys(options);
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        builder.include(this.sourceDelegate).add(DisplayData.item("source", this.sourceDelegate.getClass()).withLabel("Read Source"));
        if (this.channelFactory instanceof Enum) {
            builder.add(DisplayData.item("compressionMode", ((Enum)((Object)this.channelFactory)).name()).withLabel("Compression Mode"));
        } else {
            builder.add(DisplayData.item("compressionMode", this.channelFactory.getClass()).withLabel("Compression Mode"));
        }
    }

    @Override
    public final Coder<T> getDefaultOutputCoder() {
        return this.sourceDelegate.getDefaultOutputCoder();
    }

    public final DecompressingChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public static class CompressedReader<T>
    extends FileBasedSource.FileBasedReader<T> {
        private final FileBasedSource.FileBasedReader<T> readerDelegate;
        private final CompressedSource<T> source;
        private final Object progressLock = new Object();
        @GuardedBy(value="progressLock")
        private int numRecordsRead;
        @GuardedBy(value="progressLock")
        private CountingChannel channel;

        public CompressedReader(CompressedSource<T> source, FileBasedSource.FileBasedReader<T> readerDelegate) {
            super(source);
            this.source = source;
            this.readerDelegate = readerDelegate;
        }

        @Override
        public T getCurrent() throws NoSuchElementException {
            return this.readerDelegate.getCurrent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final long getSplitPointsConsumed() {
            Object object = this.progressLock;
            synchronized (object) {
                return this.isDone() && this.numRecordsRead > 0 ? 1L : 0L;
            }
        }

        @Override
        public final long getSplitPointsRemaining() {
            return this.isDone() ? 0L : 1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final boolean isAtSplitPoint() {
            Object object = this.progressLock;
            synchronized (object) {
                return this.numRecordsRead == 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void startReading(ReadableByteChannel channel) throws IOException {
            Object object = this.progressLock;
            synchronized (object) {
                this.channel = new CountingChannel(channel, this.getCurrentSource().getStartOffset());
                channel = this.channel;
            }
            if (this.source.getChannelFactory() instanceof FileNameBasedDecompressingChannelFactory) {
                FileNameBasedDecompressingChannelFactory channelFactory = (FileNameBasedDecompressingChannelFactory)this.source.getChannelFactory();
                this.readerDelegate.startReading(channelFactory.createDecompressingChannel(((FileBasedSource)this.getCurrentSource()).getFileOrPatternSpec(), channel));
            } else {
                this.readerDelegate.startReading(this.source.getChannelFactory().createDecompressingChannel(channel));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final boolean readNextRecord() throws IOException {
            if (!this.readerDelegate.readNextRecord()) {
                return false;
            }
            Object object = this.progressLock;
            synchronized (object) {
                ++this.numRecordsRead;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final long getCurrentOffset() throws NoSuchElementException {
            Object object = this.progressLock;
            synchronized (object) {
                if (this.numRecordsRead <= 1) {
                    return 0L;
                }
                return this.channel.getCount();
            }
        }

        private static class CountingChannel
        implements ReadableByteChannel {
            long count;
            private final ReadableByteChannel inner;

            public CountingChannel(ReadableByteChannel inner, long count) {
                this.inner = inner;
                this.count = count;
            }

            public long getCount() {
                return this.count;
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                int bytes = this.inner.read(dst);
                if (bytes > 0) {
                    this.count += (long)bytes;
                }
                return bytes;
            }

            @Override
            public boolean isOpen() {
                return this.inner.isOpen();
            }

            @Override
            public void close() throws IOException {
                this.inner.close();
            }
        }
    }

    private static class DecompressAccordingToFilename
    implements FileNameBasedDecompressingChannelFactory {
        private DecompressAccordingToFilename() {
        }

        @Override
        public ReadableByteChannel createDecompressingChannel(String fileName, ReadableByteChannel channel) throws IOException {
            for (CompressionMode type : CompressionMode.values()) {
                if (!type.matches(fileName)) continue;
                return type.createDecompressingChannel(channel);
            }
            return channel;
        }

        @Override
        public ReadableByteChannel createDecompressingChannel(ReadableByteChannel channel) {
            throw new UnsupportedOperationException(String.format("%s does not support createDecompressingChannel(%s) but only createDecompressingChannel(%s,%s)", this.getClass().getSimpleName(), String.class.getSimpleName(), ReadableByteChannel.class.getSimpleName(), ReadableByteChannel.class.getSimpleName()));
        }

        @Override
        public boolean isCompressed(String fileName) {
            for (CompressionMode type : CompressionMode.values()) {
                if (!type.matches(fileName)) continue;
                return true;
            }
            return false;
        }
    }

    public static enum CompressionMode implements DecompressingChannelFactory
    {
        GZIP{

            @Override
            public boolean matches(String fileName) {
                return fileName.toLowerCase().endsWith(".gz");
            }

            @Override
            public ReadableByteChannel createDecompressingChannel(ReadableByteChannel channel) throws IOException {
                byte zero;
                int header;
                PushbackInputStream stream = new PushbackInputStream(Channels.newInputStream(channel), 2);
                byte[] headerBytes = new byte[2];
                int bytesRead = ByteStreams.read(stream, headerBytes, 0, 2);
                stream.unread(headerBytes, 0, bytesRead);
                if (bytesRead >= 2 && (header = Ints.fromBytes(zero = 0, zero, headerBytes[1], headerBytes[0])) == 35615) {
                    return Channels.newChannel((InputStream)new GzipCompressorInputStream((InputStream)stream, true));
                }
                return Channels.newChannel(stream);
            }
        }
        ,
        BZIP2{

            @Override
            public boolean matches(String fileName) {
                return fileName.toLowerCase().endsWith(".bz2");
            }

            @Override
            public ReadableByteChannel createDecompressingChannel(ReadableByteChannel channel) throws IOException {
                return Channels.newChannel((InputStream)new BZip2CompressorInputStream(Channels.newInputStream(channel)));
            }
        };


        public abstract boolean matches(String var1);

        @Override
        public abstract ReadableByteChannel createDecompressingChannel(ReadableByteChannel var1) throws IOException;
    }

    private static interface FileNameBasedDecompressingChannelFactory
    extends DecompressingChannelFactory {
        public ReadableByteChannel createDecompressingChannel(String var1, ReadableByteChannel var2) throws IOException;

        public boolean isCompressed(String var1);
    }

    public static interface DecompressingChannelFactory
    extends Serializable {
        public ReadableByteChannel createDecompressingChannel(ReadableByteChannel var1) throws IOException;
    }
}

