/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.io;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.io.Source;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.joda.time.Instant;

public abstract class UnboundedSource<OutputT, CheckpointMarkT extends CheckpointMark>
extends Source<OutputT> {
    public abstract List<? extends UnboundedSource<OutputT, CheckpointMarkT>> generateInitialSplits(int var1, PipelineOptions var2) throws Exception;

    public abstract UnboundedReader<OutputT> createReader(PipelineOptions var1, @Nullable CheckpointMarkT var2);

    @Nullable
    public abstract Coder<CheckpointMarkT> getCheckpointMarkCoder();

    public boolean requiresDeduping() {
        return false;
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    public static abstract class UnboundedReader<OutputT>
    extends Source.Reader<OutputT> {
        private static final byte[] EMPTY = new byte[0];
        public static final long BACKLOG_UNKNOWN = -1L;

        @Override
        public abstract boolean start() throws IOException;

        @Override
        public abstract boolean advance() throws IOException;

        public byte[] getCurrentRecordId() throws NoSuchElementException {
            if (((UnboundedSource)this.getCurrentSource()).requiresDeduping()) {
                throw new IllegalStateException("getCurrentRecordId() must be overridden if requiresDeduping returns true()");
            }
            return EMPTY;
        }

        public abstract Instant getWatermark();

        public abstract CheckpointMark getCheckpointMark();

        public long getSplitBacklogBytes() {
            return -1L;
        }

        public long getTotalBacklogBytes() {
            return -1L;
        }

        public abstract UnboundedSource<OutputT, ?> getCurrentSource();
    }

    public static interface CheckpointMark {
        public void finalizeCheckpoint() throws IOException;
    }
}

