/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.io;

import com.google.cloud.dataflow.sdk.coders.StringUtf8Coder;
import com.google.cloud.dataflow.sdk.io.FileBasedSink;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class XmlSink {
    protected static final String XML_EXTENSION = "xml";

    public static Bound<?> write() {
        return new Bound(null, null, null);
    }

    public static <T> Bound<T> writeOf(Class<T> klass, String rootElementName, String baseOutputFilename) {
        return new Bound(klass, rootElementName, baseOutputFilename);
    }

    protected static final class XmlWriter<T>
    extends FileBasedSink.FileBasedWriter<T> {
        final Marshaller marshaller;
        private OutputStream os = null;

        public XmlWriter(XmlWriteOperation<T> writeOperation, Marshaller marshaller) {
            super(writeOperation);
            this.marshaller = marshaller;
        }

        @Override
        protected void prepareWrite(WritableByteChannel channel) throws Exception {
            this.os = Channels.newOutputStream(channel);
        }

        @Override
        protected void writeHeader() throws Exception {
            String rootElementName = ((Bound)((XmlWriteOperation)this.getWriteOperation()).getSink()).rootElementName;
            this.os.write(CoderUtils.encodeToByteArray(StringUtf8Coder.of(), "<" + rootElementName + ">\n"));
        }

        @Override
        protected void writeFooter() throws Exception {
            String rootElementName = ((Bound)((XmlWriteOperation)this.getWriteOperation()).getSink()).rootElementName;
            this.os.write(CoderUtils.encodeToByteArray(StringUtf8Coder.of(), "\n</" + rootElementName + ">"));
        }

        @Override
        public void write(T value) throws Exception {
            this.marshaller.marshal(value, this.os);
        }

        @Override
        public XmlWriteOperation<T> getWriteOperation() {
            return (XmlWriteOperation)super.getWriteOperation();
        }
    }

    protected static final class XmlWriteOperation<T>
    extends FileBasedSink.FileBasedWriteOperation<T> {
        public XmlWriteOperation(Bound<T> sink) {
            super(sink);
        }

        @Override
        public XmlWriter<T> createWriter(PipelineOptions options) throws Exception {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{((Bound)this.getSink()).classToBind});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            return new XmlWriter(this, marshaller);
        }

        @Override
        public Bound<T> getSink() {
            return (Bound)super.getSink();
        }
    }

    public static class Bound<T>
    extends FileBasedSink<T> {
        final Class<T> classToBind;
        final String rootElementName;

        private Bound(Class<T> classToBind, String rootElementName, String baseOutputFilename) {
            super(baseOutputFilename, XmlSink.XML_EXTENSION);
            this.classToBind = classToBind;
            this.rootElementName = rootElementName;
        }

        public <T> Bound<T> ofRecordClass(Class<T> classToBind) {
            return new Bound<T>(classToBind, this.rootElementName, this.baseOutputFilename);
        }

        public Bound<T> toFilenamePrefix(String baseOutputFilename) {
            return new Bound<T>(this.classToBind, this.rootElementName, baseOutputFilename);
        }

        public Bound<T> withRootElement(String rootElementName) {
            return new Bound<T>(this.classToBind, rootElementName, this.baseOutputFilename);
        }

        @Override
        public void validate(PipelineOptions options) {
            Preconditions.checkNotNull(this.classToBind, "Missing a class to bind to a JAXB context.");
            Preconditions.checkNotNull(this.rootElementName, "Missing a root element name.");
            Preconditions.checkNotNull(this.baseOutputFilename, "Missing a filename to write to.");
            try {
                JAXBContext.newInstance((Class[])new Class[]{this.classToBind});
            }
            catch (JAXBException e) {
                throw new RuntimeException("Error binding classes to a JAXB Context.", e);
            }
        }

        @Override
        public XmlWriteOperation<T> createWriteOperation(PipelineOptions options) {
            return new XmlWriteOperation(this);
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item("rootElement", this.rootElementName).withLabel("XML Root Element")).addIfNotNull(DisplayData.item("recordClass", this.classToBind).withLabel("XML Record Class"));
        }
    }
}

