/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.options.DataflowPipelineOptions;
import com.google.cloud.dataflow.sdk.options.Default;
import com.google.cloud.dataflow.sdk.options.DefaultValueFactory;
import com.google.cloud.dataflow.sdk.options.Description;
import com.google.cloud.dataflow.sdk.options.Hidden;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import java.util.List;
import javax.annotation.Nullable;

@Description(value="Options that are used to configure the Dataflow pipeline worker pool.")
public interface DataflowPipelineWorkerPoolOptions
extends PipelineOptions {
    @Description(value="Number of workers to use when executing the Dataflow job. Note that selection of an autoscaling algorithm other then \"NONE\" will affect the size of the worker pool. If left unspecified, the Dataflow service will determine the number of workers.")
    public int getNumWorkers();

    public void setNumWorkers(int var1);

    @Description(value="[Experimental] The autoscaling algorithm to use for the workerpool. NONE: does not change the size of the worker pool. BASIC (deprecated): autoscale the worker pool size up to maxNumWorkers until the job completes. THROUGHPUT_BASED: autoscale the workerpool based on throughput (up to maxNumWorkers).")
    @Experimental(value=Experimental.Kind.AUTOSCALING)
    public AutoscalingAlgorithmType getAutoscalingAlgorithm();

    public void setAutoscalingAlgorithm(AutoscalingAlgorithmType var1);

    @Description(value="The maximum number of workers to use for the workerpool. This options limits the size of the workerpool for the lifetime of the job, including pipeline updates. If left unspecified, the Dataflow service will compute a ceiling.")
    public int getMaxNumWorkers();

    public void setMaxNumWorkers(int var1);

    @Description(value="Remote worker disk size, in gigabytes, or 0 to use the default size.")
    public int getDiskSizeGb();

    public void setDiskSizeGb(int var1);

    @Default.InstanceFactory(value=WorkerHarnessContainerImageFactory.class)
    @Description(value="Docker container image that executes Dataflow worker harness, residing in Google  Container Registry.")
    @Hidden
    public String getWorkerHarnessContainerImage();

    public void setWorkerHarnessContainerImage(String var1);

    @Description(value="GCE network for launching workers. For more information, see the reference documentation https://cloud.google.com/compute/docs/networking. Default is up to the Dataflow service.")
    public String getNetwork();

    public void setNetwork(String var1);

    @Description(value="GCE subnetwork for launching workers. For more information, see the reference documentation https://cloud.google.com/compute/docs/networking. Default is up to the Dataflow service.")
    public String getSubnetwork();

    public void setSubnetwork(String var1);

    @Description(value="GCE availability zone for launching workers. See https://developers.google.com/compute/docs/zones for a list of valid options. Default is up to the Dataflow service.")
    public String getZone();

    public void setZone(String var1);

    @Description(value="Machine type to create Dataflow worker VMs as. See https://cloud.google.com/compute/docs/machine-types for a list of valid options. If unset, the Dataflow service will choose a reasonable default.")
    public String getWorkerMachineType();

    public void setWorkerMachineType(String var1);

    @Description(value="The teardown policy for the VMs. If unset, the Dataflow service will choose a reasonable default.")
    public TeardownPolicy getTeardownPolicy();

    public void setTeardownPolicy(TeardownPolicy var1);

    @Description(value="Files to stage on GCS and make available to workers. Files are placed on the worker's classpath. The default value is all files from the classpath.")
    @JsonIgnore
    public List<String> getFilesToStage();

    public void setFilesToStage(List<String> var1);

    @Description(value="Specifies what type of persistent disk should be used. The value should be a full or partial URL of a disk type resource, e.g., zones/us-central1-f/disks/pd-standard. For more information, see the API reference documentation for DiskTypes: https://cloud.google.com/compute/docs/reference/latest/diskTypes")
    public String getWorkerDiskType();

    public void setWorkerDiskType(String var1);

    @Description(value="Specifies whether worker pools should be started with public IP addresses. WARNING:This feature is experimental. You must be whitelisted to use it.")
    @JsonIgnore
    @Nullable
    @Experimental
    public Boolean getUsePublicIps();

    public void setUsePublicIps(@Nullable Boolean var1);

    @Deprecated
    public static enum TeardownPolicy {
        TEARDOWN_ALWAYS("TEARDOWN_ALWAYS"),
        TEARDOWN_NEVER("TEARDOWN_NEVER"),
        TEARDOWN_ON_SUCCESS("TEARDOWN_ON_SUCCESS");

        private final String teardownPolicy;

        private TeardownPolicy(String teardownPolicy) {
            this.teardownPolicy = teardownPolicy;
        }

        public String getTeardownPolicyName() {
            return this.teardownPolicy;
        }
    }

    public static class WorkerHarnessContainerImageFactory
    implements DefaultValueFactory<String> {
        @Override
        public String create(PipelineOptions options) {
            DataflowPipelineOptions dataflowOptions = options.as(DataflowPipelineOptions.class);
            if (dataflowOptions.isStreaming()) {
                return "dataflow.gcr.io/v1beta3/java-streaming:1.8.0";
            }
            return "dataflow.gcr.io/v1beta3/java-batch:1.8.0";
        }
    }

    @Experimental(value=Experimental.Kind.AUTOSCALING)
    public static enum AutoscalingAlgorithmType {
        NONE("AUTOSCALING_ALGORITHM_NONE"),
        BASIC("AUTOSCALING_ALGORITHM_BASIC"),
        THROUGHPUT_BASED("AUTOSCALING_ALGORITHM_BASIC");

        private final String algorithm;

        private AutoscalingAlgorithmType(String algorithm) {
            this.algorithm = algorithm;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }
    }
}

