/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.options;

import com.google.cloud.dataflow.sdk.options.Description;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptionsFactory;
import com.google.cloud.dataflow.sdk.options.ProxyInvocationHandler;
import com.google.cloud.dataflow.sdk.options.Validation;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Collections2;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Ordering;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.TreeMultimap;
import com.google.cloud.dataflow.sdk.util.common.ReflectHelpers;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;

public class PipelineOptionsValidator {
    public static <T extends PipelineOptions> T validate(Class<T> klass, PipelineOptions options) {
        Preconditions.checkNotNull(klass);
        Preconditions.checkNotNull(options);
        Preconditions.checkArgument(Proxy.isProxyClass(options.getClass()));
        Preconditions.checkArgument(Proxy.getInvocationHandler(options) instanceof ProxyInvocationHandler);
        T asClassOptions = options.as(klass);
        ProxyInvocationHandler handler = (ProxyInvocationHandler)Proxy.getInvocationHandler(asClassOptions);
        TreeMultimap requiredGroups = TreeMultimap.create(Ordering.natural(), PipelineOptionsFactory.MethodNameComparator.INSTANCE);
        for (Method method : ReflectHelpers.getClosureOfMethodsOnInterface(klass)) {
            Validation.Required requiredAnnotation = method.getAnnotation(Validation.Required.class);
            if (requiredAnnotation == null) continue;
            if (requiredAnnotation.groups().length > 0) {
                for (String requiredGroup : requiredAnnotation.groups()) {
                    requiredGroups.put(requiredGroup, method);
                }
                continue;
            }
            Preconditions.checkArgument(handler.invoke(asClassOptions, method, null) != null, "Missing required value for [" + method + ", \"" + PipelineOptionsValidator.getDescription(method) + "\"]. ");
        }
        for (String requiredGroup : requiredGroups.keySet()) {
            if (PipelineOptionsValidator.verifyGroup(handler, asClassOptions, requiredGroups.get(requiredGroup))) continue;
            throw new IllegalArgumentException("Missing required value for group [" + requiredGroup + "]. At least one of the following properties " + Collections2.transform(requiredGroups.get(requiredGroup), ReflectHelpers.METHOD_FORMATTER) + " required. Run with --help=" + klass.getSimpleName() + " for more information.");
        }
        return asClassOptions;
    }

    private static boolean verifyGroup(ProxyInvocationHandler handler, PipelineOptions options, Collection<Method> requiredGroup) {
        for (Method m : requiredGroup) {
            if (handler.invoke(options, m, null) == null) continue;
            return true;
        }
        return false;
    }

    private static String getDescription(Method method) {
        Description description = method.getAnnotation(Description.class);
        return description == null ? "" : description.value();
    }
}

