/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc;

import com.google.bigtable.v1.BigtableServiceGrpc;
import com.google.bigtable.v1.CheckAndMutateRowRequest;
import com.google.bigtable.v1.CheckAndMutateRowResponse;
import com.google.bigtable.v1.MutateRowRequest;
import com.google.bigtable.v1.MutateRowsRequest;
import com.google.bigtable.v1.MutateRowsResponse;
import com.google.bigtable.v1.Mutation;
import com.google.bigtable.v1.ReadModifyWriteRowRequest;
import com.google.bigtable.v1.ReadRowsRequest;
import com.google.bigtable.v1.ReadRowsResponse;
import com.google.bigtable.v1.Row;
import com.google.bigtable.v1.SampleRowKeysRequest;
import com.google.bigtable.v1.SampleRowKeysResponse;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.BigtableDataClient;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.async.AbstractRetryingRpcListener;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.async.BigtableAsyncUtilities;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.async.RetryingCollectingClientCallListener;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.async.RetryingUnaryRpcListener;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.io.CancellationToken;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.io.ChannelPool;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.scanner.BigtableResultScannerFactory;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.scanner.ReadRowsResponseListener;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.scanner.ResponseQueueReader;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.scanner.ResultScanner;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.scanner.ResumingStreamingResultScanner;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.scanner.RowMerger;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.scanner.StreamingBigtableResultScanner;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Function;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Predicate;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Predicates;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.Futures;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.ServiceException;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.Status;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

public class BigtableDataGrpcClient
implements BigtableDataClient {
    private static final Logger LOG = new Logger(BigtableDataGrpcClient.class);
    @VisibleForTesting
    public static final Predicate<MutateRowRequest> IS_RETRYABLE_MUTATION = new Predicate<MutateRowRequest>(){

        @Override
        public boolean apply(MutateRowRequest mutateRowRequest) {
            return mutateRowRequest != null && BigtableDataGrpcClient.allCellsHaveTimestamps(mutateRowRequest.getMutationsList());
        }
    };
    @VisibleForTesting
    public static final Predicate<MutateRowsRequest> ARE_RETRYABLE_MUTATIONS = new Predicate<MutateRowsRequest>(){

        @Override
        public boolean apply(MutateRowsRequest mutateRowsRequest) {
            if (mutateRowsRequest == null) {
                return false;
            }
            for (MutateRowsRequest.Entry entry : mutateRowsRequest.getEntriesList()) {
                if (BigtableDataGrpcClient.allCellsHaveTimestamps(entry.getMutationsList())) continue;
                return false;
            }
            return true;
        }
    };
    @VisibleForTesting
    public static final Predicate<CheckAndMutateRowRequest> IS_RETRYABLE_CHECK_AND_MUTATE = new Predicate<CheckAndMutateRowRequest>(){

        @Override
        public boolean apply(CheckAndMutateRowRequest checkAndMutateRowRequest) {
            return checkAndMutateRowRequest != null && BigtableDataGrpcClient.allCellsHaveTimestamps(checkAndMutateRowRequest.getTrueMutationsList()) && BigtableDataGrpcClient.allCellsHaveTimestamps(checkAndMutateRowRequest.getFalseMutationsList());
        }
    };
    private static Function<List<ReadRowsResponse>, List<Row>> ROW_TRANSFORMER = new Function<List<ReadRowsResponse>, List<Row>>(){

        @Override
        public List<Row> apply(List<ReadRowsResponse> responses) {
            ArrayList<Row> result = new ArrayList<Row>();
            Iterator<ReadRowsResponse> responseIterator = responses.iterator();
            while (responseIterator.hasNext()) {
                result.add(RowMerger.readNextRow(responseIterator));
            }
            return result;
        }
    };
    private final ChannelPool channelPool;
    private final ScheduledExecutorService retryExecutorService;
    private final RetryOptions retryOptions;
    private final BigtableOptions bigtableOptions;
    private final BigtableResultScannerFactory streamingScannerFactory = new BigtableResultScannerFactory(){

        @Override
        public ResultScanner<Row> createScanner(ReadRowsRequest request) {
            return BigtableDataGrpcClient.this.streamRows(request);
        }
    };
    private final BigtableAsyncUtilities asyncUtilities;
    private final BigtableAsyncRpc<SampleRowKeysRequest, SampleRowKeysResponse> sampleRowKeysAsync;
    private final BigtableAsyncRpc<ReadRowsRequest, ReadRowsResponse> readRowsAsync;
    private final BigtableAsyncRpc<MutateRowRequest, Empty> mutateRowRpc;
    private final BigtableAsyncRpc<MutateRowsRequest, MutateRowsResponse> mutateRowsRpc;
    private final BigtableAsyncRpc<CheckAndMutateRowRequest, CheckAndMutateRowResponse> checkAndMutateRpc;
    private final BigtableAsyncRpc<ReadModifyWriteRowRequest, Row> readWriteModifyRpc;

    private static final boolean allCellsHaveTimestamps(Iterable<Mutation> mutations) {
        for (Mutation mut : mutations) {
            if (mut.getSetCell().getTimestampMicros() > 0L) continue;
            return false;
        }
        return true;
    }

    public BigtableDataGrpcClient(ChannelPool channelPool, ScheduledExecutorService retryExecutorService, BigtableOptions bigtableOptions) {
        this(channelPool, retryExecutorService, bigtableOptions, new BigtableAsyncUtilities.Default((Channel)channelPool));
    }

    @VisibleForTesting
    BigtableDataGrpcClient(ChannelPool channelPool, ScheduledExecutorService retryExecutorService, BigtableOptions bigtableOptions, BigtableAsyncUtilities asyncUtilities) {
        this.channelPool = channelPool;
        this.retryExecutorService = retryExecutorService;
        this.bigtableOptions = bigtableOptions;
        this.retryOptions = bigtableOptions.getRetryOptions();
        this.asyncUtilities = asyncUtilities;
        this.sampleRowKeysAsync = asyncUtilities.createStreamingAsyncRpc(BigtableServiceGrpc.METHOD_SAMPLE_ROW_KEYS);
        this.readRowsAsync = asyncUtilities.createStreamingAsyncRpc(BigtableServiceGrpc.METHOD_READ_ROWS);
        this.mutateRowRpc = asyncUtilities.createAsyncUnaryRpc(BigtableServiceGrpc.METHOD_MUTATE_ROW, this.getMutationRetryableFunction(IS_RETRYABLE_MUTATION));
        this.mutateRowsRpc = asyncUtilities.createAsyncUnaryRpc(BigtableServiceGrpc.METHOD_MUTATE_ROWS, this.getMutationRetryableFunction(ARE_RETRYABLE_MUTATIONS));
        this.checkAndMutateRpc = asyncUtilities.createAsyncUnaryRpc(BigtableServiceGrpc.METHOD_CHECK_AND_MUTATE_ROW, this.getMutationRetryableFunction(IS_RETRYABLE_CHECK_AND_MUTATE));
        this.readWriteModifyRpc = asyncUtilities.createAsyncUnaryRpc(BigtableServiceGrpc.METHOD_READ_MODIFY_WRITE_ROW, Predicates.alwaysFalse());
    }

    private <T> Predicate<T> getMutationRetryableFunction(Predicate<T> isRetryableMutation) {
        if (this.retryOptions.allowRetriesWithoutTimestamp()) {
            return Predicates.alwaysTrue();
        }
        return isRetryableMutation;
    }

    @Override
    public Empty mutateRow(MutateRowRequest request) throws ServiceException {
        return this.getBlockingUnaryResult(request, this.mutateRowRpc);
    }

    @Override
    public ListenableFuture<Empty> mutateRowAsync(MutateRowRequest request) {
        return this.getUnaryFuture(request, this.mutateRowRpc);
    }

    @Override
    public MutateRowsResponse mutateRows(MutateRowsRequest request) throws ServiceException {
        return this.getBlockingUnaryResult(request, this.mutateRowsRpc);
    }

    @Override
    public ListenableFuture<MutateRowsResponse> mutateRowsAsync(MutateRowsRequest request) {
        return this.getUnaryFuture(request, this.mutateRowsRpc);
    }

    @Override
    public CheckAndMutateRowResponse checkAndMutateRow(CheckAndMutateRowRequest request) throws ServiceException {
        return this.getBlockingUnaryResult(request, this.checkAndMutateRpc);
    }

    @Override
    public ListenableFuture<CheckAndMutateRowResponse> checkAndMutateRowAsync(CheckAndMutateRowRequest request) {
        return this.getUnaryFuture(request, this.checkAndMutateRpc);
    }

    @Override
    public Row readModifyWriteRow(ReadModifyWriteRowRequest request) {
        return this.getBlockingUnaryResult(request, this.readWriteModifyRpc);
    }

    @Override
    public ListenableFuture<Row> readModifyWriteRowAsync(ReadModifyWriteRowRequest request) {
        return this.getUnaryFuture(request, this.readWriteModifyRpc);
    }

    @Override
    public ImmutableList<SampleRowKeysResponse> sampleRowKeys(SampleRowKeysRequest request) {
        return ImmutableList.copyOf(this.getBlockingStreamingResult(request, this.sampleRowKeysAsync));
    }

    @Override
    public ListenableFuture<List<SampleRowKeysResponse>> sampleRowKeysAsync(SampleRowKeysRequest request) {
        return this.getStreamingFuture(request, this.sampleRowKeysAsync);
    }

    @Override
    public ListenableFuture<List<Row>> readRowsAsync(ReadRowsRequest request) {
        return Futures.transform(this.getStreamingFuture(request, this.readRowsAsync), ROW_TRANSFORMER);
    }

    protected <ReqT, RespT> ListenableFuture<List<RespT>> getStreamingFuture(ReqT request, BigtableAsyncRpc<ReqT, RespT> rpc) {
        return BigtableDataGrpcClient.getCompletionFuture(new RetryingCollectingClientCallListener<ReqT, RespT>(this.retryOptions, request, rpc, this.retryExecutorService));
    }

    private <ReqT, RespT> List<RespT> getBlockingStreamingResult(ReqT request, BigtableAsyncRpc<ReqT, RespT> rpc) {
        return (List)BigtableDataGrpcClient.getBlockingResult(new RetryingCollectingClientCallListener<ReqT, RespT>(this.retryOptions, request, rpc, this.retryExecutorService));
    }

    private <ReqT, RespT> ListenableFuture<RespT> getUnaryFuture(ReqT request, BigtableAsyncRpc<ReqT, RespT> rpc) {
        this.expandPoolIfNecessary(this.bigtableOptions.getChannelCount());
        return BigtableDataGrpcClient.getCompletionFuture(new RetryingUnaryRpcListener<ReqT, RespT>(this.retryOptions, request, rpc, this.retryExecutorService));
    }

    private <ReqT, RespT> RespT getBlockingUnaryResult(ReqT request, BigtableAsyncRpc<ReqT, RespT> rpc) {
        return (RespT)BigtableDataGrpcClient.getBlockingResult(new RetryingUnaryRpcListener<ReqT, RespT>(this.retryOptions, request, rpc, this.retryExecutorService));
    }

    private static <ReqT, RespT, OutputT> ListenableFuture<OutputT> getCompletionFuture(AbstractRetryingRpcListener<ReqT, RespT, OutputT> listener) {
        listener.run();
        return listener.getCompletionFuture();
    }

    private static <ReqT, RespT, OutputT> OutputT getBlockingResult(AbstractRetryingRpcListener<ReqT, RespT, OutputT> listener) {
        try {
            listener.run();
            return (OutputT)listener.getCompletionFuture().get();
        }
        catch (InterruptedException e) {
            listener.cancel();
            Thread.currentThread().interrupt();
            throw Status.CANCELLED.withCause((Throwable)e).asRuntimeException();
        }
        catch (ExecutionException e) {
            listener.cancel();
            throw Status.fromThrowable((Throwable)e).asRuntimeException();
        }
    }

    @Override
    public ResultScanner<Row> readRows(ReadRowsRequest request) {
        if (this.retryOptions.enableRetries()) {
            return new ResumingStreamingResultScanner(this.retryOptions, request, this.streamingScannerFactory);
        }
        return this.streamRows(request);
    }

    private ResultScanner<Row> streamRows(ReadRowsRequest request) {
        int streamingBufferSize;
        int batchRequestSize;
        boolean isGet;
        this.expandPoolIfNecessary(this.bigtableOptions.getChannelCount());
        boolean bl = isGet = request.getTargetCase() == ReadRowsRequest.TargetCase.ROW_KEY;
        if (isGet) {
            batchRequestSize = 1;
            streamingBufferSize = 10;
        } else {
            batchRequestSize = this.retryOptions.getStreamingBatchSize();
            streamingBufferSize = this.retryOptions.getStreamingBufferSize();
        }
        ClientCall readRowsCall = this.channelPool.newCall(BigtableServiceGrpc.METHOD_READ_ROWS, CallOptions.DEFAULT);
        int timeout = this.retryOptions.getReadPartialRowTimeoutMillis();
        AtomicInteger outstandingRequestCount = new AtomicInteger(batchRequestSize);
        ResponseQueueReader responseQueueReader = new ResponseQueueReader(timeout, streamingBufferSize, outstandingRequestCount, batchRequestSize, readRowsCall);
        ReadRowsResponseListener listener = new ReadRowsResponseListener(responseQueueReader, outstandingRequestCount);
        this.asyncUtilities.asyncServerStreamingCall(readRowsCall, request, listener);
        CancellationToken cancellationToken = this.createCancellationToken(readRowsCall);
        return new StreamingBigtableResultScanner(responseQueueReader, cancellationToken);
    }

    private CancellationToken createCancellationToken(final ClientCall<ReadRowsRequest, ReadRowsResponse> readRowsCall) {
        CancellationToken cancellationToken = new CancellationToken();
        cancellationToken.addListener(new Runnable(){

            @Override
            public void run() {
                readRowsCall.cancel();
            }
        }, MoreExecutors.directExecutor());
        return cancellationToken;
    }

    private void expandPoolIfNecessary(int channelCount) {
        try {
            this.channelPool.ensureChannelCount(channelCount);
        }
        catch (IOException e) {
            LOG.info("Could not expand the channel pool.", e, new Object[0]);
        }
    }
}

