/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.async;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.Sleeper;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.scanner.BigtableRetriesExhaustedException;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.AbstractFuture;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.ListenableFuture;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public abstract class AbstractRetryingRpcListener<RequestT, ResponseT, ResultT>
extends ClientCall.Listener<ResponseT>
implements Runnable {
    protected static final Logger LOG = new Logger(AbstractRetryingRpcListener.class);
    @VisibleForTesting
    BackOff currentBackoff;
    @VisibleForTesting
    Sleeper sleeper = Sleeper.DEFAULT;
    private final BigtableAsyncRpc<RequestT, ResponseT> rpc;
    private final RetryOptions retryOptions;
    private final RequestT request;
    private final ScheduledExecutorService retryExecutorService;
    private int failedCount;
    protected final GrpcFuture<ResultT> completionFuture = new GrpcFuture();
    protected ClientCall<RequestT, ResponseT> call;

    public AbstractRetryingRpcListener(RetryOptions retryOptions, RequestT request, BigtableAsyncRpc<RequestT, ResponseT> retryableRpc, ScheduledExecutorService retryExecutorService) {
        this.retryOptions = retryOptions;
        this.request = request;
        this.rpc = retryableRpc;
        this.retryExecutorService = retryExecutorService;
    }

    public void onClose(Status status, Metadata trailers) {
        if (status.isOk()) {
            this.onOK();
        } else {
            Status.Code code = status.getCode();
            if (this.retryOptions.enableRetries() && this.retryOptions.isRetryable(code) && this.rpc.isRetryable(this.request)) {
                this.backOffAndRetry(status);
            } else {
                this.completionFuture.setException(status.asRuntimeException());
            }
        }
    }

    protected abstract void onOK();

    private void backOffAndRetry(Status status) {
        long nextBackOff = this.getNextBackoff();
        ++this.failedCount;
        if (nextBackOff == -1L) {
            String message = String.format("Exhausted retries after %d failures.", this.failedCount);
            StatusRuntimeException cause = status.asRuntimeException();
            this.completionFuture.setException(new BigtableRetriesExhaustedException(message, cause));
            return;
        }
        LOG.info("Retrying failed call. Failure #%d, got: %s", status.getCause(), this.failedCount, status);
        if (this.call != null) {
            this.call.cancel();
            this.call = null;
        }
        this.retryExecutorService.schedule(this, nextBackOff, TimeUnit.MILLISECONDS);
    }

    private long getNextBackoff() {
        if (this.currentBackoff == null) {
            this.currentBackoff = this.retryOptions.createBackoff();
        }
        try {
            return this.currentBackoff.nextBackOffMillis();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    public ListenableFuture<ResultT> getCompletionFuture() {
        return this.completionFuture;
    }

    @Override
    public void run() {
        this.call = this.rpc.call(this.request, this);
    }

    public void cancel() {
        if (this.call != null) {
            this.call.cancel();
        }
    }

    protected class GrpcFuture<RespT>
    extends AbstractFuture<RespT> {
        protected GrpcFuture() {
        }

        @Override
        protected void interruptTask() {
            if (AbstractRetryingRpcListener.this.call != null) {
                AbstractRetryingRpcListener.this.call.cancel();
            }
        }

        @Override
        protected boolean set(@Nullable RespT resp) {
            return super.set(resp);
        }

        @Override
        protected boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }
    }
}

