/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.async;

import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Predicate;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Throwables;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

public interface BigtableAsyncUtilities {
    public <RequestT, ResponseT> BigtableAsyncRpc<RequestT, ResponseT> createStreamingAsyncRpc(MethodDescriptor<RequestT, ResponseT> var1);

    public <RequestT, ResponseT> BigtableAsyncRpc<RequestT, ResponseT> createAsyncUnaryRpc(MethodDescriptor<RequestT, ResponseT> var1, Predicate<RequestT> var2);

    public <RequestT, ResponseT> void asyncServerStreamingCall(ClientCall<RequestT, ResponseT> var1, RequestT var2, ClientCall.Listener<ResponseT> var3);

    public static class Default
    implements BigtableAsyncUtilities {
        private final Channel channel;

        public Default(Channel channel) {
            this.channel = channel;
        }

        @Override
        public <RequestT, ResponseT> BigtableAsyncRpc<RequestT, ResponseT> createAsyncUnaryRpc(final MethodDescriptor<RequestT, ResponseT> method, final Predicate<RequestT> isRetryable) {
            return new BigtableAsyncRpc<RequestT, ResponseT>(){

                @Override
                public ClientCall<RequestT, ResponseT> call(RequestT request, ClientCall.Listener<ResponseT> listener) {
                    return Default.this.createCall(Default.this.channel, method, request, listener, 1);
                }

                @Override
                public boolean isRetryable(RequestT request) {
                    return isRetryable.apply(request);
                }
            };
        }

        @Override
        public <RequestT, ResponseT> BigtableAsyncRpc<RequestT, ResponseT> createStreamingAsyncRpc(final MethodDescriptor<RequestT, ResponseT> method) {
            return new BigtableAsyncRpc<RequestT, ResponseT>(){

                @Override
                public boolean isRetryable(RequestT request) {
                    return true;
                }

                @Override
                public ClientCall<RequestT, ResponseT> call(RequestT request, ClientCall.Listener<ResponseT> listener) {
                    return Default.this.createCall(Default.this.channel, method, request, listener, 1);
                }
            };
        }

        @Override
        public <RequestT, ResponseT> void asyncServerStreamingCall(ClientCall<RequestT, ResponseT> call, RequestT request, ClientCall.Listener<ResponseT> listener) {
            Default.start(call, request, listener, 1);
        }

        private <RequestT, ResponseT> ClientCall<RequestT, ResponseT> createCall(Channel channel, MethodDescriptor<RequestT, ResponseT> method, RequestT request, ClientCall.Listener<ResponseT> listener, int count) {
            ClientCall call = channel.newCall(method, CallOptions.DEFAULT);
            Default.start(call, request, listener, count);
            return call;
        }

        private static <RequestT, ResponseT> void start(ClientCall<RequestT, ResponseT> call, RequestT request, ClientCall.Listener<ResponseT> listener, int requestCount) {
            call.start(listener, new Metadata());
            call.request(requestCount);
            try {
                call.sendMessage(request);
                call.halfClose();
            }
            catch (Throwable t) {
                call.cancel();
                throw Throwables.propagate(t);
            }
        }
    }
}

