/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.async;

import com.google.api.client.util.NanoClock;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.async.ResourceLimiter;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.FutureCallback;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.Futures;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.ListenableFuture;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class RpcThrottler {
    protected static final Logger LOG = new Logger(RpcThrottler.class);
    private static final long DEFAULT_FINISH_WAIT_MILLIS = 250L;
    private static final long INTERVAL_NO_SUCCESS_WARNING_NANOS = 300000000L;
    private final ResourceLimiter resourceLimiter;
    private final NanoClock clock;
    private final long finishWaitMillis;
    private ReentrantLock lock = new ReentrantLock();
    private Condition flushedCondition = this.lock.newCondition();
    private Set<Long> outstandingRequests = new HashSet<Long>();
    private Set<Long> outstandingRetries = new HashSet<Long>();
    private AtomicLong retrySequenceGenerator = new AtomicLong();
    private long noSuccessWarningDeadline;
    private int noSuccessWarningCount;

    public RpcThrottler(ResourceLimiter resourceLimiter) {
        this(resourceLimiter, NanoClock.SYSTEM, 250L);
    }

    @VisibleForTesting
    RpcThrottler(ResourceLimiter resourceLimiter, NanoClock clock, long finishWaitMillis) {
        this.resourceLimiter = resourceLimiter;
        this.clock = clock;
        this.finishWaitMillis = finishWaitMillis;
        this.resetNoSuccessWarningDeadline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long registerOperationWithHeapSize(long heapSize) throws InterruptedException {
        long id = this.resourceLimiter.registerOperationWithHeapSize(heapSize);
        this.lock.lock();
        try {
            this.outstandingRequests.add(id);
        }
        finally {
            this.lock.unlock();
        }
        return id;
    }

    public <T> FutureCallback<T> addCallback(ListenableFuture<T> future, final long id) {
        FutureCallback callback = new FutureCallback<T>(){

            @Override
            public void onSuccess(T result) {
                RpcThrottler.this.onRpcCompletion(id);
            }

            @Override
            public void onFailure(Throwable t) {
                RpcThrottler.this.onRpcCompletion(id);
            }
        };
        Futures.addCallback(future, callback);
        return callback;
    }

    public <T> long registerRetry() {
        long id = this.retrySequenceGenerator.incrementAndGet();
        this.lock.lock();
        try {
            this.outstandingRetries.add(id);
        }
        finally {
            this.lock.unlock();
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitCompletion() throws InterruptedException {
        boolean performedWarning = false;
        this.lock.lock();
        try {
            while (!this.isFlushed()) {
                this.flushedCondition.await(this.finishWaitMillis, TimeUnit.MILLISECONDS);
                long now = this.clock.nanoTime();
                if (now < this.noSuccessWarningDeadline) continue;
                this.logNoSuccessWarning(now);
                this.resetNoSuccessWarningDeadline();
                performedWarning = true;
            }
            if (performedWarning) {
                LOG.info("awaitCompletion() completed", new Object[0]);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void logNoSuccessWarning(long now) {
        long lastUpdated = TimeUnit.NANOSECONDS.toSeconds(now - this.noSuccessWarningDeadline + 300000000L);
        LOG.warn("No operations completed within the last %d seconds. There are still %d rpcs and %d retries in progress.", lastUpdated, this.outstandingRequests.size(), this.outstandingRetries.size());
        ++this.noSuccessWarningCount;
    }

    public long getMaxHeapSize() {
        return this.resourceLimiter.getMaxHeapSize();
    }

    public boolean hasInflightRequests() {
        this.lock.lock();
        try {
            boolean bl = this.outstandingRequests.size() > 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isFlushed() {
        return this.outstandingRequests.isEmpty() && this.outstandingRetries.isEmpty();
    }

    @VisibleForTesting
    void resetNoSuccessWarningDeadline() {
        this.noSuccessWarningDeadline = this.clock.nanoTime() + 300000000L;
    }

    @VisibleForTesting
    int getNoSuccessWarningCount() {
        return this.noSuccessWarningCount;
    }

    @VisibleForTesting
    void onRpcCompletion(long id) {
        this.resourceLimiter.markCanBeCompleted(id);
        this.lock.lock();
        try {
            this.outstandingRequests.remove(id);
            if (this.isFlushed()) {
                this.flushedCondition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
        this.resetNoSuccessWarningDeadline();
    }

    public void onRetryCompletion(long id) {
        this.lock.lock();
        try {
            this.outstandingRetries.remove(id);
            if (this.isFlushed()) {
                this.flushedCondition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
        this.resetNoSuccessWarningDeadline();
    }
}

