/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.io;

import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.io.HeaderInterceptor;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptors;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class ChannelPool
extends ManagedChannel {
    protected static final Logger LOG = new Logger(ChannelPool.class);
    private final AtomicReference<ImmutableList<ManagedChannel>> channels = new AtomicReference();
    private final AtomicInteger requestCount = new AtomicInteger();
    private final ImmutableList<HeaderInterceptor> headerInterceptors;
    private final ChannelFactory factory;
    private final String authority;
    private boolean shutdown = false;

    public ChannelPool(List<HeaderInterceptor> headerInterceptors, ChannelFactory factory) throws IOException {
        ManagedChannel channel = factory.create();
        this.channels.set(ImmutableList.of(channel));
        this.authority = channel.authority();
        this.factory = factory;
        this.headerInterceptors = headerInterceptors == null ? ImmutableList.of() : ImmutableList.copyOf(headerInterceptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureChannelCount(int capacity) throws IOException {
        if (this.shutdown) {
            throw new IOException("The channel is closed.");
        }
        if (this.channels.get().size() < capacity) {
            ChannelPool channelPool = this;
            synchronized (channelPool) {
                if (this.channels.get().size() < capacity) {
                    ArrayList<ManagedChannel> newChannelList = new ArrayList<ManagedChannel>((Collection)this.channels.get());
                    while (newChannelList.size() < capacity) {
                        newChannelList.add(this.factory.create());
                    }
                    this.setChannels(newChannelList);
                }
            }
        }
    }

    private ManagedChannel getNextChannel() {
        int currentRequestNum = this.requestCount.getAndIncrement();
        ImmutableList<ManagedChannel> channelsList = this.channels.get();
        int index = Math.abs(currentRequestNum % channelsList.size());
        return (ManagedChannel)channelsList.get(index);
    }

    public String authority() {
        return this.authority;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions) {
        Preconditions.checkState(!this.shutdown, "Cannot perform operations on a closed connection");
        return this.createWrappedCall(methodDescriptor, callOptions, this.getNextChannel());
    }

    private <ReqT, RespT> ClientCall<ReqT, RespT> createWrappedCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, ManagedChannel channel) {
        ClientCall delegate = channel.newCall(methodDescriptor, callOptions);
        return new ClientInterceptors.CheckedForwardingClientCall<ReqT, RespT>(delegate){

            protected void checkedStart(ClientCall.Listener<RespT> responseListener, Metadata headers) throws Exception {
                for (HeaderInterceptor interceptor : ChannelPool.this.headerInterceptors) {
                    interceptor.updateHeaders(headers);
                }
                this.delegate().start(responseListener, headers);
            }
        };
    }

    private void setChannels(List<ManagedChannel> newChannelList) {
        this.channels.set(ImmutableList.copyOf(newChannelList));
    }

    public int size() {
        return this.channels.get().size();
    }

    public synchronized ManagedChannel shutdown() {
        for (ManagedChannel channel : this.channels.get()) {
            channel.shutdown();
        }
        this.shutdown = true;
        return this;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public boolean isTerminated() {
        for (ManagedChannel managedChannel : this.channels.get()) {
            if (managedChannel.isTerminated()) continue;
            return false;
        }
        return true;
    }

    public ManagedChannel shutdownNow() {
        for (ManagedChannel channel : this.channels.get()) {
            channel.shutdownNow();
        }
        return this;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long endTimeNanos = System.nanoTime() + unit.toNanos(timeout);
        for (ManagedChannel channel : this.channels.get()) {
            long awaitTimeNanos = endTimeNanos - System.nanoTime();
            if (awaitTimeNanos <= 0L) break;
            channel.awaitTermination(awaitTimeNanos, TimeUnit.NANOSECONDS);
        }
        return this.isTerminated();
    }

    public static interface ChannelFactory {
        public ManagedChannel create() throws IOException;
    }
}

