/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.io;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.Clock;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.Sleeper;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.io.HeaderInterceptor;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import io.grpc.Metadata;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public class RefreshingOAuth2CredentialsInterceptor
implements HeaderInterceptor {
    private static final Logger LOG = new Logger(RefreshingOAuth2CredentialsInterceptor.class);
    private static final Metadata.Key<String> AUTHORIZATION_HEADER_KEY = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    @VisibleForTesting
    static Clock clock = Clock.SYSTEM;
    @VisibleForTesting
    final AtomicReference<HeaderCacheElement> headerCache = new AtomicReference();
    @VisibleForTesting
    final AtomicBoolean isRefreshing = new AtomicBoolean(false);
    @VisibleForTesting
    Sleeper sleeper = Sleeper.DEFAULT;
    private final ExecutorService executor;
    private final OAuth2Credentials credentials;
    private final RetryOptions retryOptions;
    private final Logger logger;

    public RefreshingOAuth2CredentialsInterceptor(ExecutorService scheduler, OAuth2Credentials credentials, RetryOptions retryOptions) {
        this(scheduler, credentials, retryOptions, LOG);
    }

    @VisibleForTesting
    RefreshingOAuth2CredentialsInterceptor(ExecutorService scheduler, OAuth2Credentials credentials, RetryOptions retryOptions, Logger logger) {
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)scheduler);
        this.credentials = (OAuth2Credentials)Preconditions.checkNotNull((Object)credentials);
        this.retryOptions = (RetryOptions)Preconditions.checkNotNull((Object)retryOptions);
        this.logger = (Logger)Preconditions.checkNotNull((Object)logger);
    }

    @Override
    public void updateHeaders(Metadata headers) throws Exception {
        headers.put(AUTHORIZATION_HEADER_KEY, (Object)this.getHeader());
    }

    public void asyncRefresh() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                RefreshingOAuth2CredentialsInterceptor.this.doRefresh();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncRefresh() throws IOException {
        AtomicBoolean atomicBoolean = this.isRefreshing;
        synchronized (atomicBoolean) {
            if (!this.isRefreshing.get()) {
                this.doRefresh();
            } else {
                while (this.isRefreshing.get() && RefreshingOAuth2CredentialsInterceptor.getCacheState(this.headerCache.get()) != CacheState.Good) {
                    try {
                        this.isRefreshing.wait(250L);
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
            }
        }
    }

    @VisibleForTesting
    String getHeader() throws IOException {
        HeaderCacheElement headerCache = this.getCachedHeader();
        CacheState state = RefreshingOAuth2CredentialsInterceptor.getCacheState(headerCache);
        switch (state) {
            case Good: {
                break;
            }
            case Stale: {
                this.asyncRefresh();
                break;
            }
            case Expired: {
                this.syncRefresh();
                headerCache = this.getCachedHeader();
                break;
            }
            default: {
                throw new IllegalStateException("Could not process state: " + (Object)((Object)state));
            }
        }
        return headerCache.header;
    }

    @VisibleForTesting
    static CacheState getCacheState(HeaderCacheElement headerCache) {
        return headerCache == null ? CacheState.Expired : headerCache.getCacheState();
    }

    private HeaderCacheElement getCachedHeader() throws IOException {
        HeaderCacheElement headerCache = this.headerCache.get();
        if (headerCache != null && headerCache.exception != null) {
            throw headerCache.exception;
        }
        return headerCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean doRefresh() {
        boolean requiresRefresh = false;
        AtomicBoolean atomicBoolean = this.isRefreshing;
        synchronized (atomicBoolean) {
            if (!this.isRefreshing.get() && RefreshingOAuth2CredentialsInterceptor.getCacheState(this.headerCache.get()) != CacheState.Good) {
                this.isRefreshing.set(true);
                requiresRefresh = true;
            }
        }
        if (!requiresRefresh) {
            return false;
        }
        HeaderCacheElement cacheElement = this.refreshCredentialsWithRetry();
        AtomicBoolean atomicBoolean2 = this.isRefreshing;
        synchronized (atomicBoolean2) {
            this.headerCache.set(cacheElement);
            this.isRefreshing.set(false);
            this.isRefreshing.notifyAll();
        }
        return true;
    }

    protected HeaderCacheElement refreshCredentialsWithRetry() {
        BackOff backoff = null;
        while (true) {
            try {
                this.logger.info("Refreshing the OAuth token", new Object[0]);
                AccessToken newToken = this.credentials.refreshAccessToken();
                if (newToken == null) {
                    this.logger.info("Refreshed the OAuth token", new Object[0]);
                    return new HeaderCacheElement(new IOException("Could not load the token for credentials: " + this.credentials));
                }
                return new HeaderCacheElement(newToken);
            }
            catch (IOException exception) {
                this.logger.warn("Got an unexpected IOException when refreshing google credentials.", exception, new Object[0]);
                if (backoff == null) {
                    backoff = this.retryOptions.createBackoff();
                }
                try {
                    RetryState retryState;
                    if ((retryState = this.getRetryState(backoff)) == RetryState.PerformRetry) continue;
                    return new HeaderCacheElement(exception);
                }
                catch (IOException e) {
                    this.logger.warn("Got an exception while trying to run backoff.nextBackOffMillis()", e, new Object[0]);
                    return new HeaderCacheElement(exception);
                }
            }
            catch (Exception e) {
                this.logger.warn("Got an unexpected exception while trying to refresh google credentials.", e, new Object[0]);
                return new HeaderCacheElement(new IOException("Could not read headers", e));
            }
            break;
        }
    }

    protected RetryState getRetryState(BackOff backoff) throws IOException {
        long nextBackOffMillis = backoff.nextBackOffMillis();
        if (nextBackOffMillis == -1L) {
            this.logger.warn("Exhausted the number of retries for credentials refresh after " + this.retryOptions.getMaxElaspedBackoffMillis() + " milliseconds.", new Object[0]);
            return RetryState.RetriesExhausted;
        }
        try {
            this.sleeper.sleep(nextBackOffMillis);
            return RetryState.PerformRetry;
        }
        catch (InterruptedException e) {
            this.logger.warn("Interrupted while trying to refresh credentials.", new Object[0]);
            Thread.interrupted();
            return RetryState.Interrupted;
        }
    }

    @VisibleForTesting
    static class HeaderCacheElement {
        public static final int TOKEN_STALENESS_MS = 75000;
        public static final int TOKEN_EXPIRES_MS = 45000;
        final IOException exception;
        final String header;
        @Nullable
        final Long staleTimeMs;
        @Nullable
        final Long expiresTimeMs;

        public HeaderCacheElement(AccessToken token) {
            this.exception = null;
            this.header = "Bearer " + token.getTokenValue();
            Date expirationTime = token.getExpirationTime();
            if (expirationTime != null) {
                long tokenExpiresTime = expirationTime.getTime();
                this.staleTimeMs = tokenExpiresTime - 75000L;
                this.expiresTimeMs = tokenExpiresTime - 45000L;
                Preconditions.checkState((this.staleTimeMs < this.expiresTimeMs ? 1 : 0) != 0);
            } else {
                this.staleTimeMs = null;
                this.expiresTimeMs = null;
            }
        }

        public HeaderCacheElement(IOException exception) {
            this.exception = exception;
            this.header = null;
            this.staleTimeMs = null;
            this.expiresTimeMs = null;
        }

        public CacheState getCacheState() {
            if (this.exception != null) {
                return CacheState.Exception;
            }
            long now = clock.currentTimeMillis();
            if (this.staleTimeMs == null || now < this.staleTimeMs) {
                return CacheState.Good;
            }
            if (now < this.expiresTimeMs) {
                return CacheState.Stale;
            }
            return CacheState.Expired;
        }
    }

    static enum RetryState {
        PerformRetry,
        RetriesExhausted,
        Interrupted;

    }

    @VisibleForTesting
    static enum CacheState {
        Good,
        Stale,
        Expired,
        Exception;

    }
}

