/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.scanner;

import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.io.IOExceptionWithStatus;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Objects;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import io.grpc.Status;
import java.io.IOException;

abstract class ResultQueueEntry<T> {
    private static final ResultQueueEntry COMPLETION_ENTRY = new ResultQueueEntry(){

        @Override
        public boolean isCompletionMarker() {
            return true;
        }

        public Object getResponseOrThrow() throws IOException {
            throw new IOException("Attempt to interpret a result stream completion marker as a result");
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ResultQueueEntry) || obj == null) {
                return false;
            }
            ResultQueueEntry other = (ResultQueueEntry)obj;
            return this.isCompletionMarker() == other.isCompletionMarker();
        }
    };

    ResultQueueEntry() {
    }

    public static <T> ResultQueueEntry<T> fromResponse(T response) {
        Preconditions.checkArgument(response != null, "Response may not be null");
        return new ResponseResultQueueEntry(response);
    }

    public static <T> ResultQueueEntry<T> fromThrowable(Throwable throwable) {
        Preconditions.checkArgument(throwable != null, "Throwable may not be null");
        return new ExceptionResultQueueEntry(throwable);
    }

    public static <T> ResultQueueEntry<T> completionMarker() {
        return COMPLETION_ENTRY;
    }

    public abstract boolean isCompletionMarker();

    public abstract T getResponseOrThrow() throws IOException;

    private static final class ResponseResultQueueEntry<T>
    extends ResultQueueEntry<T> {
        private final T response;

        private ResponseResultQueueEntry(T response) {
            this.response = response;
        }

        @Override
        public boolean isCompletionMarker() {
            return false;
        }

        @Override
        public T getResponseOrThrow() throws IOException {
            return this.response;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ResponseResultQueueEntry) || obj == null) {
                return false;
            }
            ResponseResultQueueEntry other = (ResponseResultQueueEntry)obj;
            return Objects.equal(this.response, other.response);
        }
    }

    private static final class ExceptionResultQueueEntry<T>
    extends ResultQueueEntry<T> {
        private static final String EXCEPTION_MESSAGE = "Error in response stream";
        private final Throwable throwable;

        private ExceptionResultQueueEntry(Throwable throwable) {
            this.throwable = throwable;
        }

        @Override
        public boolean isCompletionMarker() {
            return false;
        }

        @Override
        public T getResponseOrThrow() throws IOException {
            throw new IOExceptionWithStatus(EXCEPTION_MESSAGE, this.throwable, Status.fromThrowable((Throwable)this.throwable));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ExceptionResultQueueEntry) || obj == null) {
                return false;
            }
            ExceptionResultQueueEntry other = (ExceptionResultQueueEntry)obj;
            return Objects.equal(this.throwable, other.throwable);
        }
    }
}

