/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.scanner;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.Sleeper;
import com.google.bigtable.v1.ReadRowsRequest;
import com.google.bigtable.v1.Row;
import com.google.bigtable.v1.RowSet;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.io.IOExceptionWithStatus;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.scanner.AbstractBigtableResultScanner;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.scanner.BigtableResultScannerFactory;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.scanner.BigtableRetriesExhaustedException;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.scanner.ResultScanner;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.scanner.ScanTimeoutException;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class ResumingStreamingResultScanner
extends AbstractBigtableResultScanner {
    private static final Logger LOG = new Logger(ResumingStreamingResultScanner.class);
    private static final ByteString NEXT_ROW_SUFFIX = ByteString.copyFrom((byte[])new byte[]{0});
    private final BigtableResultScannerFactory scannerFactory;
    private final ReadRowsRequest originalRequest;
    private final RetryOptions retryOptions;
    private final RequestRestarter restarter;
    private BackOff currentErrorBackoff;
    private ResultScanner<Row> currentDelegate;
    private Sleeper sleeper = Sleeper.DEFAULT;
    private long rowCount = 0L;
    private AtomicInteger timeoutRetryCount = new AtomicInteger();
    private final Logger logger;

    static ByteString nextRowKey(ByteString previous) {
        return previous.concat(NEXT_ROW_SUFFIX);
    }

    public ResumingStreamingResultScanner(RetryOptions retryOptions, ReadRowsRequest originalRequest, BigtableResultScannerFactory scannerFactory) {
        this(retryOptions, originalRequest, scannerFactory, LOG);
    }

    @VisibleForTesting
    ResumingStreamingResultScanner(RetryOptions retryOptions, ReadRowsRequest originalRequest, BigtableResultScannerFactory scannerFactory, Logger logger) {
        this.originalRequest = originalRequest;
        this.scannerFactory = scannerFactory;
        this.currentDelegate = scannerFactory.createScanner(originalRequest);
        this.retryOptions = retryOptions;
        this.logger = logger;
        switch (originalRequest.getTargetCase()) {
            case ROW_SET: {
                this.restarter = new RowSetRequestRestarter();
                break;
            }
            case ROW_RANGE: {
                Preconditions.checkArgument((!originalRequest.getAllowRowInterleaving() ? 1 : 0) != 0, (Object)"Row interleaving is not supported when using resumable streams");
                this.restarter = new RowRangeRequestRestarter();
                break;
            }
            case ROW_KEY: {
                this.restarter = new SingleRowRequestRestarter();
                break;
            }
            default: {
                throw new IllegalStateException("Cannot handle: " + originalRequest.getTargetCase());
            }
        }
    }

    @Override
    public Row next() throws IOException {
        while (true) {
            try {
                Row result = this.currentDelegate.next();
                if (result != null) {
                    this.restarter.found(result.getKey());
                    ++this.rowCount;
                    this.currentErrorBackoff = null;
                    this.timeoutRetryCount = null;
                }
                return result;
            }
            catch (ScanTimeoutException rte) {
                this.handleScanTimeout(rte);
                continue;
            }
            catch (IOExceptionWithStatus ioe) {
                this.handleIOException(ioe);
                continue;
            }
            break;
        }
    }

    private void handleScanTimeout(ScanTimeoutException rte) throws IOException {
        this.logger.info("The client could not get a response in %d ms. Retrying the scan.", this.retryOptions.getReadPartialRowTimeoutMillis());
        if (this.timeoutRetryCount == null) {
            this.timeoutRetryCount = new AtomicInteger();
        }
        this.currentErrorBackoff = null;
        if (this.timeoutRetryCount.incrementAndGet() > this.retryOptions.getMaxScanTimeoutRetries()) {
            throw new BigtableRetriesExhaustedException("Exhausted streaming retries after too many timeouts", rte);
        }
        this.reissueRequest();
    }

    private void handleIOException(IOExceptionWithStatus ioe) throws IOException {
        long nextBackOffMillis;
        Status.Code code = ioe.getStatus().getCode();
        if (this.retryOptions.isRetryable(code)) {
            this.logger.info("Reissuing scan after receiving error with status: %s.", ioe, code.name());
            if (this.currentErrorBackoff == null) {
                this.currentErrorBackoff = this.retryOptions.createBackoff();
            }
            if ((nextBackOffMillis = this.currentErrorBackoff.nextBackOffMillis()) == -1L) {
                throw new BigtableRetriesExhaustedException("Exhausted streaming retries.", ioe);
            }
        } else {
            throw ioe;
        }
        this.sleep(nextBackOffMillis);
        this.reissueRequest();
    }

    @Override
    public int available() {
        return this.currentDelegate.available();
    }

    @Override
    public void close() throws IOException {
        this.currentDelegate.close();
    }

    private void reissueRequest() {
        try {
            this.currentDelegate.close();
        }
        catch (IOException ioe) {
            this.logger.warn("Error closing scanner before reissuing request: ", ioe, new Object[0]);
        }
        ReadRowsRequest.Builder newRequest = this.originalRequest.toBuilder();
        this.restarter.updateRequest(newRequest);
        long numRowsLimit = newRequest.getNumRowsLimit();
        if (numRowsLimit > 0L) {
            com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions.checkArgument((numRowsLimit -= this.rowCount) > 0L, "The remaining number of rows must be greater than 0.");
            newRequest.setNumRowsLimit(numRowsLimit);
        }
        this.currentDelegate = this.scannerFactory.createScanner(newRequest.build());
    }

    private void sleep(long millis) throws IOException {
        try {
            this.sleeper.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while sleeping for resume", e);
        }
    }

    private static class RowSetRequestRestarter
    implements RequestRestarter {
        private Set<ByteString> foundKeys = new HashSet<ByteString>();

        private RowSetRequestRestarter() {
        }

        @Override
        public void found(ByteString key) {
            this.foundKeys.add(key);
        }

        @Override
        public void updateRequest(ReadRowsRequest.Builder newRequest) {
            HashSet allRowKeys = new HashSet(newRequest.getRowSet().getRowKeysList());
            allRowKeys.removeAll(this.foundKeys);
            newRequest.setRowSet(RowSet.newBuilder().addAllRowKeys(allRowKeys));
        }
    }

    private static class SingleRowRequestRestarter
    implements RequestRestarter {
        private SingleRowRequestRestarter() {
        }

        @Override
        public void found(ByteString key) {
        }

        @Override
        public void updateRequest(ReadRowsRequest.Builder newRequest) {
        }
    }

    private static class RowRangeRequestRestarter
    implements RequestRestarter {
        private ByteString lastRowKey = null;

        private RowRangeRequestRestarter() {
        }

        @Override
        public void found(ByteString key) {
            this.lastRowKey = key;
        }

        @Override
        public void updateRequest(ReadRowsRequest.Builder newRequest) {
            if (this.lastRowKey != null) {
                newRequest.getRowRangeBuilder().setStartKey(ResumingStreamingResultScanner.nextRowKey(this.lastRowKey));
            }
        }
    }

    private static interface RequestRestarter {
        public void found(ByteString var1);

        public void updateRequest(ReadRowsRequest.Builder var1);
    }
}

