/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners;

import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.PipelineResult;
import com.google.cloud.dataflow.sdk.options.GcsOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptionsValidator;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.util.IOChannelUtils;
import com.google.cloud.dataflow.sdk.util.InstanceBuilder;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.cloud.dataflow.sdk.values.POutput;

public abstract class PipelineRunner<ResultT extends PipelineResult> {
    public static PipelineRunner<? extends PipelineResult> fromOptions(PipelineOptions options) {
        GcsOptions gcsOptions = PipelineOptionsValidator.validate(GcsOptions.class, options);
        Preconditions.checkNotNull(options);
        IOChannelUtils.registerStandardIOFactories(gcsOptions);
        PipelineRunner result = InstanceBuilder.ofType(PipelineRunner.class).fromClass(options.getRunner()).fromFactoryMethod("fromOptions").withArg(PipelineOptions.class, options).build();
        return result;
    }

    public abstract ResultT run(Pipeline var1);

    public <OutputT extends POutput, InputT extends PInput> OutputT apply(PTransform<InputT, OutputT> transform, InputT input) {
        return transform.apply(input);
    }
}

