/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners;

import com.google.api.services.dataflow.Dataflow;
import com.google.auto.service.AutoService;
import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.PipelineResult;
import com.google.cloud.dataflow.sdk.options.DataflowPipelineDebugOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptionsValidator;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Strings;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.runners.DataflowPipelineJob;
import com.google.cloud.dataflow.sdk.runners.DataflowPipelineRunner;
import com.google.cloud.dataflow.sdk.runners.DataflowPipelineRunnerHooks;
import com.google.cloud.dataflow.sdk.runners.PipelineRunner;
import com.google.cloud.dataflow.sdk.runners.PipelineRunnerRegistrar;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.util.MonitoringUtil;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.cloud.dataflow.sdk.values.POutput;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplatingDataflowPipelineRunner
extends PipelineRunner<DataflowPipelineJob> {
    private static final Logger LOG = LoggerFactory.getLogger(TemplatingDataflowPipelineRunner.class);
    private final DataflowPipelineRunner dataflowPipelineRunner;
    private final PipelineOptions options;

    protected TemplatingDataflowPipelineRunner(DataflowPipelineRunner internalRunner, PipelineOptions options) {
        this.dataflowPipelineRunner = internalRunner;
        this.options = options;
    }

    public static TemplatingDataflowPipelineRunner fromOptions(PipelineOptions options) {
        DataflowPipelineDebugOptions dataflowOptions = PipelineOptionsValidator.validate(DataflowPipelineDebugOptions.class, options);
        DataflowPipelineRunner dataflowPipelineRunner = DataflowPipelineRunner.fromOptions(dataflowOptions);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(dataflowOptions.getDataflowJobFile()), "--dataflowJobFile must be present to create a template.");
        return new TemplatingDataflowPipelineRunner(dataflowPipelineRunner, options);
    }

    @Override
    public DataflowPipelineJob run(Pipeline p) {
        this.dataflowPipelineRunner.setHooks(new TemplateHooks());
        DataflowPipelineJob job = this.dataflowPipelineRunner.run(p);
        LOG.info("Template successfully created.");
        return new TemplateJob();
    }

    @Override
    public <OutputT extends POutput, InputT extends PInput> OutputT apply(PTransform<InputT, OutputT> transform, InputT input) {
        return this.dataflowPipelineRunner.apply(transform, input);
    }

    public String toString() {
        return "TemplatingDataflowPipelineRunner";
    }

    @AutoService(value=PipelineRunnerRegistrar.class)
    public static class Runner
    implements PipelineRunnerRegistrar {
        @Override
        public Iterable<Class<? extends PipelineRunner<?>>> getPipelineRunners() {
            return ImmutableList.of(TemplatingDataflowPipelineRunner.class);
        }
    }

    private static class TemplateJob
    extends DataflowPipelineJob {
        private static final String ERROR = "The result of template creation should not be used.";

        TemplateJob() {
            super(null, null, null, null);
        }

        @Override
        public String getJobId() {
            throw new UnsupportedOperationException(ERROR);
        }

        @Override
        public String getProjectId() {
            throw new UnsupportedOperationException(ERROR);
        }

        @Override
        public DataflowPipelineJob getReplacedByJob() {
            throw new UnsupportedOperationException(ERROR);
        }

        @Override
        public Dataflow getDataflowClient() {
            throw new UnsupportedOperationException(ERROR);
        }

        @Override
        public PipelineResult.State waitToFinish(long timeToWait, TimeUnit timeUnit, MonitoringUtil.JobMessagesHandler messageHandler) {
            throw new UnsupportedOperationException(ERROR);
        }

        @Override
        public void cancel() {
            throw new UnsupportedOperationException(ERROR);
        }

        @Override
        public PipelineResult.State getState() {
            throw new UnsupportedOperationException(ERROR);
        }
    }

    private static class TemplateHooks
    extends DataflowPipelineRunnerHooks {
        private TemplateHooks() {
        }

        @Override
        public boolean shouldActuallyRunJob() {
            return false;
        }

        @Override
        public boolean failOnJobFileWriteFailure() {
            return true;
        }
    }
}

