/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners;

import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.runners.TransformTreeNode;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.cloud.dataflow.sdk.values.POutput;
import com.google.cloud.dataflow.sdk.values.PValue;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class TransformHierarchy {
    private final Deque<TransformTreeNode> transformStack = new LinkedList<TransformTreeNode>();
    private final Map<PInput, TransformTreeNode> producingTransformNode = new HashMap<PInput, TransformTreeNode>();

    public TransformHierarchy() {
        this.transformStack.add(new TransformTreeNode(null, null, "", null));
    }

    public TransformTreeNode getCurrent() {
        return this.transformStack.peek();
    }

    public void pushNode(TransformTreeNode current) {
        this.transformStack.push(current);
    }

    public void popNode() {
        this.transformStack.pop();
        Preconditions.checkState(!this.transformStack.isEmpty());
    }

    public void addInput(TransformTreeNode node, PInput input) {
        for (PValue pValue : input.expand()) {
            TransformTreeNode producer = this.producingTransformNode.get(pValue);
            if (producer == null) {
                throw new IllegalStateException("Producer unknown for input: " + pValue);
            }
            producer.finishSpecifying();
            node.addInputProducer(pValue, producer);
        }
    }

    public void setOutput(TransformTreeNode producer, POutput output) {
        producer.setOutput(output);
        for (PValue pValue : output.expand()) {
            this.producingTransformNode.put(pValue, producer);
        }
    }

    public void visit(Pipeline.PipelineVisitor visitor, Set<PValue> visitedNodes) {
        this.transformStack.peekFirst().visit(visitor, visitedNodes);
    }
}

