/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.dataflow;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.BiMap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.HashBiMap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.HashMultimap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Multimap;
import com.google.cloud.dataflow.sdk.transforms.Aggregator;
import com.google.cloud.dataflow.sdk.transforms.AppliedPTransform;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class DataflowAggregatorTransforms {
    private final Map<Aggregator<?, ?>, Collection<PTransform<?, ?>>> aggregatorTransforms;
    private final Multimap<PTransform<?, ?>, AppliedPTransform<?, ?, ?>> transformAppliedTransforms;
    private final BiMap<AppliedPTransform<?, ?, ?>, String> appliedStepNames;

    public DataflowAggregatorTransforms(Map<Aggregator<?, ?>, Collection<PTransform<?, ?>>> aggregatorTransforms, Map<AppliedPTransform<?, ?, ?>, String> transformStepNames) {
        this.aggregatorTransforms = aggregatorTransforms;
        this.appliedStepNames = HashBiMap.create(transformStepNames);
        this.transformAppliedTransforms = HashMultimap.create();
        for (AppliedPTransform<?, ?, ?> appliedTransform : transformStepNames.keySet()) {
            this.transformAppliedTransforms.put((PTransform<?, ?>)appliedTransform.getTransform(), appliedTransform);
        }
    }

    public boolean contains(Aggregator<?, ?> aggregator) {
        return this.aggregatorTransforms.containsKey(aggregator);
    }

    public Collection<String> getAggregatorStepNames(Aggregator<?, ?> aggregator) {
        HashSet<String> names = new HashSet<String>();
        Collection<PTransform<?, ?>> transforms = this.aggregatorTransforms.get(aggregator);
        for (PTransform<?, ?> transform : transforms) {
            for (AppliedPTransform<?, ?, ?> applied : this.transformAppliedTransforms.get(transform)) {
                names.add((String)this.appliedStepNames.get(applied));
            }
        }
        return names;
    }

    public AppliedPTransform<?, ?, ?> getAppliedTransformForStepName(String stepName) {
        return (AppliedPTransform)this.appliedStepNames.inverse().get(stepName);
    }
}

