/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.dataflow;

import com.google.api.services.dataflow.model.Source;
import com.google.api.services.dataflow.model.SourceMetadata;
import com.google.cloud.dataflow.sdk.io.FileBasedSource;
import com.google.cloud.dataflow.sdk.io.Read;
import com.google.cloud.dataflow.sdk.runners.DataflowPipelineTranslator;
import com.google.cloud.dataflow.sdk.runners.dataflow.CustomSources;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.values.PValue;
import java.util.HashMap;
import java.util.Map;

public class ReadTranslator
implements DataflowPipelineTranslator.TransformTranslator<Read.Bounded<?>> {
    @Override
    public void translate(Read.Bounded<?> transform, DataflowPipelineTranslator.TranslationContext context) {
        ReadTranslator.translateReadHelper(transform.getSource(), transform, context);
    }

    public static <T> void translateReadHelper(com.google.cloud.dataflow.sdk.io.Source<T> source, PTransform<?, ? extends PValue> transform, DataflowPipelineTranslator.TranslationContext context) {
        try {
            if (source instanceof FileBasedSource) {
                String filePatternOrSpec = ((FileBasedSource)source).getFileOrPatternSpec();
                context.getPipelineOptions().getPathValidator().validateInputFilePatternSupported(filePatternOrSpec);
            }
            context.addStep(transform, "ParallelRead");
            context.addInput("format", "custom_source");
            context.addInput("custom_source_step_input", ReadTranslator.cloudSourceToDictionary(CustomSources.serializeToCloudSource(source, context.getPipelineOptions())));
            context.addValueOnlyOutput("output", context.getOutput(transform));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, Object> cloudSourceToDictionary(Source source) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        Structs.addDictionary(res, "spec", source.getSpec());
        if (source.getMetadata() != null) {
            Structs.addDictionary(res, "metadata", ReadTranslator.cloudSourceMetadataToDictionary(source.getMetadata()));
        }
        if (source.getDoesNotNeedSplitting() != null) {
            Structs.addBoolean(res, "does_not_need_splitting", source.getDoesNotNeedSplitting());
        }
        return res;
    }

    private static Map<String, Object> cloudSourceMetadataToDictionary(SourceMetadata metadata) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (metadata.getProducesSortedKeys() != null) {
            Structs.addBoolean(res, "produces_sorted_keys", metadata.getProducesSortedKeys());
        }
        if (metadata.getEstimatedSizeBytes() != null) {
            Structs.addLong(res, "estimated_size_bytes", metadata.getEstimatedSizeBytes());
        }
        if (metadata.getInfinite() != null) {
            Structs.addBoolean(res, "is_infinite", metadata.getInfinite());
        }
        return res;
    }
}

