/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.inprocess;

import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.runners.TransformTreeNode;
import com.google.cloud.dataflow.sdk.transforms.AppliedPTransform;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.cloud.dataflow.sdk.values.POutput;
import com.google.cloud.dataflow.sdk.values.PValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ConsumerTrackingPipelineVisitor
implements Pipeline.PipelineVisitor {
    private Map<PValue, Collection<AppliedPTransform<?, ?, ?>>> valueToConsumers = new HashMap();
    private Collection<AppliedPTransform<?, ?, ?>> rootTransforms = new ArrayList();
    private Collection<PCollectionView<?>> views = new ArrayList();
    private Map<AppliedPTransform<?, ?, ?>, String> stepNames = new HashMap();
    private Set<PValue> toFinalize = new HashSet<PValue>();
    private int numTransforms = 0;
    private boolean finalized = false;

    ConsumerTrackingPipelineVisitor() {
    }

    @Override
    public void enterCompositeTransform(TransformTreeNode node) {
        Preconditions.checkState(!this.finalized, "Attempting to traverse a pipeline (node %s) with a %s which has already visited a Pipeline and is finalized", node.getFullName(), ConsumerTrackingPipelineVisitor.class.getSimpleName());
    }

    @Override
    public void leaveCompositeTransform(TransformTreeNode node) {
        Preconditions.checkState(!this.finalized, "Attempting to traverse a pipeline (node %s) with a %s which is already finalized", node.getFullName(), ConsumerTrackingPipelineVisitor.class.getSimpleName());
        if (node.isRootNode()) {
            this.finalized = true;
        }
    }

    @Override
    public void visitTransform(TransformTreeNode node) {
        this.toFinalize.removeAll(node.getInput().expand());
        AppliedPTransform<?, ?, ?> appliedTransform = this.getAppliedTransform(node);
        this.stepNames.put(appliedTransform, this.genStepName());
        if (node.getInput().expand().isEmpty()) {
            this.rootTransforms.add(appliedTransform);
        } else {
            for (PValue pValue : node.getInput().expand()) {
                this.valueToConsumers.get(pValue).add(appliedTransform);
            }
        }
    }

    private AppliedPTransform<?, ?, ?> getAppliedTransform(TransformTreeNode node) {
        AppliedPTransform<PInput, POutput, PTransform<?, ?>> application = AppliedPTransform.of(node.getFullName(), node.getInput(), node.getOutput(), node.getTransform());
        return application;
    }

    @Override
    public void visitValue(PValue value, TransformTreeNode producer) {
        this.toFinalize.add(value);
        for (PValue pValue : value.expand()) {
            this.valueToConsumers.put(pValue, new ArrayList());
            if (pValue instanceof PCollectionView) {
                this.views.add((PCollectionView)pValue);
            }
            pValue.recordAsOutput(this.getAppliedTransform(producer));
        }
        value.recordAsOutput(this.getAppliedTransform(producer));
    }

    private String genStepName() {
        return String.format("s%s", this.numTransforms++);
    }

    public Map<PValue, Collection<AppliedPTransform<?, ?, ?>>> getValueToConsumers() {
        Preconditions.checkState(this.finalized, "Can't call getValueToConsumers before the Pipeline has been completely traversed");
        return this.valueToConsumers;
    }

    public Map<AppliedPTransform<?, ?, ?>, String> getStepNames() {
        Preconditions.checkState(this.finalized, "Can't call getStepNames before the Pipeline has been completely traversed");
        return this.stepNames;
    }

    public Collection<AppliedPTransform<?, ?, ?>> getRootTransforms() {
        Preconditions.checkState(this.finalized, "Can't call getRootTransforms before the Pipeline has been completely traversed");
        return this.rootTransforms;
    }

    public Collection<PCollectionView<?>> getViews() {
        Preconditions.checkState(this.finalized, "Can't call getViews before the Pipeline has been completely traversed");
        return this.views;
    }

    public Set<PValue> getUnfinalizedPValues() {
        Preconditions.checkState(this.finalized, "Can't call getUnfinalizedPValues before the Pipeline has been completely traversed");
        return this.toFinalize;
    }
}

