/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.inprocess;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.runners.inprocess.AbstractModelEnforcement;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessPipelineRunner;
import com.google.cloud.dataflow.sdk.runners.inprocess.ModelEnforcement;
import com.google.cloud.dataflow.sdk.runners.inprocess.ModelEnforcementFactory;
import com.google.cloud.dataflow.sdk.transforms.AppliedPTransform;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import com.google.cloud.dataflow.sdk.util.UserCodeException;
import com.google.cloud.dataflow.sdk.util.WindowedValue;

class EncodabilityEnforcementFactory
implements ModelEnforcementFactory {
    EncodabilityEnforcementFactory() {
    }

    public static EncodabilityEnforcementFactory create() {
        return new EncodabilityEnforcementFactory();
    }

    @Override
    public <T> ModelEnforcement<T> forBundle(InProcessPipelineRunner.CommittedBundle<T> input, AppliedPTransform<?, ?, ?> consumer) {
        return new EncodabilityEnforcement<T>(input);
    }

    private static class EncodabilityEnforcement<T>
    extends AbstractModelEnforcement<T> {
        private Coder<T> coder;

        public EncodabilityEnforcement(InProcessPipelineRunner.CommittedBundle<T> input) {
            this.coder = input.getPCollection().getCoder();
        }

        @Override
        public void beforeElement(WindowedValue<T> element) {
            try {
                T clone = CoderUtils.clone(this.coder, element.getValue());
                if (this.coder.consistentWithEquals()) {
                    Preconditions.checkArgument(this.coder.structuralValue(element.getValue()).equals(this.coder.structuralValue(clone)), "Coder %s of class %s does not maintain structural value equality on input element %s", this.coder, this.coder.getClass().getSimpleName(), element.getValue());
                }
            }
            catch (Exception e) {
                throw UserCodeException.wrap(e);
            }
        }
    }
}

