/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.inprocess;

import com.google.cloud.dataflow.sdk.runners.inprocess.Clock;
import com.google.cloud.dataflow.sdk.runners.inprocess.InMemoryWatermarkManager;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessTimerInternals;
import com.google.cloud.dataflow.sdk.runners.inprocess.StructuralKey;
import com.google.cloud.dataflow.sdk.util.BaseExecutionContext;
import com.google.cloud.dataflow.sdk.util.ExecutionContext;
import com.google.cloud.dataflow.sdk.util.common.worker.StateSampler;
import com.google.cloud.dataflow.sdk.util.state.CopyOnAccessInMemoryStateInternals;

class InProcessExecutionContext
extends BaseExecutionContext<InProcessStepContext> {
    private final Clock clock;
    private final StructuralKey<?> key;
    private final CopyOnAccessInMemoryStateInternals<Object> existingState;
    private final InMemoryWatermarkManager.TransformWatermarks watermarks;

    public InProcessExecutionContext(Clock clock, StructuralKey<?> key, CopyOnAccessInMemoryStateInternals<Object> existingState, InMemoryWatermarkManager.TransformWatermarks watermarks) {
        this.clock = clock;
        this.key = key;
        this.existingState = existingState;
        this.watermarks = watermarks;
    }

    @Override
    protected InProcessStepContext createStepContext(String stepName, String transformName, StateSampler stateSampler) {
        return new InProcessStepContext(this, stepName, transformName);
    }

    public class InProcessStepContext
    extends BaseExecutionContext.StepContext {
        private CopyOnAccessInMemoryStateInternals<Object> stateInternals;
        private InProcessTimerInternals timerInternals;

        public InProcessStepContext(ExecutionContext executionContext, String stepName, String transformName) {
            super(executionContext, stepName, transformName);
        }

        public CopyOnAccessInMemoryStateInternals<Object> stateInternals() {
            if (this.stateInternals == null) {
                this.stateInternals = CopyOnAccessInMemoryStateInternals.withUnderlying(InProcessExecutionContext.this.key, InProcessExecutionContext.this.existingState);
            }
            return this.stateInternals;
        }

        @Override
        public InProcessTimerInternals timerInternals() {
            if (this.timerInternals == null) {
                this.timerInternals = InProcessTimerInternals.create(InProcessExecutionContext.this.clock, InProcessExecutionContext.this.watermarks, InMemoryWatermarkManager.TimerUpdate.builder(InProcessExecutionContext.this.key));
            }
            return this.timerInternals;
        }

        public CopyOnAccessInMemoryStateInternals<?> commitState() {
            if (this.stateInternals != null) {
                return this.stateInternals.commit();
            }
            return null;
        }

        public InMemoryWatermarkManager.TimerUpdate getTimerUpdate() {
            if (this.timerInternals == null) {
                return InMemoryWatermarkManager.TimerUpdate.empty();
            }
            return this.timerInternals.getTimerUpdate();
        }
    }
}

