/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.inprocess;

import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessPipelineRunner;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessTransformResult;
import com.google.cloud.dataflow.sdk.runners.inprocess.StepTransformResult;
import com.google.cloud.dataflow.sdk.runners.inprocess.TransformEvaluator;
import com.google.cloud.dataflow.sdk.transforms.AppliedPTransform;
import com.google.cloud.dataflow.sdk.util.WindowedValue;

class PassthroughTransformEvaluator<InputT>
implements TransformEvaluator<InputT> {
    private final AppliedPTransform<?, ?, ?> transform;
    private final InProcessPipelineRunner.UncommittedBundle<InputT> output;

    public static <InputT> PassthroughTransformEvaluator<InputT> create(AppliedPTransform<?, ?, ?> transform, InProcessPipelineRunner.UncommittedBundle<InputT> output) {
        return new PassthroughTransformEvaluator<InputT>(transform, output);
    }

    private PassthroughTransformEvaluator(AppliedPTransform<?, ?, ?> transform, InProcessPipelineRunner.UncommittedBundle<InputT> output) {
        this.transform = transform;
        this.output = output;
    }

    @Override
    public void processElement(WindowedValue<InputT> element) throws Exception {
        this.output.add(element);
    }

    @Override
    public InProcessTransformResult finishBundle() throws Exception {
        return StepTransformResult.withoutHold(this.transform).addOutput(this.output, new InProcessPipelineRunner.UncommittedBundle[0]).build();
    }
}

