/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.inprocess;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.util.CoderUtils;

class StructuralKey<K> {
    private final Coder<K> coder;
    private final Object structuralValue;
    private final byte[] encoded;

    public static <K> StructuralKey<K> of(K key, Coder<K> coder) {
        try {
            return new StructuralKey<K>(coder, key);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not encode a key with its provided coder " + coder.getClass().getSimpleName(), e);
        }
    }

    private StructuralKey(Coder<K> coder, K key) throws Exception {
        this.coder = coder;
        this.structuralValue = coder.structuralValue(key);
        this.encoded = CoderUtils.encodeToByteArray(coder, key);
    }

    public K getKey() {
        try {
            return CoderUtils.decodeFromByteArray(this.coder, this.encoded);
        }
        catch (CoderException e) {
            throw new IllegalArgumentException("Could not decode Key with coder of type " + this.coder.getClass().getSimpleName());
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof StructuralKey) {
            StructuralKey that = (StructuralKey)other;
            return this.structuralValue.equals(that.structuralValue);
        }
        return false;
    }

    public int hashCode() {
        return this.structuralValue.hashCode();
    }
}

