/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.inprocess;

import com.google.cloud.dataflow.sdk.coders.ByteArrayCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.cache.CacheBuilder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.cache.CacheLoader;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.cache.LoadingCache;
import com.google.cloud.dataflow.sdk.runners.inprocess.StructuralKey;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.joda.time.Duration;

interface UnboundedReadDeduplicator {
    public boolean shouldOutput(byte[] var1);

    public static class CachedIdDeduplicator
    implements UnboundedReadDeduplicator {
        private static final ByteArrayCoder RECORD_ID_CODER = ByteArrayCoder.of();
        private static final long MAX_RETENTION_SINCE_ACCESS = Duration.standardMinutes((long)10L).getMillis();
        private final LoadingCache<StructuralKey<byte[]>, AtomicBoolean> ids = CacheBuilder.newBuilder().expireAfterAccess(MAX_RETENTION_SINCE_ACCESS, TimeUnit.MILLISECONDS).maximumSize(100000L).build(new TrueBooleanLoader());

        public static UnboundedReadDeduplicator create() {
            return new CachedIdDeduplicator();
        }

        private CachedIdDeduplicator() {
        }

        @Override
        public boolean shouldOutput(byte[] recordId) {
            return this.ids.getUnchecked(StructuralKey.of(recordId, RECORD_ID_CODER)).getAndSet(false);
        }

        private static class TrueBooleanLoader
        extends CacheLoader<StructuralKey<byte[]>, AtomicBoolean> {
            private TrueBooleanLoader() {
            }

            @Override
            public AtomicBoolean load(StructuralKey<byte[]> key) throws Exception {
                return new AtomicBoolean(true);
            }
        }
    }

    public static class NeverDeduplicator
    implements UnboundedReadDeduplicator {
        public static UnboundedReadDeduplicator create() {
            return new NeverDeduplicator();
        }

        @Override
        public boolean shouldOutput(byte[] recordId) {
            return true;
        }
    }
}

