/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.inprocess;

import com.google.cloud.dataflow.sdk.coders.KvCoder;
import com.google.cloud.dataflow.sdk.coders.VoidCoder;
import com.google.cloud.dataflow.sdk.runners.inprocess.CommittedResult;
import com.google.cloud.dataflow.sdk.runners.inprocess.ForwardingPTransform;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessEvaluationContext;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessPipelineRunner;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessTransformResult;
import com.google.cloud.dataflow.sdk.runners.inprocess.PTransformOverrideFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.StepTransformResult;
import com.google.cloud.dataflow.sdk.runners.inprocess.TransformEvaluator;
import com.google.cloud.dataflow.sdk.runners.inprocess.TransformEvaluatorFactory;
import com.google.cloud.dataflow.sdk.transforms.AppliedPTransform;
import com.google.cloud.dataflow.sdk.transforms.GroupByKey;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.Values;
import com.google.cloud.dataflow.sdk.transforms.View;
import com.google.cloud.dataflow.sdk.transforms.WithKeys;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.cloud.dataflow.sdk.values.POutput;
import java.util.ArrayList;
import java.util.List;

class ViewEvaluatorFactory
implements TransformEvaluatorFactory {
    ViewEvaluatorFactory() {
    }

    public <T> TransformEvaluator<T> forApplication(AppliedPTransform<?, ?, ?> application, InProcessPipelineRunner.CommittedBundle<?> inputBundle, InProcessEvaluationContext evaluationContext) {
        TransformEvaluator evaluator = this.createEvaluator(application, evaluationContext);
        return evaluator;
    }

    private <InT, OuT> TransformEvaluator<Iterable<InT>> createEvaluator(final AppliedPTransform<PCollection<Iterable<InT>>, PCollectionView<OuT>, WriteView<InT, OuT>> application, InProcessEvaluationContext context) {
        PCollection input = application.getInput();
        final InProcessPipelineRunner.PCollectionViewWriter writer = context.createPCollectionViewWriter(input, application.getOutput());
        return new TransformEvaluator<Iterable<InT>>(){
            private final List<WindowedValue<InT>> elements = new ArrayList();

            @Override
            public void processElement(WindowedValue<Iterable<InT>> element) {
                for (Object input : element.getValue()) {
                    this.elements.add(element.withValue(input));
                }
            }

            @Override
            public InProcessTransformResult finishBundle() {
                writer.add(this.elements);
                StepTransformResult.Builder resultBuilder = StepTransformResult.withoutHold(application);
                if (!this.elements.isEmpty()) {
                    resultBuilder = resultBuilder.withAdditionalOutput(CommittedResult.OutputType.PCOLLECTION_VIEW);
                }
                return resultBuilder.build();
            }
        };
    }

    public static final class WriteView<ElemT, ViewT>
    extends PTransform<PCollection<Iterable<ElemT>>, PCollectionView<ViewT>> {
        private final View.CreatePCollectionView<ElemT, ViewT> og;

        WriteView(View.CreatePCollectionView<ElemT, ViewT> og) {
            this.og = og;
        }

        @Override
        public PCollectionView<ViewT> apply(PCollection<Iterable<ElemT>> input) {
            return this.og.getView();
        }
    }

    private static class InProcessCreatePCollectionView<ElemT, ViewT>
    extends ForwardingPTransform<PCollection<ElemT>, PCollectionView<ViewT>> {
        private final View.CreatePCollectionView<ElemT, ViewT> og;

        private InProcessCreatePCollectionView(View.CreatePCollectionView<ElemT, ViewT> og) {
            this.og = og;
        }

        @Override
        public PCollectionView<ViewT> apply(PCollection<ElemT> input) {
            return (PCollectionView)((PCollection)((PCollection)((PCollection)((PCollection)input.apply(WithKeys.of((Void)null))).setCoder(KvCoder.of(VoidCoder.of(), input.getCoder()))).apply(GroupByKey.create())).apply(Values.create())).apply(new WriteView<ElemT, ViewT>(this.og));
        }

        @Override
        protected PTransform<PCollection<ElemT>, PCollectionView<ViewT>> delegate() {
            return this.og;
        }
    }

    public static class InProcessViewOverrideFactory
    implements PTransformOverrideFactory {
        @Override
        public <InputT extends PInput, OutputT extends POutput> PTransform<InputT, OutputT> override(PTransform<InputT, OutputT> transform) {
            if (transform instanceof View.CreatePCollectionView) {
                // empty if block
            }
            InProcessCreatePCollectionView createView = new InProcessCreatePCollectionView((View.CreatePCollectionView)transform);
            return createView;
        }
    }
}

