/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.testing;

import com.google.cloud.dataflow.sdk.coders.CannotProvideCoderException;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.IterableCoder;
import com.google.cloud.dataflow.sdk.coders.KvCoder;
import com.google.cloud.dataflow.sdk.coders.MapCoder;
import com.google.cloud.dataflow.sdk.coders.VarIntCoder;
import com.google.cloud.dataflow.sdk.options.StreamingOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Optional;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Lists;
import com.google.cloud.dataflow.sdk.testing.PaneExtractors;
import com.google.cloud.dataflow.sdk.testing.SerializableMatcher;
import com.google.cloud.dataflow.sdk.testing.SerializableMatchers;
import com.google.cloud.dataflow.sdk.testing.StaticWindows;
import com.google.cloud.dataflow.sdk.transforms.Aggregator;
import com.google.cloud.dataflow.sdk.transforms.Create;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.Flatten;
import com.google.cloud.dataflow.sdk.transforms.GroupByKey;
import com.google.cloud.dataflow.sdk.transforms.MapElements;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.transforms.SerializableFunction;
import com.google.cloud.dataflow.sdk.transforms.SimpleFunction;
import com.google.cloud.dataflow.sdk.transforms.Sum;
import com.google.cloud.dataflow.sdk.transforms.Values;
import com.google.cloud.dataflow.sdk.transforms.View;
import com.google.cloud.dataflow.sdk.transforms.WithKeys;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.GlobalWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.GlobalWindows;
import com.google.cloud.dataflow.sdk.transforms.windowing.Never;
import com.google.cloud.dataflow.sdk.transforms.windowing.Window;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import com.google.cloud.dataflow.sdk.util.GatherAllPanes;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.values.KV;
import com.google.cloud.dataflow.sdk.values.PBegin;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PCollectionList;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import com.google.cloud.dataflow.sdk.values.PDone;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataflowAssert {
    private static final Logger LOG = LoggerFactory.getLogger(DataflowAssert.class);
    static final String SUCCESS_COUNTER = "DataflowAssertSuccess";
    static final String FAILURE_COUNTER = "DataflowAssertFailure";
    private static int assertCount = 0;

    private static String nextAssertionName() {
        return "DataflowAssert$" + assertCount++;
    }

    private DataflowAssert() {
    }

    public static <T> IterableAssert<T> that(PCollection<T> actual) {
        return new PCollectionContentsAssert<T>(actual);
    }

    public static <T> IterableAssert<T> thatSingletonIterable(PCollection<? extends Iterable<T>> actual) {
        PCollection actualIterables = actual;
        return new PCollectionSingletonIterableAssert(actualIterables);
    }

    @Deprecated
    public static <T> IterableAssert<T> thatIterable(PCollectionView<Iterable<T>> actual) {
        return new PCollectionViewIterableAssert(actual);
    }

    public static <T> SingletonAssert<T> thatSingleton(PCollection<T> actual) {
        return new PCollectionViewAssert<T, T>(actual, View.asSingleton(), actual.getCoder());
    }

    public static <K, V> SingletonAssert<Map<K, Iterable<V>>> thatMultimap(PCollection<KV<K, V>> actual) {
        KvCoder kvCoder = (KvCoder)actual.getCoder();
        return new PCollectionViewAssert(actual, View.asMultimap(), MapCoder.of(kvCoder.getKeyCoder(), IterableCoder.of(kvCoder.getValueCoder())));
    }

    public static <K, V> SingletonAssert<Map<K, V>> thatMap(PCollection<KV<K, V>> actual) {
        KvCoder kvCoder = (KvCoder)actual.getCoder();
        return new PCollectionViewAssert(actual, View.asMap(), MapCoder.of(kvCoder.getKeyCoder(), kvCoder.getValueCoder()));
    }

    private static <ActualT> void doChecks(ActualT actualContents, SerializableFunction<ActualT, Void> checkerFn, Aggregator<Integer, Integer> successAggregator, Aggregator<Integer, Integer> failureAggregator) {
        try {
            checkerFn.apply(actualContents);
            successAggregator.addValue(1);
        }
        catch (Throwable t) {
            LOG.error("DataflowAssert failed expectations.", t);
            failureAggregator.addValue(1);
            throw t;
        }
    }

    private static final class FilterWindows<T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private final StaticWindows windows;

        public FilterWindows(StaticWindows windows) {
            this.windows = windows;
        }

        @Override
        public PCollection<T> apply(PCollection<T> input) {
            return (PCollection)input.apply("FilterWindows", ParDo.of(new Fn()));
        }

        private class Fn
        extends DoFn<T, T>
        implements DoFn.RequiresWindowAccess {
            private Fn() {
            }

            @Override
            public void processElement(DoFn.ProcessContext c) throws Exception {
                if (FilterWindows.this.windows.getWindows().contains(c.window())) {
                    c.output(c.element());
                }
            }
        }
    }

    private static class IntoStaticWindows
    implements AssertionWindows {
        private final StaticWindows windowFn;

        public static AssertionWindows of(Coder<BoundedWindow> windowCoder, BoundedWindow window) {
            return new IntoStaticWindows(StaticWindows.of(windowCoder, window));
        }

        private IntoStaticWindows(StaticWindows windowFn) {
            this.windowFn = windowFn;
        }

        @Override
        public <T> PTransform<PCollection<T>, PCollection<T>> windowDummy() {
            return Window.into(this.windowFn);
        }

        @Override
        public <T> PTransform<PCollection<T>, PCollection<T>> prepareActuals() {
            return new FilterWindows(this.windowFn);
        }

        @Override
        public <T> PTransform<PCollection<T>, PCollection<T>> windowActuals() {
            return Window.into(this.windowFn.intoOnlyExisting());
        }
    }

    private static class IntoGlobalWindow
    implements AssertionWindows,
    Serializable {
        private IntoGlobalWindow() {
        }

        public static AssertionWindows of() {
            return new IntoGlobalWindow();
        }

        private <T> PTransform<PCollection<T>, PCollection<T>> window() {
            return Window.into(new GlobalWindows());
        }

        @Override
        public <T> PTransform<PCollection<T>, PCollection<T>> windowDummy() {
            return this.window();
        }

        @Override
        public <T> PTransform<PCollection<T>, PCollection<T>> prepareActuals() {
            return this.window();
        }

        @Override
        public <T> PTransform<PCollection<T>, PCollection<T>> windowActuals() {
            return this.window();
        }
    }

    private static interface AssertionWindows {
        public <T> PTransform<PCollection<T>, PCollection<T>> windowDummy();

        public <T> PTransform<PCollection<T>, PCollection<T>> prepareActuals();

        public <T> PTransform<PCollection<T>, PCollection<T>> windowActuals();
    }

    private static class AssertContainsInAnyOrderRelation<T>
    implements AssertRelation<Iterable<T>, Iterable<T>> {
        private AssertContainsInAnyOrderRelation() {
        }

        @Override
        public SerializableFunction<Iterable<T>, Void> assertFor(Iterable<T> expectedElements) {
            return new AssertContainsInAnyOrder<T>(expectedElements);
        }
    }

    private static class AssertNotEqualToRelation<T>
    implements AssertRelation<T, T> {
        private AssertNotEqualToRelation() {
        }

        @Override
        public SerializableFunction<T, Void> assertFor(T expected) {
            return new AssertNotEqualTo<T>(expected);
        }
    }

    private static class AssertIsEqualToRelation<T>
    implements AssertRelation<T, T> {
        private AssertIsEqualToRelation() {
        }

        @Override
        public SerializableFunction<T, Void> assertFor(T expected) {
            return new AssertIsEqualTo<T>(expected);
        }
    }

    private static interface AssertRelation<ActualT, ExpectedT>
    extends Serializable {
        public SerializableFunction<ActualT, Void> assertFor(ExpectedT var1);
    }

    private static class AssertContainsInAnyOrder<T>
    implements SerializableFunction<Iterable<T>, Void> {
        private T[] expected;

        @SafeVarargs
        public AssertContainsInAnyOrder(T ... expected) {
            this.expected = expected;
        }

        public AssertContainsInAnyOrder(Collection<T> expected) {
            this(expected.toArray());
        }

        public AssertContainsInAnyOrder(Iterable<T> expected) {
            this((Collection<T>)Lists.newArrayList(expected));
        }

        @Override
        public Void apply(Iterable<T> actual) {
            Assert.assertThat(actual, (Matcher)Matchers.containsInAnyOrder((Object[])this.expected));
            return null;
        }
    }

    private static class AssertNotEqualTo<T>
    implements SerializableFunction<T, Void> {
        private T expected;

        public AssertNotEqualTo(T expected) {
            this.expected = expected;
        }

        @Override
        public Void apply(T actual) {
            Assert.assertThat(actual, (Matcher)Matchers.not((Matcher)Matchers.equalTo(this.expected)));
            return null;
        }
    }

    private static class AssertIsEqualTo<T>
    implements SerializableFunction<T, Void> {
        private T expected;

        public AssertIsEqualTo(T expected) {
            this.expected = expected;
        }

        @Override
        public Void apply(T actual) {
            Assert.assertThat(actual, (Matcher)Matchers.equalTo(this.expected));
            return null;
        }
    }

    private static class SingletonCheckerDoFn<ActualT>
    extends DoFn<Iterable<ActualT>, Void> {
        private final SerializableFunction<ActualT, Void> checkerFn;
        private final Aggregator<Integer, Integer> success = this.createAggregator("DataflowAssertSuccess", new Sum.SumIntegerFn());
        private final Aggregator<Integer, Integer> failure = this.createAggregator("DataflowAssertFailure", new Sum.SumIntegerFn());

        private SingletonCheckerDoFn(SerializableFunction<ActualT, Void> checkerFn) {
            this.checkerFn = checkerFn;
        }

        @Override
        public void processElement(DoFn.ProcessContext c) {
            block2: {
                try {
                    Object actualContents = Iterables.getOnlyElement((Iterable)c.element());
                    DataflowAssert.doChecks(actualContents, this.checkerFn, this.success, this.failure);
                }
                catch (Throwable t) {
                    if (c.getPipelineOptions().as(StreamingOptions.class).isStreaming()) break block2;
                    throw t;
                }
            }
        }
    }

    private static class GroupedValuesCheckerDoFn<ActualT>
    extends DoFn<ActualT, Void> {
        private final SerializableFunction<ActualT, Void> checkerFn;
        private final Aggregator<Integer, Integer> success = this.createAggregator("DataflowAssertSuccess", new Sum.SumIntegerFn());
        private final Aggregator<Integer, Integer> failure = this.createAggregator("DataflowAssertFailure", new Sum.SumIntegerFn());

        private GroupedValuesCheckerDoFn(SerializableFunction<ActualT, Void> checkerFn) {
            this.checkerFn = checkerFn;
        }

        @Override
        public void processElement(DoFn.ProcessContext c) {
            block2: {
                try {
                    DataflowAssert.doChecks(c.element(), this.checkerFn, this.success, this.failure);
                }
                catch (Throwable t) {
                    if (c.getPipelineOptions().as(StreamingOptions.class).isStreaming()) break block2;
                    throw t;
                }
            }
        }
    }

    private static class SideInputCheckerDoFn<ActualT>
    extends DoFn<Integer, Void> {
        private final SerializableFunction<ActualT, Void> checkerFn;
        private final Aggregator<Integer, Integer> success = this.createAggregator("DataflowAssertSuccess", new Sum.SumIntegerFn());
        private final Aggregator<Integer, Integer> failure = this.createAggregator("DataflowAssertFailure", new Sum.SumIntegerFn());
        private final PCollectionView<ActualT> actual;

        private SideInputCheckerDoFn(SerializableFunction<ActualT, Void> checkerFn, PCollectionView<ActualT> actual) {
            this.checkerFn = checkerFn;
            this.actual = actual;
        }

        @Override
        public void processElement(DoFn.ProcessContext c) {
            block2: {
                try {
                    ActualT actualContents = c.sideInput(this.actual);
                    DataflowAssert.doChecks(actualContents, this.checkerFn, this.success, this.failure);
                }
                catch (Throwable t) {
                    if (c.getPipelineOptions().as(StreamingOptions.class).isStreaming()) break block2;
                    throw t;
                }
            }
        }
    }

    public static class OneSideInputAssert<ActualT>
    extends PTransform<PBegin, PDone>
    implements Serializable {
        private final transient PTransform<PBegin, PCollectionView<ActualT>> createActual;
        private final transient PTransform<PCollection<Integer>, PCollection<Integer>> windowToken;
        private final SerializableFunction<ActualT, Void> checkerFn;

        private OneSideInputAssert(PTransform<PBegin, PCollectionView<ActualT>> createActual, PTransform<PCollection<Integer>, PCollection<Integer>> windowToken, SerializableFunction<ActualT, Void> checkerFn) {
            this.createActual = createActual;
            this.windowToken = windowToken;
            this.checkerFn = checkerFn;
        }

        @Override
        public PDone apply(PBegin input) {
            PCollectionView<ActualT> actual = input.apply("CreateActual", this.createActual);
            ((PCollection)input.apply(Create.of(0).withCoder(VarIntCoder.of()))).apply("WindowToken", this.windowToken).apply("RunChecks", ParDo.withSideInputs(actual).of(new SideInputCheckerDoFn(this.checkerFn, actual)));
            return PDone.in(input.getPipeline());
        }
    }

    public static class GroupThenAssertForSingleton<T>
    extends PTransform<PCollection<Iterable<T>>, PDone>
    implements Serializable {
        private final SerializableFunction<Iterable<T>, Void> checkerFn;
        private final AssertionWindows rewindowingStrategy;
        private final SimpleFunction<Iterable<WindowedValue<Iterable<T>>>, Iterable<Iterable<T>>> paneExtractor;

        private GroupThenAssertForSingleton(SerializableFunction<Iterable<T>, Void> checkerFn, AssertionWindows rewindowingStrategy, SimpleFunction<Iterable<WindowedValue<Iterable<T>>>, Iterable<Iterable<T>>> paneExtractor) {
            this.checkerFn = checkerFn;
            this.rewindowingStrategy = rewindowingStrategy;
            this.paneExtractor = paneExtractor;
        }

        @Override
        public PDone apply(PCollection<Iterable<T>> input) {
            ((PCollection)((PCollection)((Object)((PCollection)input.apply("GroupGlobally", new GroupGlobally(this.rewindowingStrategy))).apply("GetPane", MapElements.via(this.paneExtractor)))).setCoder(IterableCoder.of(input.getCoder()))).apply("RunChecks", ParDo.of(new SingletonCheckerDoFn(this.checkerFn)));
            return PDone.in(input.getPipeline());
        }
    }

    public static class GroupThenAssert<T>
    extends PTransform<PCollection<T>, PDone>
    implements Serializable {
        private final SerializableFunction<Iterable<T>, Void> checkerFn;
        private final AssertionWindows rewindowingStrategy;
        private final SimpleFunction<Iterable<WindowedValue<T>>, Iterable<T>> paneExtractor;

        private GroupThenAssert(SerializableFunction<Iterable<T>, Void> checkerFn, AssertionWindows rewindowingStrategy, SimpleFunction<Iterable<WindowedValue<T>>, Iterable<T>> paneExtractor) {
            this.checkerFn = checkerFn;
            this.rewindowingStrategy = rewindowingStrategy;
            this.paneExtractor = paneExtractor;
        }

        @Override
        public PDone apply(PCollection<T> input) {
            ((PCollection)((PCollection)((Object)((PCollection)input.apply("GroupGlobally", new GroupGlobally(this.rewindowingStrategy))).apply("GetPane", MapElements.via(this.paneExtractor)))).setCoder(IterableCoder.of(input.getCoder()))).apply("RunChecks", ParDo.of(new GroupedValuesCheckerDoFn(this.checkerFn)));
            return PDone.in(input.getPipeline());
        }
    }

    private static final class ConcatFn<T>
    extends DoFn<Iterable<Iterable<T>>, Iterable<T>> {
        private ConcatFn() {
        }

        @Override
        public void processElement(DoFn.ProcessContext c) throws Exception {
            c.output(Iterables.concat((Iterable)c.element()));
        }
    }

    private static class GroupGlobally<T>
    extends PTransform<PCollection<T>, PCollection<Iterable<WindowedValue<T>>>>
    implements Serializable {
        private final AssertionWindows rewindowingStrategy;

        public GroupGlobally(AssertionWindows rewindowingStrategy) {
            this.rewindowingStrategy = rewindowingStrategy;
        }

        @Override
        public PCollection<Iterable<WindowedValue<T>>> apply(PCollection<T> input) {
            int combinedKey = 42;
            Window.Bound removeTriggering = Window.triggering(Never.ever()).discardingFiredPanes().withAllowedLateness(input.getWindowingStrategy().getAllowedLateness());
            PCollection groupedContents = (PCollection)((PCollection)((PCollection)input.apply(this.rewindowingStrategy.prepareActuals()).apply("GatherAllOutputs", GatherAllPanes.globally())).apply("RewindowActuals", this.rewindowingStrategy.windowActuals()).apply("KeyForDummy", WithKeys.of(42))).apply("RemoveActualsTriggering", removeTriggering);
            PCollection keyedDummy = (PCollection)((PCollection)input.getPipeline().apply(Create.of(KV.of(42, Collections.emptyList())).withCoder(groupedContents.getCoder()))).apply("WindowIntoDummy", this.rewindowingStrategy.windowDummy()).apply("RemoveDummyTriggering", removeTriggering);
            Window.Bound trigger = Window.triggering(Never.ever()).withAllowedLateness(input.getWindowingStrategy().getAllowedLateness()).discardingFiredPanes();
            PCollection dummyAndContents = (PCollection)((PCollection)((PCollection)PCollectionList.of(groupedContents).and(keyedDummy).apply("FlattenDummyAndContents", Flatten.pCollections())).apply("NeverTrigger", trigger)).apply("GroupDummyAndContents", GroupByKey.create());
            return (PCollection)((PCollection)dummyAndContents.apply(Values.create())).apply(ParDo.of(new ConcatFn()));
        }
    }

    private static class CheckRelationAgainstExpected<T>
    implements SerializableFunction<T, Void> {
        private final AssertRelation<T, T> relation;
        private final byte[] encodedExpected;
        private final Coder<T> coder;

        public CheckRelationAgainstExpected(AssertRelation<T, T> relation, T expected, Coder<T> coder) {
            this.relation = relation;
            this.coder = coder;
            try {
                this.encodedExpected = CoderUtils.encodeToByteArray(coder, expected);
            }
            catch (IOException coderException) {
                throw new RuntimeException(coderException);
            }
        }

        @Override
        public Void apply(T actual) {
            try {
                T expected = CoderUtils.decodeFromByteArray(this.coder, this.encodedExpected);
                return this.relation.assertFor(expected).apply(actual);
            }
            catch (IOException coderException) {
                throw new RuntimeException(coderException);
            }
        }
    }

    private static class CreateActual<T, ActualT>
    extends PTransform<PBegin, PCollectionView<ActualT>> {
        private final transient PCollection<T> actual;
        private final transient AssertionWindows rewindowActuals;
        private final transient SimpleFunction<Iterable<WindowedValue<T>>, Iterable<T>> extractPane;
        private final transient PTransform<PCollection<T>, PCollectionView<ActualT>> actualView;

        public static <T, ActualT> CreateActual<T, ActualT> from(PCollection<T> actual, AssertionWindows rewindowActuals, SimpleFunction<Iterable<WindowedValue<T>>, Iterable<T>> extractPane, PTransform<PCollection<T>, PCollectionView<ActualT>> actualView) {
            return new CreateActual<T, ActualT>(actual, rewindowActuals, extractPane, actualView);
        }

        private CreateActual(PCollection<T> actual, AssertionWindows rewindowActuals, SimpleFunction<Iterable<WindowedValue<T>>, Iterable<T>> extractPane, PTransform<PCollection<T>, PCollectionView<ActualT>> actualView) {
            this.actual = actual;
            this.rewindowActuals = rewindowActuals;
            this.extractPane = extractPane;
            this.actualView = actualView;
        }

        @Override
        public PCollectionView<ActualT> apply(PBegin input) {
            final Coder<T> coder = this.actual.getCoder();
            return ((PCollection)((PCollection)((PCollection)((PCollection)((Object)((PCollection)this.actual.apply("FilterActuals", this.rewindowActuals.prepareActuals()).apply("GatherPanes", GatherAllPanes.globally())).apply("ExtractPane", MapElements.via(this.extractPane)))).setCoder(IterableCoder.of(this.actual.getCoder()))).apply(Flatten.iterables())).apply("RewindowActuals", this.rewindowActuals.windowActuals()).apply(ParDo.of(new DoFn<T, T>(){

                @Override
                public void processElement(DoFn.ProcessContext context) throws CoderException {
                    context.output(CoderUtils.clone(coder, context.element()));
                }
            }))).apply(this.actualView);
        }
    }

    private static class PCollectionViewAssert<ElemT, ViewT>
    implements SingletonAssert<ViewT> {
        private final PCollection<ElemT> actual;
        private final PTransform<PCollection<ElemT>, PCollectionView<ViewT>> view;
        private final AssertionWindows rewindowActuals;
        private final SimpleFunction<Iterable<WindowedValue<ElemT>>, Iterable<ElemT>> paneExtractor;
        private final Coder<ViewT> coder;

        protected PCollectionViewAssert(PCollection<ElemT> actual, PTransform<PCollection<ElemT>, PCollectionView<ViewT>> view, Coder<ViewT> coder) {
            this(actual, view, IntoGlobalWindow.of(), PaneExtractors.onlyPane(), coder);
        }

        private PCollectionViewAssert(PCollection<ElemT> actual, PTransform<PCollection<ElemT>, PCollectionView<ViewT>> view, AssertionWindows rewindowActuals, SimpleFunction<Iterable<WindowedValue<ElemT>>, Iterable<ElemT>> paneExtractor, Coder<ViewT> coder) {
            this.actual = actual;
            this.view = view;
            this.rewindowActuals = rewindowActuals;
            this.paneExtractor = paneExtractor;
            this.coder = coder;
        }

        @Override
        public SingletonAssert<ViewT> setCoder(Coder<ViewT> coderOrNull) {
            return this;
        }

        @Override
        public Coder<ViewT> getCoder() {
            return this.coder;
        }

        public PCollectionViewAssert<ElemT, ViewT> inOnlyPane(BoundedWindow window) {
            return this.inPane(window, PaneExtractors.onlyPane());
        }

        public PCollectionViewAssert<ElemT, ViewT> inFinalPane(BoundedWindow window) {
            return this.inPane(window, PaneExtractors.finalPane());
        }

        public PCollectionViewAssert<ElemT, ViewT> inOnTimePane(BoundedWindow window) {
            return this.inPane(window, PaneExtractors.onTimePane());
        }

        private PCollectionViewAssert<ElemT, ViewT> inPane(BoundedWindow window, SimpleFunction<Iterable<WindowedValue<ElemT>>, Iterable<ElemT>> paneExtractor) {
            return new PCollectionViewAssert<ElemT, ViewT>(this.actual, this.view, IntoStaticWindows.of(this.actual.getWindowingStrategy().getWindowFn().windowCoder(), window), paneExtractor, this.coder);
        }

        public PCollectionViewAssert<ElemT, ViewT> isEqualTo(ViewT expectedValue) {
            return this.satisfies(new AssertIsEqualToRelation(), expectedValue);
        }

        @Override
        public SingletonAssert<ViewT> is(ViewT expected) {
            return this.isEqualTo((Object)expected);
        }

        public PCollectionViewAssert<ElemT, ViewT> notEqualTo(ViewT expectedValue) {
            return this.satisfies(new AssertNotEqualToRelation(), expectedValue);
        }

        public PCollectionViewAssert<ElemT, ViewT> satisfies(SerializableFunction<ViewT, Void> checkerFn) {
            this.actual.getPipeline().apply("DataflowAssert$" + assertCount++, new OneSideInputAssert(CreateActual.from(this.actual, this.rewindowActuals, this.paneExtractor, this.view), this.rewindowActuals.windowDummy(), checkerFn));
            return this;
        }

        private PCollectionViewAssert<ElemT, ViewT> satisfies(AssertRelation<ViewT, ViewT> relation, ViewT expectedValue) {
            return this.satisfies((SerializableFunction)new CheckRelationAgainstExpected<ViewT>(relation, expectedValue, this.coder));
        }

        @Deprecated
        public boolean equals(Object o) {
            throw new UnsupportedOperationException(String.format("tests for Java equality of the %s object, not the PCollection in question. Call a test method, such as isEqualTo.", this.getClass().getSimpleName()));
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException(String.format("%s.hashCode() is not supported.", SingletonAssert.class.getSimpleName()));
        }
    }

    private static class PCollectionViewIterableAssert<T>
    implements IterableAssert<T> {
        private final PCollectionView<Iterable<T>> actual;
        private Optional<Coder<T>> valueCoder;

        private PCollectionViewIterableAssert(PCollectionView<Iterable<T>> actual) {
            this.actual = actual;
            this.valueCoder = Optional.absent();
        }

        @Override
        public IterableAssert<T> setCoder(Coder<T> coderOrNull) {
            this.valueCoder = Optional.fromNullable(coderOrNull);
            return this;
        }

        @Override
        public Coder<T> getCoder() {
            if (this.valueCoder.isPresent()) {
                return this.valueCoder.get();
            }
            throw new IllegalArgumentException("Blah");
        }

        @Override
        public IterableAssert<T> inWindow(BoundedWindow window) {
            throw new UnsupportedOperationException("IterableAssert of a PCollectionView does not support windowed assertions");
        }

        @Override
        public IterableAssert<T> inFinalPane(BoundedWindow window) {
            throw new UnsupportedOperationException("IterableAssert of a PCollectionView does not support windowed assertions");
        }

        @Override
        public IterableAssert<T> inOnTimePane(BoundedWindow window) {
            throw new UnsupportedOperationException("IterableAssert of a PCollectionView does not support windowed assertions");
        }

        @Override
        public IterableAssert<T> inCombinedNonLatePanes(BoundedWindow window) {
            throw new UnsupportedOperationException("IterableAssert of a PCollectionView does not support windowed assertions");
        }

        @Override
        public IterableAssert<T> inEarlyGlobalWindowPanes() {
            throw new UnsupportedOperationException("IterableAssert of a PCollectionView does not support windowed assertions");
        }

        @Override
        public IterableAssert<T> containsInAnyOrder(T ... expectedElements) {
            return this.containsInAnyOrder((Iterable<T>)ImmutableList.copyOf(expectedElements));
        }

        @Override
        public IterableAssert<T> containsInAnyOrder(Iterable<T> expectedElements) {
            return this.satisfies(new AssertContainsInAnyOrderRelation(), expectedElements);
        }

        private IterableAssert<T> satisfies(AssertRelation<Iterable<T>, Iterable<T>> relation, Iterable<T> expectedElements) {
            Coder<T> elemCoder;
            if (this.valueCoder.isPresent()) {
                elemCoder = this.valueCoder.get();
            } else {
                try {
                    elemCoder = Create.of(expectedElements).getDefaultOutputCoder(this.actual.getPipeline().begin());
                }
                catch (CannotProvideCoderException e) {
                    throw new IllegalArgumentException("Attempted to infer the Coder of an IterableAssert, but no Coder was explicitly set and no coder could be inferred", e);
                }
            }
            return this.satisfies(new CheckRelationAgainstExpected<Iterable<T>>(relation, expectedElements, IterableCoder.of(elemCoder)));
        }

        @Override
        public IterableAssert<T> empty() {
            return this.containsInAnyOrder(new Object[0]);
        }

        @Override
        public IterableAssert<T> satisfies(SerializableFunction<Iterable<T>, Void> checkerFn) {
            PTransform identity = new PTransform<PBegin, PCollectionView<Iterable<T>>>(){

                @Override
                public PCollectionView<Iterable<T>> apply(PBegin input) {
                    return PCollectionViewIterableAssert.this.actual;
                }
            };
            this.actual.getPipeline().apply(DataflowAssert.nextAssertionName(), new OneSideInputAssert(identity, Window.into(new GlobalWindows()), checkerFn));
            return this;
        }

        @Deprecated
        public boolean equals(Object o) {
            throw new UnsupportedOperationException("If you meant to test object equality, use .containsInAnyOrder instead.");
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException(String.format("%s.hashCode() is not supported.", IterableAssert.class.getSimpleName()));
        }
    }

    private static class PCollectionSingletonIterableAssert<T>
    implements IterableAssert<T> {
        private final PCollection<Iterable<T>> actual;
        private final Coder<T> elementCoder;
        private final AssertionWindows rewindowingStrategy;
        private final SimpleFunction<Iterable<WindowedValue<Iterable<T>>>, Iterable<Iterable<T>>> paneExtractor;

        public PCollectionSingletonIterableAssert(PCollection<Iterable<T>> actual) {
            this(actual, IntoGlobalWindow.of(), PaneExtractors.onlyPane());
        }

        public PCollectionSingletonIterableAssert(PCollection<Iterable<T>> actual, AssertionWindows rewindowingStrategy, SimpleFunction<Iterable<WindowedValue<Iterable<T>>>, Iterable<Iterable<T>>> paneExtractor) {
            this.actual = actual;
            Coder<?> typedCoder = actual.getCoder().getCoderArguments().get(0);
            this.elementCoder = typedCoder;
            this.rewindowingStrategy = rewindowingStrategy;
            this.paneExtractor = paneExtractor;
        }

        @Override
        public PCollectionSingletonIterableAssert<T> inWindow(BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.allPanes());
        }

        @Override
        public PCollectionSingletonIterableAssert<T> inFinalPane(BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.finalPane());
        }

        @Override
        public PCollectionSingletonIterableAssert<T> inOnTimePane(BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.onTimePane());
        }

        @Override
        public PCollectionSingletonIterableAssert<T> inCombinedNonLatePanes(BoundedWindow window) {
            return this.withPanes(window, PaneExtractors.nonLatePanes());
        }

        @Override
        public IterableAssert<T> inEarlyGlobalWindowPanes() {
            return this.withPanes(GlobalWindow.INSTANCE, PaneExtractors.earlyPanes());
        }

        private PCollectionSingletonIterableAssert<T> withPanes(BoundedWindow window, SimpleFunction<Iterable<WindowedValue<Iterable<T>>>, Iterable<Iterable<T>>> paneExtractor) {
            Coder<BoundedWindow> windowCoder = this.actual.getWindowingStrategy().getWindowFn().windowCoder();
            return new PCollectionSingletonIterableAssert<T>(this.actual, IntoStaticWindows.of(windowCoder, window), paneExtractor);
        }

        @Override
        public IterableAssert<T> setCoder(Coder<T> coderOrNull) {
            return this;
        }

        @Override
        public Coder<T> getCoder() {
            return this.elementCoder;
        }

        @Override
        @SafeVarargs
        public final PCollectionSingletonIterableAssert<T> containsInAnyOrder(T ... expectedElements) {
            return this.containsInAnyOrder(Arrays.asList(expectedElements));
        }

        @Override
        public PCollectionSingletonIterableAssert<T> empty() {
            return this.containsInAnyOrder((Iterable)Collections.emptyList());
        }

        @Override
        public PCollectionSingletonIterableAssert<T> containsInAnyOrder(Iterable<T> expectedElements) {
            return this.satisfies(new AssertContainsInAnyOrderRelation(), expectedElements);
        }

        @Override
        public PCollectionSingletonIterableAssert<T> satisfies(SerializableFunction<Iterable<T>, Void> checkerFn) {
            this.actual.apply("DataflowAssert$" + assertCount++, new GroupThenAssertForSingleton(checkerFn, this.rewindowingStrategy, this.paneExtractor));
            return this;
        }

        private PCollectionSingletonIterableAssert<T> satisfies(AssertRelation<Iterable<T>, Iterable<T>> relation, Iterable<T> expectedElements) {
            return this.satisfies(new CheckRelationAgainstExpected<Iterable<T>>(relation, expectedElements, IterableCoder.of(this.elementCoder)));
        }
    }

    private static class PCollectionContentsAssert<T>
    implements IterableAssert<T> {
        private final PCollection<T> actual;
        private final AssertionWindows rewindowingStrategy;
        private final SimpleFunction<Iterable<WindowedValue<T>>, Iterable<T>> paneExtractor;

        public PCollectionContentsAssert(PCollection<T> actual) {
            this(actual, IntoGlobalWindow.of(), PaneExtractors.onlyPane());
        }

        public PCollectionContentsAssert(PCollection<T> actual, AssertionWindows rewindowingStrategy, SimpleFunction<Iterable<WindowedValue<T>>, Iterable<T>> paneExtractor) {
            this.actual = actual;
            this.rewindowingStrategy = rewindowingStrategy;
            this.paneExtractor = paneExtractor;
        }

        @Override
        public PCollectionContentsAssert<T> inWindow(BoundedWindow window) {
            return this.withPane(window, PaneExtractors.allPanes());
        }

        @Override
        public PCollectionContentsAssert<T> inFinalPane(BoundedWindow window) {
            return this.withPane(window, PaneExtractors.finalPane());
        }

        @Override
        public PCollectionContentsAssert<T> inOnTimePane(BoundedWindow window) {
            return this.withPane(window, PaneExtractors.onTimePane());
        }

        @Override
        public PCollectionContentsAssert<T> inCombinedNonLatePanes(BoundedWindow window) {
            return this.withPane(window, PaneExtractors.nonLatePanes());
        }

        @Override
        public IterableAssert<T> inEarlyGlobalWindowPanes() {
            return this.withPane(GlobalWindow.INSTANCE, PaneExtractors.earlyPanes());
        }

        private PCollectionContentsAssert<T> withPane(BoundedWindow window, SimpleFunction<Iterable<WindowedValue<T>>, Iterable<T>> paneExtractor) {
            Coder<BoundedWindow> windowCoder = this.actual.getWindowingStrategy().getWindowFn().windowCoder();
            return new PCollectionContentsAssert<T>(this.actual, IntoStaticWindows.of(windowCoder, window), paneExtractor);
        }

        @Override
        public IterableAssert<T> setCoder(Coder<T> coderOrNull) {
            if (coderOrNull != null) {
                this.actual.setCoder((Coder)coderOrNull);
            }
            return this;
        }

        @Override
        public Coder<T> getCoder() {
            return this.actual.getCoder();
        }

        @Override
        @SafeVarargs
        public final PCollectionContentsAssert<T> containsInAnyOrder(T ... expectedElements) {
            return this.containsInAnyOrder(Arrays.asList(expectedElements));
        }

        @Override
        public PCollectionContentsAssert<T> containsInAnyOrder(Iterable<T> expectedElements) {
            return this.satisfies(new AssertContainsInAnyOrderRelation(), expectedElements);
        }

        @Override
        public PCollectionContentsAssert<T> empty() {
            this.containsInAnyOrder((Iterable)Collections.emptyList());
            return this;
        }

        @Override
        public PCollectionContentsAssert<T> satisfies(SerializableFunction<Iterable<T>, Void> checkerFn) {
            this.actual.apply(DataflowAssert.nextAssertionName(), new GroupThenAssert(checkerFn, this.rewindowingStrategy, this.paneExtractor));
            return this;
        }

        @SafeVarargs
        final PCollectionContentsAssert<T> containsInAnyOrder(SerializableMatcher<? super T> ... elementMatchers) {
            return this.satisfies(SerializableMatchers.containsInAnyOrder(elementMatchers));
        }

        private PCollectionContentsAssert<T> satisfies(AssertRelation<Iterable<T>, Iterable<T>> relation, Iterable<T> expectedElements) {
            return this.satisfies(new CheckRelationAgainstExpected<Iterable<T>>(relation, expectedElements, IterableCoder.of(this.actual.getCoder())));
        }

        PCollectionContentsAssert<T> satisfies(SerializableMatcher<Iterable<? extends T>> matcher) {
            MatcherCheckerFn<Iterable<? extends T>> checkerFn = new MatcherCheckerFn<Iterable<? extends T>>(matcher);
            this.actual.apply("DataflowAssert$" + assertCount++, new GroupThenAssert(checkerFn, this.rewindowingStrategy, this.paneExtractor));
            return this;
        }

        @Deprecated
        public boolean equals(Object o) {
            throw new UnsupportedOperationException("If you meant to test object equality, use .containsInAnyOrder instead.");
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException(String.format("%s.hashCode() is not supported.", IterableAssert.class.getSimpleName()));
        }

        private static class MatcherCheckerFn<T>
        implements SerializableFunction<T, Void> {
            private SerializableMatcher<T> matcher;

            public MatcherCheckerFn(SerializableMatcher<T> matcher) {
                this.matcher = matcher;
            }

            @Override
            public Void apply(T actual) {
                Assert.assertThat(actual, this.matcher);
                return null;
            }
        }
    }

    public static interface SingletonAssert<T> {
        @Deprecated
        public SingletonAssert<T> setCoder(Coder<T> var1);

        @Deprecated
        public Coder<T> getCoder();

        public SingletonAssert<T> inOnlyPane(BoundedWindow var1);

        public SingletonAssert<T> inFinalPane(BoundedWindow var1);

        public SingletonAssert<T> inOnTimePane(BoundedWindow var1);

        public SingletonAssert<T> isEqualTo(T var1);

        @Deprecated
        public SingletonAssert<T> is(T var1);

        public SingletonAssert<T> notEqualTo(T var1);

        public SingletonAssert<T> satisfies(SerializableFunction<T, Void> var1);
    }

    public static interface IterableAssert<T> {
        @Deprecated
        public IterableAssert<T> setCoder(Coder<T> var1);

        @Deprecated
        public Coder<T> getCoder();

        public IterableAssert<T> inWindow(BoundedWindow var1);

        public IterableAssert<T> inFinalPane(BoundedWindow var1);

        public IterableAssert<T> inOnTimePane(BoundedWindow var1);

        public IterableAssert<T> inCombinedNonLatePanes(BoundedWindow var1);

        public IterableAssert<T> inEarlyGlobalWindowPanes();

        public IterableAssert<T> containsInAnyOrder(T ... var1);

        public IterableAssert<T> containsInAnyOrder(Iterable<T> var1);

        public IterableAssert<T> empty();

        public IterableAssert<T> satisfies(SerializableFunction<Iterable<T>, Void> var1);
    }
}

