/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.testing;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.transforms.SimpleFunction;
import com.google.cloud.dataflow.sdk.transforms.windowing.PaneInfo;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import java.util.ArrayList;

final class PaneExtractors {
    private PaneExtractors() {
    }

    static <T> SimpleFunction<Iterable<WindowedValue<T>>, Iterable<T>> onlyPane() {
        return new ExtractOnlyPane();
    }

    static <T> SimpleFunction<Iterable<WindowedValue<T>>, Iterable<T>> onTimePane() {
        return new ExtractOnTimePane();
    }

    static <T> SimpleFunction<Iterable<WindowedValue<T>>, Iterable<T>> finalPane() {
        return new ExtractFinalPane();
    }

    static <T> SimpleFunction<Iterable<WindowedValue<T>>, Iterable<T>> nonLatePanes() {
        return new ExtractNonLatePanes();
    }

    static <T> SimpleFunction<Iterable<WindowedValue<T>>, Iterable<T>> earlyPanes() {
        return new ExtractEarlyPanes();
    }

    static <T> SimpleFunction<Iterable<WindowedValue<T>>, Iterable<T>> allPanes() {
        return new ExtractAllPanes();
    }

    private static class ExtractEarlyPanes<T>
    extends SimpleFunction<Iterable<WindowedValue<T>>, Iterable<T>> {
        private ExtractEarlyPanes() {
        }

        @Override
        public Iterable<T> apply(Iterable<WindowedValue<T>> input) {
            ArrayList<T> outputs = new ArrayList<T>();
            for (WindowedValue<T> value : input) {
                if (value.getPane().getTiming() != PaneInfo.Timing.EARLY) continue;
                outputs.add(value.getValue());
            }
            return outputs;
        }
    }

    private static class ExtractNonLatePanes<T>
    extends SimpleFunction<Iterable<WindowedValue<T>>, Iterable<T>> {
        private ExtractNonLatePanes() {
        }

        @Override
        public Iterable<T> apply(Iterable<WindowedValue<T>> input) {
            ArrayList<T> outputs = new ArrayList<T>();
            for (WindowedValue<T> value : input) {
                if (value.getPane().getTiming() == PaneInfo.Timing.LATE) continue;
                outputs.add(value.getValue());
            }
            return outputs;
        }
    }

    private static class ExtractAllPanes<T>
    extends SimpleFunction<Iterable<WindowedValue<T>>, Iterable<T>> {
        private ExtractAllPanes() {
        }

        @Override
        public Iterable<T> apply(Iterable<WindowedValue<T>> input) {
            ArrayList<T> outputs = new ArrayList<T>();
            for (WindowedValue<T> value : input) {
                outputs.add(value.getValue());
            }
            return outputs;
        }
    }

    private static class ExtractFinalPane<T>
    extends SimpleFunction<Iterable<WindowedValue<T>>, Iterable<T>> {
        private ExtractFinalPane() {
        }

        @Override
        public Iterable<T> apply(Iterable<WindowedValue<T>> input) {
            ArrayList<T> outputs = new ArrayList<T>();
            for (WindowedValue<T> value : input) {
                if (!value.getPane().isLast()) continue;
                outputs.add(value.getValue());
            }
            return outputs;
        }
    }

    private static class ExtractOnTimePane<T>
    extends SimpleFunction<Iterable<WindowedValue<T>>, Iterable<T>> {
        private ExtractOnTimePane() {
        }

        @Override
        public Iterable<T> apply(Iterable<WindowedValue<T>> input) {
            ArrayList<T> outputs = new ArrayList<T>();
            for (WindowedValue<T> value : input) {
                if (!value.getPane().getTiming().equals((Object)PaneInfo.Timing.ON_TIME)) continue;
                outputs.add(value.getValue());
            }
            return outputs;
        }
    }

    private static class ExtractOnlyPane<T>
    extends SimpleFunction<Iterable<WindowedValue<T>>, Iterable<T>> {
        private ExtractOnlyPane() {
        }

        @Override
        public Iterable<T> apply(Iterable<WindowedValue<T>> input) {
            ArrayList<T> outputs = new ArrayList<T>();
            for (WindowedValue<T> value : input) {
                Preconditions.checkState(value.getPane().isFirst() && value.getPane().isLast(), "Expected elements to be produced by a trigger that fires at most once, but gota value in a pane that is %s. Actual Pane Info: %s", value.getPane().isFirst() ? "not the last pane" : "not the first pane", value.getPane());
                outputs.add(value.getValue());
            }
            return outputs;
        }
    }
}

