/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.testing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.PipelineResult;
import com.google.cloud.dataflow.sdk.options.ApplicationNameOptions;
import com.google.cloud.dataflow.sdk.options.GcpOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptionsFactory;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Optional;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterators;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.UnmodifiableIterator;
import com.google.cloud.dataflow.sdk.runners.DataflowPipelineRunner;
import com.google.cloud.dataflow.sdk.runners.PipelineRunner;
import com.google.cloud.dataflow.sdk.testing.TestDataflowPipelineRunner;
import com.google.cloud.dataflow.sdk.util.TestCredential;
import java.io.IOException;

public class TestPipeline
extends Pipeline {
    private static final String PROPERTY_DATAFLOW_OPTIONS = "dataflowOptions";
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static TestPipeline create() {
        return TestPipeline.fromOptions(TestPipeline.testingPipelineOptions());
    }

    public static TestPipeline fromOptions(PipelineOptions options) {
        return new TestPipeline((PipelineRunner<? extends PipelineResult>)PipelineRunner.fromOptions(options), options);
    }

    public boolean supportsDynamicWorkRebalancing() {
        return this.getRunner() instanceof DataflowPipelineRunner;
    }

    private TestPipeline(PipelineRunner<? extends PipelineResult> runner, PipelineOptions options) {
        super(runner, options);
    }

    @Override
    public PipelineResult run() {
        try {
            return super.run();
        }
        catch (RuntimeException exc) {
            Throwable cause = exc.getCause();
            if (cause instanceof AssertionError) {
                throw (AssertionError)((Object)cause);
            }
            throw exc;
        }
    }

    @Override
    public String toString() {
        return "TestPipeline#" + this.getOptions().as(ApplicationNameOptions.class).getAppName();
    }

    public static PipelineOptions testingPipelineOptions() {
        try {
            String systemDataflowOptions = System.getProperty(PROPERTY_DATAFLOW_OPTIONS);
            PipelineOptions options = systemDataflowOptions == null ? PipelineOptionsFactory.create() : PipelineOptionsFactory.fromArgs((String[])MAPPER.readValue(System.getProperty(PROPERTY_DATAFLOW_OPTIONS), String[].class)).as(PipelineOptions.class);
            options.as(ApplicationNameOptions.class).setAppName(TestPipeline.getAppName());
            if (TestPipeline.isIntegrationTest()) {
                options.setRunner(TestDataflowPipelineRunner.class);
            } else {
                options.as(GcpOptions.class).setGcpCredential(new TestCredential());
            }
            options.setStableUniqueNames(PipelineOptions.CheckEnabled.ERROR);
            return options;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to instantiate test options from system property dataflowOptions:" + System.getProperty(PROPERTY_DATAFLOW_OPTIONS), e);
        }
    }

    private static boolean isIntegrationTest() {
        return Boolean.parseBoolean(System.getProperty("runIntegrationTestOnService"));
    }

    private static String getAppName() {
        Optional<StackTraceElement> stackTraceElement = TestPipeline.findCallersStackTrace();
        if (stackTraceElement.isPresent()) {
            String methodName = stackTraceElement.get().getMethodName();
            String className = stackTraceElement.get().getClassName();
            if (className.contains(".")) {
                className = className.substring(className.lastIndexOf(".") + 1);
            }
            return className + "-" + methodName;
        }
        return "UnitTest";
    }

    private static Optional<StackTraceElement> findCallersStackTrace() {
        StackTraceElement next;
        UnmodifiableIterator<StackTraceElement> elements = Iterators.forArray(Thread.currentThread().getStackTrace());
        while (elements.hasNext()) {
            next = (StackTraceElement)elements.next();
            if (!TestPipeline.class.getName().equals(next.getClassName())) continue;
            break;
        }
        while (elements.hasNext()) {
            next = (StackTraceElement)elements.next();
            if (TestPipeline.class.getName().equals(next.getClassName())) continue;
            return Optional.of(next);
        }
        return Optional.absent();
    }
}

