/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.testing;

import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.IntervalWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.OutputTimeFn;
import com.google.cloud.dataflow.sdk.transforms.windowing.OutputTimeFns;
import com.google.cloud.dataflow.sdk.transforms.windowing.WindowFn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.junit.Assert;

public class WindowFnTestUtils {
    public static Set<String> set(long ... timestamps) {
        HashSet<String> result = new HashSet<String>();
        for (long timestamp : timestamps) {
            result.add(WindowFnTestUtils.timestampValue(timestamp));
        }
        return result;
    }

    public static <T, W extends BoundedWindow> Map<W, Set<String>> runWindowFn(WindowFn<T, W> windowFn, List<Long> timestamps) throws Exception {
        TestWindowSet<BoundedWindow, String> windowSet = new TestWindowSet<BoundedWindow, String>();
        for (Long timestamp : timestamps) {
            for (BoundedWindow window : windowFn.assignWindows(new TestAssignContext<T, W>(new Instant((Object)timestamp), windowFn))) {
                windowSet.put(window, WindowFnTestUtils.timestampValue(timestamp));
            }
            windowFn.mergeWindows(new TestMergeContext(windowSet, windowFn));
        }
        HashMap actual = new HashMap();
        for (BoundedWindow window : windowSet.windows()) {
            actual.put(window, windowSet.get(window));
        }
        return actual;
    }

    public static <T, W extends BoundedWindow> Collection<W> assignedWindows(WindowFn<T, W> windowFn, long timestamp) throws Exception {
        return windowFn.assignWindows(new TestAssignContext<T, W>(new Instant(timestamp), windowFn));
    }

    private static String timestampValue(long timestamp) {
        return "T" + new Instant(timestamp);
    }

    public static <T, W extends BoundedWindow> void validateNonInterferingOutputTimes(WindowFn<T, W> windowFn, long timestamp) throws Exception {
        Collection<BoundedWindow> windows = WindowFnTestUtils.assignedWindows(windowFn, timestamp);
        Instant instant = new Instant(timestamp);
        for (BoundedWindow window : windows) {
            Instant outputTimestamp = windowFn.getOutputTimeFn().assignOutputTime(instant, window);
            Assert.assertFalse((String)"getOutputTime must be greater than or equal to input timestamp", (boolean)outputTimestamp.isBefore((ReadableInstant)instant));
            Assert.assertFalse((String)"getOutputTime must be less than or equal to the max timestamp", (boolean)outputTimestamp.isAfter((ReadableInstant)window.maxTimestamp()));
        }
    }

    public static <T, W extends BoundedWindow> void validateGetOutputTimestamp(WindowFn<T, W> windowFn, long timestamp) throws Exception {
        Collection<W> windows = WindowFnTestUtils.assignedWindows(windowFn, timestamp);
        ArrayList<W> sortedWindows = new ArrayList<W>(windows);
        Collections.sort(sortedWindows, new Comparator<BoundedWindow>(){

            @Override
            public int compare(BoundedWindow o1, BoundedWindow o2) {
                return o1.maxTimestamp().compareTo((ReadableInstant)o2.maxTimestamp());
            }
        });
        Instant instant = new Instant(timestamp);
        Instant endOfPrevious = null;
        for (BoundedWindow window : sortedWindows) {
            Instant outputTimestamp = windowFn.getOutputTimeFn().assignOutputTime(instant, window);
            if (endOfPrevious == null) {
                Assert.assertFalse((String)"getOutputTime must be greater than or equal to input timestamp", (boolean)outputTimestamp.isBefore((ReadableInstant)instant));
                Assert.assertFalse((String)"getOutputTime must be less than or equal to the max timestamp", (boolean)outputTimestamp.isAfter((ReadableInstant)window.maxTimestamp()));
            } else {
                Assert.assertTrue((String)"getOutputTime must be greater than the end of the previous window", (boolean)outputTimestamp.isAfter(endOfPrevious));
                Assert.assertFalse((String)"getOutputTime must be less than or equal to the max timestamp", (boolean)outputTimestamp.isAfter((ReadableInstant)window.maxTimestamp()));
            }
            endOfPrevious = window.maxTimestamp();
        }
    }

    public static <T, W extends IntervalWindow> void validateGetOutputTimestamps(WindowFn<T, W> windowFn, OutputTimeFn<? super W> outputTimeFn, List<List<Long>> timestampsPerWindow) throws Exception {
        IntervalWindow window;
        final ArrayList windows = new ArrayList();
        for (List<Long> timestampsForWindow : timestampsPerWindow) {
            final HashSet<W> windowsToMerge = new HashSet<W>();
            for (long timestamp : timestampsForWindow) {
                windowsToMerge.addAll(WindowFnTestUtils.assignedWindows(windowFn, timestamp));
            }
            WindowFn<T, W> windowFn2 = windowFn;
            windowFn2.getClass();
            windowFn.mergeWindows(new WindowFn.MergeContext(windowFn2){

                @Override
                public Collection<W> windows() {
                    return windowsToMerge;
                }

                @Override
                public void merge(Collection<W> toBeMerged, W mergeResult) throws Exception {
                    windows.add(mergeResult);
                }
            });
        }
        ArrayList<Instant> combinedOutputTimestamps = new ArrayList<Instant>();
        for (int i = 0; i < timestampsPerWindow.size(); ++i) {
            List<Long> timestampsForWindow = timestampsPerWindow.get(i);
            window = (IntervalWindow)windows.get(i);
            ArrayList<Instant> outputInstants = new ArrayList<Instant>();
            for (long inputTimestamp : timestampsForWindow) {
                outputInstants.add(outputTimeFn.assignOutputTime(new Instant(inputTimestamp), window));
            }
            combinedOutputTimestamps.add(OutputTimeFns.combineOutputTimes(outputTimeFn, outputInstants));
        }
        IntervalWindow earlierEndingWindow = null;
        for (int i = 0; i < windows.size(); ++i) {
            window = (IntervalWindow)windows.get(i);
            ReadableInstant outputTimestamp = (ReadableInstant)combinedOutputTimestamps.get(i);
            if (earlierEndingWindow != null) {
                Assert.assertThat((Object)outputTimestamp, (Matcher)Matchers.greaterThan((Comparable)earlierEndingWindow.maxTimestamp()));
            }
            earlierEndingWindow = window;
        }
    }

    private static class TestWindowSet<W extends BoundedWindow, V> {
        private Map<W, Set<V>> elements = new HashMap<W, Set<V>>();

        private TestWindowSet() {
        }

        public void put(W window, V value) {
            Set<V> all = this.elements.get(window);
            if (all == null) {
                all = new HashSet<V>();
                this.elements.put(window, all);
            }
            all.add(value);
        }

        public void merge(Collection<W> otherWindows, W window) {
            if (otherWindows.isEmpty()) {
                return;
            }
            HashSet merged = new HashSet();
            if (this.elements.containsKey(window) && !otherWindows.contains(window)) {
                merged.addAll(this.elements.get(window));
            }
            for (BoundedWindow w : otherWindows) {
                if (!this.elements.containsKey(w)) {
                    throw new IllegalArgumentException("Tried to merge a non-existent window:" + w);
                }
                merged.addAll(this.elements.get(w));
                this.elements.remove(w);
            }
            this.elements.put(window, merged);
        }

        public Collection<W> windows() {
            return this.elements.keySet();
        }

        public Set<V> get(W window) {
            return this.elements.get(window);
        }
    }

    private static class TestMergeContext<T, W extends BoundedWindow>
    extends WindowFn.MergeContext {
        private TestWindowSet<W, ?> windowSet;

        public TestMergeContext(TestWindowSet<W, ?> windowSet, WindowFn<T, W> windowFn) {
            super(windowFn);
            this.windowSet = windowSet;
        }

        @Override
        public Collection<W> windows() {
            return this.windowSet.windows();
        }

        @Override
        public void merge(Collection<W> toBeMerged, W mergeResult) {
            this.windowSet.merge(toBeMerged, mergeResult);
        }
    }

    private static class TestAssignContext<T, W extends BoundedWindow>
    extends WindowFn.AssignContext {
        private Instant timestamp;

        public TestAssignContext(Instant timestamp, WindowFn<T, W> windowFn) {
            super(windowFn);
            this.timestamp = timestamp;
        }

        @Override
        public T element() {
            return null;
        }

        @Override
        public Instant timestamp() {
            return this.timestamp;
        }

        @Override
        public Collection<? extends BoundedWindow> windows() {
            return null;
        }
    }
}

