/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.coders.CannotProvideCoderException;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.CoderRegistry;
import com.google.cloud.dataflow.sdk.coders.StandardCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ArrayListMultimap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Lists;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Maps;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.transforms.CombineFnBase;
import com.google.cloud.dataflow.sdk.transforms.CombineWithContext;
import com.google.cloud.dataflow.sdk.transforms.SerializableFunction;
import com.google.cloud.dataflow.sdk.transforms.SimpleFunction;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.transforms.display.HasDisplayData;
import com.google.cloud.dataflow.sdk.values.TupleTag;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CombineFns {
    public static ComposeKeyedCombineFnBuilder composeKeyed() {
        return new ComposeKeyedCombineFnBuilder();
    }

    public static ComposeCombineFnBuilder compose() {
        return new ComposeCombineFnBuilder();
    }

    private static <InputT, AccumT, OutputT> CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> toFnWithContext(CombineFnBase.GlobalCombineFn<InputT, AccumT, OutputT> globalCombineFn) {
        if (globalCombineFn instanceof CombineWithContext.CombineFnWithContext) {
            return (CombineWithContext.CombineFnWithContext)globalCombineFn;
        }
        final Combine.CombineFn combineFn = (Combine.CombineFn)globalCombineFn;
        return new CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT>(){

            @Override
            public AccumT createAccumulator(CombineWithContext.Context c) {
                return combineFn.createAccumulator();
            }

            @Override
            public AccumT addInput(AccumT accumulator, InputT input, CombineWithContext.Context c) {
                return combineFn.addInput(accumulator, input);
            }

            @Override
            public AccumT mergeAccumulators(Iterable<AccumT> accumulators, CombineWithContext.Context c) {
                return combineFn.mergeAccumulators(accumulators);
            }

            @Override
            public OutputT extractOutput(AccumT accumulator, CombineWithContext.Context c) {
                return combineFn.extractOutput(accumulator);
            }

            @Override
            public AccumT compact(AccumT accumulator, CombineWithContext.Context c) {
                return combineFn.compact(accumulator);
            }

            @Override
            public OutputT defaultValue() {
                return combineFn.defaultValue();
            }

            @Override
            public Coder<AccumT> getAccumulatorCoder(CoderRegistry registry, Coder<InputT> inputCoder) throws CannotProvideCoderException {
                return combineFn.getAccumulatorCoder(registry, inputCoder);
            }

            @Override
            public Coder<OutputT> getDefaultOutputCoder(CoderRegistry registry, Coder<InputT> inputCoder) throws CannotProvideCoderException {
                return combineFn.getDefaultOutputCoder(registry, inputCoder);
            }
        };
    }

    private static <K, InputT, AccumT, OutputT> CombineWithContext.KeyedCombineFnWithContext<K, InputT, AccumT, OutputT> toFnWithContext(CombineFnBase.PerKeyCombineFn<K, InputT, AccumT, OutputT> perKeyCombineFn) {
        if (perKeyCombineFn instanceof CombineWithContext.KeyedCombineFnWithContext) {
            CombineWithContext.KeyedCombineFnWithContext keyedCombineFnWithContext = (CombineWithContext.KeyedCombineFnWithContext)perKeyCombineFn;
            return keyedCombineFnWithContext;
        }
        final Combine.KeyedCombineFn keyedCombineFn = (Combine.KeyedCombineFn)perKeyCombineFn;
        return new CombineWithContext.KeyedCombineFnWithContext<K, InputT, AccumT, OutputT>(){

            @Override
            public AccumT createAccumulator(K key, CombineWithContext.Context c) {
                return keyedCombineFn.createAccumulator(key);
            }

            @Override
            public AccumT addInput(K key, AccumT accumulator, InputT value, CombineWithContext.Context c) {
                return keyedCombineFn.addInput(key, accumulator, value);
            }

            @Override
            public AccumT mergeAccumulators(K key, Iterable<AccumT> accumulators, CombineWithContext.Context c) {
                return keyedCombineFn.mergeAccumulators(key, accumulators);
            }

            @Override
            public OutputT extractOutput(K key, AccumT accumulator, CombineWithContext.Context c) {
                return keyedCombineFn.extractOutput(key, accumulator);
            }

            @Override
            public AccumT compact(K key, AccumT accumulator, CombineWithContext.Context c) {
                return keyedCombineFn.compact(key, accumulator);
            }

            @Override
            public Coder<AccumT> getAccumulatorCoder(CoderRegistry registry, Coder<K> keyCoder, Coder<InputT> inputCoder) throws CannotProvideCoderException {
                return keyedCombineFn.getAccumulatorCoder(registry, keyCoder, inputCoder);
            }

            @Override
            public Coder<OutputT> getDefaultOutputCoder(CoderRegistry registry, Coder<K> keyCoder, Coder<InputT> inputCoder) throws CannotProvideCoderException {
                return keyedCombineFn.getDefaultOutputCoder(registry, keyCoder, inputCoder);
            }
        };
    }

    private static <OutputT> void checkUniqueness(List<TupleTag<?>> registeredTags, TupleTag<OutputT> outputTag) {
        Preconditions.checkArgument(!registeredTags.contains(outputTag), "Cannot compose with tuple tag %s because it is already present in the composition.", outputTag);
    }

    private static void populateDisplayData(DisplayData.Builder builder, List<? extends HasDisplayData> combineFns) {
        ArrayListMultimap<Class<?>, HasDisplayData> combineFnMap = ArrayListMultimap.create();
        for (int i = 0; i < combineFns.size(); ++i) {
            HasDisplayData combineFn = combineFns.get(i);
            builder.add(DisplayData.item("combineFn" + (i + 1), combineFn.getClass()).withLabel("Combine Function"));
            combineFnMap.put(combineFn.getClass(), combineFn);
        }
        for (Map.Entry combineFnEntries : combineFnMap.asMap().entrySet()) {
            Collection classCombineFns = combineFnEntries.getValue();
            if (classCombineFns.size() == 1) {
                builder.include((HasDisplayData)Iterables.getOnlyElement(classCombineFns));
                continue;
            }
            String baseNamespace = ((Class)combineFnEntries.getKey()).getName();
            for (int i = 0; i < combineFns.size(); ++i) {
                HasDisplayData combineFn = combineFns.get(i);
                String namespace = String.format("%s#%d", baseNamespace, i + 1);
                builder.include(combineFn, namespace);
            }
        }
    }

    private static class ComposedAccumulatorCoder
    extends StandardCoder<Object[]> {
        private List<Coder<Object>> coders;
        private int codersCount;

        public ComposedAccumulatorCoder(List<Coder<Object>> coders) {
            this.coders = ImmutableList.copyOf(coders);
            this.codersCount = coders.size();
        }

        @JsonCreator
        public static ComposedAccumulatorCoder of(@JsonProperty(value="component_encodings") List<Coder<?>> components) {
            return new ComposedAccumulatorCoder(components);
        }

        @Override
        public void encode(Object[] value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
            Preconditions.checkArgument(value.length == this.codersCount);
            Coder.Context nestedContext = context.nested();
            for (int i = 0; i < this.codersCount; ++i) {
                this.coders.get(i).encode(value[i], outStream, nestedContext);
            }
        }

        @Override
        public Object[] decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
            Object[] ret = new Object[this.codersCount];
            Coder.Context nestedContext = context.nested();
            for (int i = 0; i < this.codersCount; ++i) {
                ret[i] = this.coders.get(i).decode(inStream, nestedContext);
            }
            return ret;
        }

        @Override
        public List<? extends Coder<?>> getCoderArguments() {
            return this.coders;
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            for (int i = 0; i < this.codersCount; ++i) {
                this.coders.get(i).verifyDeterministic();
            }
        }
    }

    private static class ProjectionIterable
    implements Iterable<Object> {
        private final Iterable<Object[]> iterable;
        private final int column;

        private ProjectionIterable(Iterable<Object[]> iterable, int column) {
            this.iterable = iterable;
            this.column = column;
        }

        @Override
        public Iterator<Object> iterator() {
            final Iterator<Object[]> iter = this.iterable.iterator();
            return new Iterator<Object>(){

                @Override
                public boolean hasNext() {
                    return iter.hasNext();
                }

                @Override
                public Object next() {
                    return ((Object[])iter.next())[ProjectionIterable.this.column];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static class ComposedKeyedCombineFnWithContext<DataT, K>
    extends CombineWithContext.KeyedCombineFnWithContext<K, DataT, Object[], CoCombineResult> {
        private final List<SerializableFunction<DataT, Object>> extractInputFns;
        private final List<CombineWithContext.KeyedCombineFnWithContext<K, Object, Object, Object>> keyedCombineFns;
        private final List<TupleTag<?>> outputTags;
        private final int combineFnCount;

        private ComposedKeyedCombineFnWithContext() {
            this.extractInputFns = ImmutableList.of();
            this.keyedCombineFns = ImmutableList.of();
            this.outputTags = ImmutableList.of();
            this.combineFnCount = 0;
        }

        private ComposedKeyedCombineFnWithContext(ImmutableList<SerializableFunction<DataT, ?>> extractInputFns, ImmutableList<CombineWithContext.KeyedCombineFnWithContext<K, ?, ?, ?>> keyedCombineFns, ImmutableList<TupleTag<?>> outputTags) {
            ImmutableList<SerializableFunction<DataT, ?>> castedExtractInputFns = extractInputFns;
            this.extractInputFns = castedExtractInputFns;
            ImmutableList<CombineWithContext.KeyedCombineFnWithContext<K, ?, ?, ?>> castedKeyedCombineFns = keyedCombineFns;
            this.keyedCombineFns = castedKeyedCombineFns;
            this.outputTags = outputTags;
            this.combineFnCount = this.keyedCombineFns.size();
        }

        public <InputT, OutputT> ComposedKeyedCombineFnWithContext<DataT, K> with(SimpleFunction<DataT, InputT> extractInputFn, CombineFnBase.PerKeyCombineFn<K, InputT, ?, OutputT> perKeyCombineFn, TupleTag<OutputT> outputTag) {
            CombineFns.checkUniqueness(this.outputTags, outputTag);
            return new ComposedKeyedCombineFnWithContext<DataT, K>(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.extractInputFns)).add(extractInputFn)).build(), ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.keyedCombineFns)).add(CombineFns.toFnWithContext(perKeyCombineFn))).build(), (ImmutableList<TupleTag<?>>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.outputTags)).add(outputTag)).build());
        }

        public <InputT, OutputT> ComposedKeyedCombineFnWithContext<DataT, K> with(SimpleFunction<DataT, InputT> extractInputFn, CombineFnBase.GlobalCombineFn<InputT, ?, OutputT> perKeyCombineFn, TupleTag<OutputT> outputTag) {
            return this.with(extractInputFn, perKeyCombineFn.asKeyedFn(), outputTag);
        }

        @Override
        public Object[] createAccumulator(K key, CombineWithContext.Context c) {
            Object[] accumsArray = new Object[this.combineFnCount];
            for (int i = 0; i < this.combineFnCount; ++i) {
                accumsArray[i] = this.keyedCombineFns.get(i).createAccumulator(key, c);
            }
            return accumsArray;
        }

        @Override
        public Object[] addInput(K key, Object[] accumulator, DataT value, CombineWithContext.Context c) {
            for (int i = 0; i < this.combineFnCount; ++i) {
                Object input = this.extractInputFns.get(i).apply(value);
                accumulator[i] = this.keyedCombineFns.get(i).addInput(key, accumulator[i], input, c);
            }
            return accumulator;
        }

        @Override
        public Object[] mergeAccumulators(K key, Iterable<Object[]> accumulators, CombineWithContext.Context c) {
            Iterator<Object[]> iter = accumulators.iterator();
            if (!iter.hasNext()) {
                return this.createAccumulator(key, c);
            }
            Object[] accum = iter.next();
            for (int i = 0; i < this.combineFnCount; ++i) {
                accum[i] = this.keyedCombineFns.get(i).mergeAccumulators(key, new ProjectionIterable(accumulators, i), c);
            }
            return accum;
        }

        @Override
        public CoCombineResult extractOutput(K key, Object[] accumulator, CombineWithContext.Context c) {
            HashMap<TupleTag<?>, Object> valuesMap = Maps.newHashMap();
            for (int i = 0; i < this.combineFnCount; ++i) {
                valuesMap.put(this.outputTags.get(i), this.keyedCombineFns.get(i).extractOutput(key, accumulator[i], c));
            }
            return new CoCombineResult(valuesMap);
        }

        @Override
        public Object[] compact(K key, Object[] accumulator, CombineWithContext.Context c) {
            for (int i = 0; i < this.combineFnCount; ++i) {
                accumulator[i] = this.keyedCombineFns.get(i).compact(key, accumulator[i], c);
            }
            return accumulator;
        }

        @Override
        public Coder<Object[]> getAccumulatorCoder(CoderRegistry registry, Coder<K> keyCoder, Coder<DataT> dataCoder) throws CannotProvideCoderException {
            ArrayList<Coder<Object>> coders = Lists.newArrayList();
            for (int i = 0; i < this.combineFnCount; ++i) {
                Coder<Object> inputCoder = registry.getDefaultOutputCoder(this.extractInputFns.get(i), dataCoder);
                coders.add(this.keyedCombineFns.get(i).getAccumulatorCoder(registry, (Coder)keyCoder, (Coder)inputCoder));
            }
            return new ComposedAccumulatorCoder(coders);
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            CombineFns.populateDisplayData(builder, this.keyedCombineFns);
        }
    }

    public static class ComposedKeyedCombineFn<DataT, K>
    extends Combine.KeyedCombineFn<K, DataT, Object[], CoCombineResult> {
        private final List<SerializableFunction<DataT, Object>> extractInputFns;
        private final List<Combine.KeyedCombineFn<K, Object, Object, Object>> keyedCombineFns;
        private final List<TupleTag<?>> outputTags;
        private final int combineFnCount;

        private ComposedKeyedCombineFn() {
            this.extractInputFns = ImmutableList.of();
            this.keyedCombineFns = ImmutableList.of();
            this.outputTags = ImmutableList.of();
            this.combineFnCount = 0;
        }

        private ComposedKeyedCombineFn(ImmutableList<SerializableFunction<DataT, ?>> extractInputFns, ImmutableList<Combine.KeyedCombineFn<K, ?, ?, ?>> keyedCombineFns, ImmutableList<TupleTag<?>> outputTags) {
            ImmutableList<SerializableFunction<DataT, ?>> castedExtractInputFns = extractInputFns;
            this.extractInputFns = castedExtractInputFns;
            ImmutableList<Combine.KeyedCombineFn<K, ?, ?, ?>> castedKeyedCombineFns = keyedCombineFns;
            this.keyedCombineFns = castedKeyedCombineFns;
            this.outputTags = outputTags;
            this.combineFnCount = this.keyedCombineFns.size();
        }

        public <InputT, OutputT> ComposedKeyedCombineFn<DataT, K> with(SimpleFunction<DataT, InputT> extractInputFn, Combine.KeyedCombineFn<K, InputT, ?, OutputT> keyedCombineFn, TupleTag<OutputT> outputTag) {
            CombineFns.checkUniqueness(this.outputTags, outputTag);
            return new ComposedKeyedCombineFn<DataT, K>(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.extractInputFns)).add(extractInputFn)).build(), ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.keyedCombineFns)).add(keyedCombineFn)).build(), (ImmutableList<TupleTag<?>>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.outputTags)).add(outputTag)).build());
        }

        public <InputT, OutputT> ComposedKeyedCombineFnWithContext<DataT, K> with(SimpleFunction<DataT, InputT> extractInputFn, CombineWithContext.KeyedCombineFnWithContext<K, InputT, ?, OutputT> keyedCombineFn, TupleTag<OutputT> outputTag) {
            CombineFns.checkUniqueness(this.outputTags, outputTag);
            ArrayList<CombineWithContext.KeyedCombineFnWithContext> fnsWithContext = Lists.newArrayList();
            for (Combine.KeyedCombineFn<K, Object, Object, Object> fn : this.keyedCombineFns) {
                fnsWithContext.add(CombineFns.toFnWithContext(fn));
            }
            return new ComposedKeyedCombineFnWithContext((ImmutableList)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.extractInputFns)).add(extractInputFn)).build(), (ImmutableList)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(fnsWithContext)).add(keyedCombineFn)).build(), (ImmutableList)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.outputTags)).add(outputTag)).build());
        }

        public <InputT, OutputT> ComposedKeyedCombineFn<DataT, K> with(SimpleFunction<DataT, InputT> extractInputFn, Combine.CombineFn<InputT, ?, OutputT> keyedCombineFn, TupleTag<OutputT> outputTag) {
            return this.with(extractInputFn, (Combine.KeyedCombineFn<K, InputT, ?, OutputT>)keyedCombineFn.asKeyedFn(), outputTag);
        }

        public <InputT, OutputT> ComposedKeyedCombineFnWithContext<DataT, K> with(SimpleFunction<DataT, InputT> extractInputFn, CombineWithContext.CombineFnWithContext<InputT, ?, OutputT> keyedCombineFn, TupleTag<OutputT> outputTag) {
            return this.with(extractInputFn, (CombineWithContext.KeyedCombineFnWithContext<K, InputT, ?, OutputT>)keyedCombineFn.asKeyedFn(), outputTag);
        }

        @Override
        public Object[] createAccumulator(K key) {
            Object[] accumsArray = new Object[this.combineFnCount];
            for (int i = 0; i < this.combineFnCount; ++i) {
                accumsArray[i] = this.keyedCombineFns.get(i).createAccumulator(key);
            }
            return accumsArray;
        }

        @Override
        public Object[] addInput(K key, Object[] accumulator, DataT value) {
            for (int i = 0; i < this.combineFnCount; ++i) {
                Object input = this.extractInputFns.get(i).apply(value);
                accumulator[i] = this.keyedCombineFns.get(i).addInput(key, accumulator[i], input);
            }
            return accumulator;
        }

        @Override
        public Object[] mergeAccumulators(K key, Iterable<Object[]> accumulators) {
            Iterator<Object[]> iter = accumulators.iterator();
            if (!iter.hasNext()) {
                return this.createAccumulator(key);
            }
            Object[] accum = iter.next();
            for (int i = 0; i < this.combineFnCount; ++i) {
                accum[i] = this.keyedCombineFns.get(i).mergeAccumulators(key, new ProjectionIterable(accumulators, i));
            }
            return accum;
        }

        @Override
        public CoCombineResult extractOutput(K key, Object[] accumulator) {
            HashMap<TupleTag<?>, Object> valuesMap = Maps.newHashMap();
            for (int i = 0; i < this.combineFnCount; ++i) {
                valuesMap.put(this.outputTags.get(i), this.keyedCombineFns.get(i).extractOutput(key, accumulator[i]));
            }
            return new CoCombineResult(valuesMap);
        }

        @Override
        public Object[] compact(K key, Object[] accumulator) {
            for (int i = 0; i < this.combineFnCount; ++i) {
                accumulator[i] = this.keyedCombineFns.get(i).compact(key, accumulator[i]);
            }
            return accumulator;
        }

        @Override
        public Coder<Object[]> getAccumulatorCoder(CoderRegistry registry, Coder<K> keyCoder, Coder<DataT> dataCoder) throws CannotProvideCoderException {
            ArrayList<Coder<Object>> coders = Lists.newArrayList();
            for (int i = 0; i < this.combineFnCount; ++i) {
                Coder<Object> inputCoder = registry.getDefaultOutputCoder(this.extractInputFns.get(i), dataCoder);
                coders.add(this.keyedCombineFns.get(i).getAccumulatorCoder(registry, (Coder)keyCoder, (Coder)inputCoder));
            }
            return new ComposedAccumulatorCoder(coders);
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            CombineFns.populateDisplayData(builder, this.keyedCombineFns);
        }
    }

    public static class ComposedCombineFnWithContext<DataT>
    extends CombineWithContext.CombineFnWithContext<DataT, Object[], CoCombineResult> {
        private final List<SerializableFunction<DataT, Object>> extractInputFns;
        private final List<CombineWithContext.CombineFnWithContext<Object, Object, Object>> combineFnWithContexts;
        private final List<TupleTag<?>> outputTags;
        private final int combineFnCount;

        private ComposedCombineFnWithContext() {
            this.extractInputFns = ImmutableList.of();
            this.combineFnWithContexts = ImmutableList.of();
            this.outputTags = ImmutableList.of();
            this.combineFnCount = 0;
        }

        private ComposedCombineFnWithContext(ImmutableList<SerializableFunction<DataT, ?>> extractInputFns, ImmutableList<CombineWithContext.CombineFnWithContext<?, ?, ?>> combineFnWithContexts, ImmutableList<TupleTag<?>> outputTags) {
            ImmutableList<SerializableFunction<DataT, ?>> castedExtractInputFns = extractInputFns;
            this.extractInputFns = castedExtractInputFns;
            ImmutableList<CombineWithContext.CombineFnWithContext<?, ?, ?>> castedCombineFnWithContexts = combineFnWithContexts;
            this.combineFnWithContexts = castedCombineFnWithContexts;
            this.outputTags = outputTags;
            this.combineFnCount = this.combineFnWithContexts.size();
        }

        public <InputT, OutputT> ComposedCombineFnWithContext<DataT> with(SimpleFunction<DataT, InputT> extractInputFn, CombineFnBase.GlobalCombineFn<InputT, ?, OutputT> globalCombineFn, TupleTag<OutputT> outputTag) {
            CombineFns.checkUniqueness(this.outputTags, outputTag);
            return new ComposedCombineFnWithContext<DataT>(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.extractInputFns)).add(extractInputFn)).build(), (ImmutableList<CombineWithContext.CombineFnWithContext<?, ?, ?>>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.combineFnWithContexts)).add(CombineFns.toFnWithContext(globalCombineFn))).build(), (ImmutableList<TupleTag<?>>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.outputTags)).add(outputTag)).build());
        }

        @Override
        public Object[] createAccumulator(CombineWithContext.Context c) {
            Object[] accumsArray = new Object[this.combineFnCount];
            for (int i = 0; i < this.combineFnCount; ++i) {
                accumsArray[i] = this.combineFnWithContexts.get(i).createAccumulator(c);
            }
            return accumsArray;
        }

        @Override
        public Object[] addInput(Object[] accumulator, DataT value, CombineWithContext.Context c) {
            for (int i = 0; i < this.combineFnCount; ++i) {
                Object input = this.extractInputFns.get(i).apply(value);
                accumulator[i] = this.combineFnWithContexts.get(i).addInput(accumulator[i], input, c);
            }
            return accumulator;
        }

        @Override
        public Object[] mergeAccumulators(Iterable<Object[]> accumulators, CombineWithContext.Context c) {
            Iterator<Object[]> iter = accumulators.iterator();
            if (!iter.hasNext()) {
                return this.createAccumulator(c);
            }
            Object[] accum = iter.next();
            for (int i = 0; i < this.combineFnCount; ++i) {
                accum[i] = this.combineFnWithContexts.get(i).mergeAccumulators(new ProjectionIterable(accumulators, i), c);
            }
            return accum;
        }

        @Override
        public CoCombineResult extractOutput(Object[] accumulator, CombineWithContext.Context c) {
            HashMap<TupleTag<?>, Object> valuesMap = Maps.newHashMap();
            for (int i = 0; i < this.combineFnCount; ++i) {
                valuesMap.put(this.outputTags.get(i), this.combineFnWithContexts.get(i).extractOutput(accumulator[i], c));
            }
            return new CoCombineResult(valuesMap);
        }

        @Override
        public Object[] compact(Object[] accumulator, CombineWithContext.Context c) {
            for (int i = 0; i < this.combineFnCount; ++i) {
                accumulator[i] = this.combineFnWithContexts.get(i).compact(accumulator[i], c);
            }
            return accumulator;
        }

        @Override
        public Coder<Object[]> getAccumulatorCoder(CoderRegistry registry, Coder<DataT> dataCoder) throws CannotProvideCoderException {
            ArrayList<Coder<Object>> coders = Lists.newArrayList();
            for (int i = 0; i < this.combineFnCount; ++i) {
                Coder<Object> inputCoder = registry.getDefaultOutputCoder(this.extractInputFns.get(i), dataCoder);
                coders.add(this.combineFnWithContexts.get(i).getAccumulatorCoder(registry, (Coder)inputCoder));
            }
            return new ComposedAccumulatorCoder(coders);
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            CombineFns.populateDisplayData(builder, this.combineFnWithContexts);
        }
    }

    public static class ComposedCombineFn<DataT>
    extends Combine.CombineFn<DataT, Object[], CoCombineResult> {
        private final List<Combine.CombineFn<Object, Object, Object>> combineFns;
        private final List<SerializableFunction<DataT, Object>> extractInputFns;
        private final List<TupleTag<?>> outputTags;
        private final int combineFnCount;

        private ComposedCombineFn() {
            this.extractInputFns = ImmutableList.of();
            this.combineFns = ImmutableList.of();
            this.outputTags = ImmutableList.of();
            this.combineFnCount = 0;
        }

        private ComposedCombineFn(ImmutableList<SerializableFunction<DataT, ?>> extractInputFns, ImmutableList<Combine.CombineFn<?, ?, ?>> combineFns, ImmutableList<TupleTag<?>> outputTags) {
            ImmutableList<SerializableFunction<DataT, ?>> castedExtractInputFns = extractInputFns;
            this.extractInputFns = castedExtractInputFns;
            ImmutableList<Combine.CombineFn<?, ?, ?>> castedCombineFns = combineFns;
            this.combineFns = castedCombineFns;
            this.outputTags = outputTags;
            this.combineFnCount = this.combineFns.size();
        }

        public <InputT, OutputT> ComposedCombineFn<DataT> with(SimpleFunction<DataT, InputT> extractInputFn, Combine.CombineFn<InputT, ?, OutputT> combineFn, TupleTag<OutputT> outputTag) {
            CombineFns.checkUniqueness(this.outputTags, outputTag);
            return new ComposedCombineFn<DataT>(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.extractInputFns)).add(extractInputFn)).build(), (ImmutableList<Combine.CombineFn<?, ?, ?>>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.combineFns)).add(combineFn)).build(), (ImmutableList<TupleTag<?>>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.outputTags)).add(outputTag)).build());
        }

        public <InputT, OutputT> ComposedCombineFnWithContext<DataT> with(SimpleFunction<DataT, InputT> extractInputFn, CombineWithContext.CombineFnWithContext<InputT, ?, OutputT> combineFn, TupleTag<OutputT> outputTag) {
            CombineFns.checkUniqueness(this.outputTags, outputTag);
            ArrayList<CombineWithContext.CombineFnWithContext> fnsWithContext = Lists.newArrayList();
            for (Combine.CombineFn<Object, Object, Object> fn : this.combineFns) {
                fnsWithContext.add(CombineFns.toFnWithContext(fn));
            }
            return new ComposedCombineFnWithContext((ImmutableList)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.extractInputFns)).add(extractInputFn)).build(), (ImmutableList)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(fnsWithContext)).add(combineFn)).build(), (ImmutableList)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.outputTags)).add(outputTag)).build());
        }

        @Override
        public Object[] createAccumulator() {
            Object[] accumsArray = new Object[this.combineFnCount];
            for (int i = 0; i < this.combineFnCount; ++i) {
                accumsArray[i] = this.combineFns.get(i).createAccumulator();
            }
            return accumsArray;
        }

        @Override
        public Object[] addInput(Object[] accumulator, DataT value) {
            for (int i = 0; i < this.combineFnCount; ++i) {
                Object input = this.extractInputFns.get(i).apply(value);
                accumulator[i] = this.combineFns.get(i).addInput(accumulator[i], input);
            }
            return accumulator;
        }

        @Override
        public Object[] mergeAccumulators(Iterable<Object[]> accumulators) {
            Iterator<Object[]> iter = accumulators.iterator();
            if (!iter.hasNext()) {
                return this.createAccumulator();
            }
            Object[] accum = iter.next();
            for (int i = 0; i < this.combineFnCount; ++i) {
                accum[i] = this.combineFns.get(i).mergeAccumulators(new ProjectionIterable(accumulators, i));
            }
            return accum;
        }

        @Override
        public CoCombineResult extractOutput(Object[] accumulator) {
            HashMap<TupleTag<?>, Object> valuesMap = Maps.newHashMap();
            for (int i = 0; i < this.combineFnCount; ++i) {
                valuesMap.put(this.outputTags.get(i), this.combineFns.get(i).extractOutput(accumulator[i]));
            }
            return new CoCombineResult(valuesMap);
        }

        @Override
        public Object[] compact(Object[] accumulator) {
            for (int i = 0; i < this.combineFnCount; ++i) {
                accumulator[i] = this.combineFns.get(i).compact(accumulator[i]);
            }
            return accumulator;
        }

        @Override
        public Coder<Object[]> getAccumulatorCoder(CoderRegistry registry, Coder<DataT> dataCoder) throws CannotProvideCoderException {
            ArrayList<Coder<Object>> coders = Lists.newArrayList();
            for (int i = 0; i < this.combineFnCount; ++i) {
                Coder<Object> inputCoder = registry.getDefaultOutputCoder(this.extractInputFns.get(i), dataCoder);
                coders.add(this.combineFns.get(i).getAccumulatorCoder(registry, (Coder)inputCoder));
            }
            return new ComposedAccumulatorCoder(coders);
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            CombineFns.populateDisplayData(builder, this.combineFns);
        }
    }

    public static class CoCombineResult
    implements Serializable {
        private final Map<TupleTag<?>, Object> valuesMap;

        CoCombineResult(Map<TupleTag<?>, Object> valuesMap) {
            ImmutableMap.Builder<TupleTag<?>, Object> builder = ImmutableMap.builder();
            for (Map.Entry<TupleTag<?>, Object> entry : valuesMap.entrySet()) {
                if (entry.getValue() != null) {
                    builder.put(entry);
                    continue;
                }
                builder.put(entry.getKey(), (Object)NullValue.INSTANCE);
            }
            this.valuesMap = builder.build();
        }

        public <V> V get(TupleTag<V> tag) {
            Preconditions.checkArgument(this.valuesMap.keySet().contains(tag), "TupleTag " + tag + " is not in the CoCombineResult");
            Object value = this.valuesMap.get(tag);
            if (value == NullValue.INSTANCE) {
                return null;
            }
            return (V)value;
        }

        private static enum NullValue {
            INSTANCE;

        }
    }

    public static class ComposeCombineFnBuilder {
        public <DataT, InputT, OutputT> ComposedCombineFn<DataT> with(SimpleFunction<DataT, InputT> extractInputFn, Combine.CombineFn<InputT, ?, OutputT> combineFn, TupleTag<OutputT> outputTag) {
            return new ComposedCombineFn<DataT>().with(extractInputFn, combineFn, outputTag);
        }

        public <DataT, InputT, OutputT> ComposedCombineFnWithContext<DataT> with(SimpleFunction<DataT, InputT> extractInputFn, CombineWithContext.CombineFnWithContext<InputT, ?, OutputT> combineFnWithContext, TupleTag<OutputT> outputTag) {
            return new ComposedCombineFnWithContext<DataT>().with(extractInputFn, combineFnWithContext, outputTag);
        }
    }

    public static class ComposeKeyedCombineFnBuilder {
        public <K, DataT, InputT, OutputT> ComposedKeyedCombineFn<DataT, K> with(SimpleFunction<DataT, InputT> extractInputFn, Combine.KeyedCombineFn<K, InputT, ?, OutputT> keyedCombineFn, TupleTag<OutputT> outputTag) {
            return new ComposedKeyedCombineFn<DataT, K>().with(extractInputFn, keyedCombineFn, outputTag);
        }

        public <K, DataT, InputT, OutputT> ComposedKeyedCombineFnWithContext<DataT, K> with(SimpleFunction<DataT, InputT> extractInputFn, CombineWithContext.KeyedCombineFnWithContext<K, InputT, ?, OutputT> keyedCombineFnWithContext, TupleTag<OutputT> outputTag) {
            return new ComposedKeyedCombineFnWithContext<DataT, K>().with(extractInputFn, keyedCombineFnWithContext, outputTag);
        }

        public <K, DataT, InputT, OutputT> ComposedKeyedCombineFn<DataT, K> with(SimpleFunction<DataT, InputT> extractInputFn, Combine.CombineFn<InputT, ?, OutputT> combineFn, TupleTag<OutputT> outputTag) {
            return this.with(extractInputFn, (Combine.KeyedCombineFn<K, InputT, ?, OutputT>)combineFn.asKeyedFn(), outputTag);
        }

        public <K, DataT, InputT, OutputT> ComposedKeyedCombineFnWithContext<DataT, K> with(SimpleFunction<DataT, InputT> extractInputFn, CombineWithContext.CombineFnWithContext<InputT, ?, OutputT> combineFnWithContext, TupleTag<OutputT> outputTag) {
            return this.with(extractInputFn, (CombineWithContext.KeyedCombineFnWithContext<K, InputT, ?, OutputT>)combineFnWithContext.asKeyedFn(), outputTag);
        }
    }
}

