/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.coders.CannotProvideCoderException;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Function;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Optional;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.runners.DirectPipelineRunner;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.values.KV;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.cloud.dataflow.sdk.values.TimestampedValue;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;
import com.google.cloud.dataflow.sdk.values.TypedPValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.joda.time.Instant;

public class Create<T> {
    public static <T> Values<T> of(Iterable<T> elems) {
        return new Values(elems, Optional.absent());
    }

    @SafeVarargs
    public static <T> Values<T> of(T ... elems) {
        return Create.of(Arrays.asList(elems));
    }

    public static <K, V> Values<KV<K, V>> of(Map<K, V> elems) {
        ArrayList<KV<K, V>> kvs = new ArrayList<KV<K, V>>(elems.size());
        for (Map.Entry<K, V> entry : elems.entrySet()) {
            kvs.add(KV.of(entry.getKey(), entry.getValue()));
        }
        return Create.of(kvs);
    }

    public static <T> TimestampedValues<T> timestamped(Iterable<TimestampedValue<T>> elems) {
        return new TimestampedValues(elems, Optional.absent());
    }

    @SafeVarargs
    public static <T> TimestampedValues<T> timestamped(TimestampedValue<T> ... elems) {
        return Create.timestamped(Arrays.asList(elems));
    }

    public static <T> TimestampedValues<T> timestamped(Iterable<T> values, Iterable<Long> timestamps) {
        ArrayList<TimestampedValue<T>> elems = new ArrayList<TimestampedValue<T>>();
        Iterator<T> valueIter = values.iterator();
        Iterator<Long> timestampIter = timestamps.iterator();
        while (valueIter.hasNext() && timestampIter.hasNext()) {
            elems.add(TimestampedValue.of(valueIter.next(), new Instant((Object)timestampIter.next())));
        }
        Preconditions.checkArgument(!valueIter.hasNext() && !timestampIter.hasNext(), "Expect sizes of values and timestamps are same.");
        return Create.timestamped(elems);
    }

    private static void registerDefaultTransformEvaluator() {
        DirectPipelineRunner.registerDefaultTransformEvaluator(Values.class, new DirectPipelineRunner.TransformEvaluator<Values>(){

            @Override
            public void evaluate(Values transform, DirectPipelineRunner.EvaluationContext context) {
                Create.evaluateHelper(transform, context);
            }
        });
    }

    private static <T> void evaluateHelper(Values<T> transform, DirectPipelineRunner.EvaluationContext context) {
        ArrayList listElems;
        if (((Values)transform).elems instanceof Collection) {
            Collection collectionElems = (Collection)((Values)transform).elems;
            listElems = new ArrayList(collectionElems.size());
        } else {
            listElems = new ArrayList();
        }
        for (Object elem : ((Values)transform).elems) {
            listElems.add(context.ensureElementEncodable((TypedPValue)context.getOutput(transform), elem));
        }
        context.setPCollection((PCollection)context.getOutput(transform), listElems);
    }

    static {
        Create.registerDefaultTransformEvaluator();
    }

    public static class TimestampedValues<T>
    extends Values<T> {
        private final transient Iterable<TimestampedValue<T>> elems;

        @Override
        public TimestampedValues<T> withCoder(Coder<T> coder) {
            return new TimestampedValues<T>(this.elems, Optional.of(coder));
        }

        @Override
        public PCollection<T> apply(PInput input) {
            try {
                Coder coder = this.getDefaultOutputCoder(input);
                PCollection intermediate = (PCollection)Pipeline.applyTransform(input, Create.of(this.elems).withCoder(TimestampedValue.TimestampedValueCoder.of(coder)));
                PCollection output = (PCollection)intermediate.apply(ParDo.of(new ConvertTimestamps()));
                output.setCoder(coder);
                return output;
            }
            catch (CannotProvideCoderException e) {
                throw new IllegalArgumentException("Unable to infer a coder and no Coder was specified. Please set a coder by invoking CreateTimestamped.withCoder() explicitly.", e);
            }
        }

        private TimestampedValues(Iterable<TimestampedValue<T>> elems, Optional<Coder<T>> coder) {
            super(Iterables.transform(elems, new Function<TimestampedValue<T>, T>(){

                @Override
                public T apply(TimestampedValue<T> input) {
                    return input.getValue();
                }
            }), coder);
            this.elems = elems;
        }

        private static class ConvertTimestamps<T>
        extends DoFn<TimestampedValue<T>, T> {
            private ConvertTimestamps() {
            }

            @Override
            public void processElement(DoFn.ProcessContext c) {
                c.outputWithTimestamp(((TimestampedValue)c.element()).getValue(), ((TimestampedValue)c.element()).getTimestamp());
            }
        }
    }

    public static class Values<T>
    extends PTransform<PInput, PCollection<T>> {
        private final transient Iterable<T> elems;
        private final transient Optional<Coder<T>> coder;

        public Values<T> withCoder(Coder<T> coder) {
            return new Values<T>(this.elems, Optional.of(coder));
        }

        public Iterable<T> getElements() {
            return this.elems;
        }

        @Override
        public PCollection<T> apply(PInput input) {
            try {
                Coder<T> coder = this.getDefaultOutputCoder(input);
                return PCollection.createPrimitiveOutputInternal(input.getPipeline(), WindowingStrategy.globalDefault(), PCollection.IsBounded.BOUNDED).setCoder((Coder)coder);
            }
            catch (CannotProvideCoderException e) {
                throw new IllegalArgumentException("Unable to infer a coder and no Coder was specified. Please set a coder by invoking Create.withCoder() explicitly.", e);
            }
        }

        @Override
        public Coder<T> getDefaultOutputCoder(PInput input) throws CannotProvideCoderException {
            Serializable coder;
            if (this.coder.isPresent()) {
                return this.coder.get();
            }
            Class elementClazz = Void.class;
            for (T elem : this.elems) {
                if (elem == null) continue;
                Class<?> clazz = elem.getClass();
                if (elementClazz.equals(Void.class)) {
                    elementClazz = clazz;
                    continue;
                }
                if (elementClazz.equals(clazz)) continue;
                throw new CannotProvideCoderException("Cannot provide coder for Create: The elements are not all of the same class.");
            }
            if (elementClazz.getTypeParameters().length == 0) {
                try {
                    coder = input.getPipeline().getCoderRegistry().getDefaultCoder(TypeDescriptor.of(elementClazz));
                    return coder;
                }
                catch (CannotProvideCoderException coder2) {
                    // empty catch block
                }
            }
            coder = Optional.absent();
            for (T elem : this.elems) {
                Coder<T> c = input.getPipeline().getCoderRegistry().getDefaultCoder(elem);
                if (!((Optional)coder).isPresent()) {
                    coder = Optional.of(c);
                    continue;
                }
                if (Objects.equals(c, ((Optional)coder).get())) continue;
                throw new CannotProvideCoderException("Cannot provide coder for elements of " + Create.class.getSimpleName() + ":" + " For their common class, no coder could be provided." + " Based on their values, they do not all default to the same Coder.");
            }
            if (!((Optional)coder).isPresent()) {
                throw new CannotProvideCoderException("Unable to infer a coder. Please register a coder for ");
            }
            return (Coder)((Optional)coder).get();
        }

        private Values(Iterable<T> elems, Optional<Coder<T>> coder) {
            this.elems = elems;
            this.coder = coder;
        }
    }
}

