/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptionsFactory;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Function;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Objects;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Lists;
import com.google.cloud.dataflow.sdk.transforms.Aggregator;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.DoFnReflector;
import com.google.cloud.dataflow.sdk.transforms.DoFnWithContext;
import com.google.cloud.dataflow.sdk.util.DirectModeExecutionContext;
import com.google.cloud.dataflow.sdk.util.DirectSideInputReader;
import com.google.cloud.dataflow.sdk.util.DoFnRunner;
import com.google.cloud.dataflow.sdk.util.DoFnRunnerBase;
import com.google.cloud.dataflow.sdk.util.DoFnRunners;
import com.google.cloud.dataflow.sdk.util.PTuple;
import com.google.cloud.dataflow.sdk.util.SerializableUtils;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.util.common.Counter;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import com.google.cloud.dataflow.sdk.values.TupleTag;
import com.google.cloud.dataflow.sdk.values.TupleTagList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.Instant;

public class DoFnTester<InputT, OutputT> {
    static final String STEP_NAME = "stepName";
    static final String TRANSFORM_NAME = "transformName";
    final PipelineOptions options = PipelineOptionsFactory.create();
    final DoFn<InputT, OutputT> origFn;
    private Map<PCollectionView<?>, Iterable<WindowedValue<?>>> sideInputs = new HashMap();
    private CloningBehavior cloningBehavior = CloningBehavior.CLONE;
    TupleTag<OutputT> mainOutputTag = new TupleTag();
    List<TupleTag<?>> sideOutputTags = new ArrayList();
    DoFn<InputT, OutputT> fn;
    DoFnRunnerBase.ListOutputManager outputManager;
    DoFnRunner<InputT, OutputT> fnRunner;
    CounterSet counterSet;
    State state;

    public static <InputT, OutputT> DoFnTester<InputT, OutputT> of(DoFn<InputT, OutputT> fn) {
        return new DoFnTester<InputT, OutputT>(fn);
    }

    public static <InputT, OutputT> DoFnTester<InputT, OutputT> of(DoFnWithContext<InputT, OutputT> fn) {
        return new DoFnTester<InputT, OutputT>(DoFnReflector.of(fn.getClass()).toDoFn(fn));
    }

    public void setSideInputs(Map<PCollectionView<?>, Iterable<WindowedValue<?>>> sideInputs) {
        this.sideInputs = sideInputs;
        this.resetState();
    }

    public void setSideInput(PCollectionView<?> sideInput, Iterable<WindowedValue<?>> value) {
        this.sideInputs.put(sideInput, value);
    }

    public void setSideInputInGlobalWindow(PCollectionView<?> sideInput, Iterable<?> value) {
        this.sideInputs.put(sideInput, Iterables.transform(value, new Function<Object, WindowedValue<?>>(){

            @Override
            public WindowedValue<?> apply(Object input) {
                return WindowedValue.valueInGlobalWindow(input);
            }
        }));
    }

    public void setSideOutputTags(TupleTagList sideOutputTags) {
        this.sideOutputTags = sideOutputTags.getAll();
        this.resetState();
    }

    public void setCloningBehavior(CloningBehavior newValue) {
        this.cloningBehavior = newValue;
    }

    public CloningBehavior getCloningBehavior() {
        return this.cloningBehavior;
    }

    public List<OutputT> processBatch(Iterable<? extends InputT> inputElements) {
        this.startBundle();
        for (InputT inputElement : inputElements) {
            this.processElement(inputElement);
        }
        this.finishBundle();
        return this.takeOutputElements();
    }

    @SafeVarargs
    public final List<OutputT> processBatch(InputT ... inputElements) {
        return this.processBatch((Iterable<? extends InputT>)Arrays.asList(inputElements));
    }

    public void startBundle() {
        this.resetState();
        this.initializeState();
        this.fnRunner.startBundle();
        this.state = State.STARTED;
    }

    public void processElement(InputT element) {
        if (this.state == State.FINISHED) {
            throw new IllegalStateException("finishBundle() has already been called");
        }
        if (this.state == State.UNSTARTED) {
            this.startBundle();
        }
        this.fnRunner.processElement(WindowedValue.valueInGlobalWindow(element));
    }

    public void finishBundle() {
        if (this.state == State.FINISHED) {
            throw new IllegalStateException("finishBundle() has already been called");
        }
        if (this.state == State.UNSTARTED) {
            this.startBundle();
        }
        this.fnRunner.finishBundle();
        this.state = State.FINISHED;
    }

    public List<OutputT> peekOutputElements() {
        return Lists.transform(this.peekOutputElementsWithTimestamp(), new Function<OutputElementWithTimestamp<OutputT>, OutputT>(){

            @Override
            public OutputT apply(OutputElementWithTimestamp<OutputT> input) {
                return input.getValue();
            }
        });
    }

    @Experimental
    public List<OutputElementWithTimestamp<OutputT>> peekOutputElementsWithTimestamp() {
        return Lists.transform(this.outputManager.getOutput(this.mainOutputTag), new Function<Object, OutputElementWithTimestamp<OutputT>>(){

            @Override
            public OutputElementWithTimestamp<OutputT> apply(Object input) {
                return new OutputElementWithTimestamp(((WindowedValue)input).getValue(), ((WindowedValue)input).getTimestamp());
            }
        });
    }

    public void clearOutputElements() {
        this.peekOutputElements().clear();
    }

    public List<OutputT> takeOutputElements() {
        ArrayList<OutputT> resultElems = new ArrayList<OutputT>(this.peekOutputElements());
        this.clearOutputElements();
        return resultElems;
    }

    @Experimental
    public List<OutputElementWithTimestamp<OutputT>> takeOutputElementsWithTimestamp() {
        ArrayList<OutputElementWithTimestamp<OutputT>> resultElems = new ArrayList<OutputElementWithTimestamp<OutputT>>(this.peekOutputElementsWithTimestamp());
        this.clearOutputElements();
        return resultElems;
    }

    public <T> List<T> peekSideOutputElements(TupleTag<T> tag) {
        return Lists.transform(this.outputManager.getOutput(tag), new Function<WindowedValue<T>, T>(){

            @Override
            public T apply(WindowedValue<T> input) {
                return input.getValue();
            }
        });
    }

    public <T> void clearSideOutputElements(TupleTag<T> tag) {
        this.peekSideOutputElements(tag).clear();
    }

    public <T> List<T> takeSideOutputElements(TupleTag<T> tag) {
        ArrayList<T> resultElems = new ArrayList<T>(this.peekSideOutputElements(tag));
        this.clearSideOutputElements(tag);
        return resultElems;
    }

    public <AggregateT> AggregateT getAggregatorValue(Aggregator<?, AggregateT> agg) {
        Counter<?> counter = this.counterSet.getExistingCounter("user-stepName-" + agg.getName());
        return (AggregateT)counter.getAggregate();
    }

    DoFnTester(DoFn<InputT, OutputT> origFn) {
        this.origFn = origFn;
        this.resetState();
    }

    void resetState() {
        this.fn = null;
        this.outputManager = null;
        this.fnRunner = null;
        this.counterSet = null;
        this.state = State.UNSTARTED;
    }

    void initializeState() {
        this.fn = this.cloningBehavior.equals((Object)CloningBehavior.DO_NOT_CLONE) ? this.origFn : (DoFn)SerializableUtils.deserializeFromByteArray(SerializableUtils.serializeToByteArray(this.origFn), this.origFn.toString());
        this.counterSet = new CounterSet(new Counter[0]);
        PTuple runnerSideInputs = PTuple.empty();
        for (Map.Entry<PCollectionView<?>, Iterable<WindowedValue<?>>> entry : this.sideInputs.entrySet()) {
            runnerSideInputs = runnerSideInputs.and(entry.getKey().getTagInternal(), entry.getValue());
        }
        this.outputManager = new DoFnRunnerBase.ListOutputManager();
        this.fnRunner = DoFnRunners.createDefault(this.options, this.fn, DirectSideInputReader.of(runnerSideInputs), this.outputManager, this.mainOutputTag, this.sideOutputTags, DirectModeExecutionContext.create().getOrCreateStepContext(STEP_NAME, TRANSFORM_NAME, null), this.counterSet.getAddCounterMutator(), WindowingStrategy.globalDefault());
    }

    static enum State {
        UNSTARTED,
        STARTED,
        FINISHED;

    }

    @Experimental
    public static class OutputElementWithTimestamp<OutputT> {
        private final OutputT value;
        private final Instant timestamp;

        OutputElementWithTimestamp(OutputT value, Instant timestamp) {
            this.value = value;
            this.timestamp = timestamp;
        }

        OutputT getValue() {
            return this.value;
        }

        Instant getTimestamp() {
            return this.timestamp;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OutputElementWithTimestamp)) {
                return false;
            }
            OutputElementWithTimestamp other = (OutputElementWithTimestamp)obj;
            return Objects.equal(other.value, this.value) && Objects.equal(other.timestamp, this.timestamp);
        }

        public int hashCode() {
            return Objects.hashCode(this.value, this.timestamp);
        }
    }

    public static enum CloningBehavior {
        CLONE,
        DO_NOT_CLONE;

    }
}

