/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.transforms.Aggregator;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.SerializableFunction;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.transforms.display.HasDisplayData;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.PaneInfo;
import com.google.cloud.dataflow.sdk.util.WindowingInternals;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import com.google.cloud.dataflow.sdk.values.TupleTag;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;
import java.io.Serializable;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.Duration;
import org.joda.time.Instant;

@Experimental
public abstract class DoFnWithContext<InputT, OutputT>
implements Serializable,
HasDisplayData {
    Map<String, DoFn.DelegatingAggregator<?, ?>> aggregators = new HashMap();
    private boolean aggregatorsAreFinal;

    public Duration getAllowedTimestampSkew() {
        return Duration.ZERO;
    }

    protected TypeDescriptor<InputT> getInputTypeDescriptor() {
        return new TypeDescriptor<InputT>(this.getClass()){};
    }

    protected TypeDescriptor<OutputT> getOutputTypeDescriptor() {
        return new TypeDescriptor<OutputT>(this.getClass()){};
    }

    public final <AggInputT, AggOutputT> Aggregator<AggInputT, AggOutputT> createAggregator(String name, Combine.CombineFn<? super AggInputT, ?, AggOutputT> combiner) {
        Preconditions.checkNotNull(name, "name cannot be null");
        Preconditions.checkNotNull(combiner, "combiner cannot be null");
        Preconditions.checkArgument(!this.aggregators.containsKey(name), "Cannot create aggregator with name %s. An Aggregator with that name already exists within this scope.", name);
        Preconditions.checkState(!this.aggregatorsAreFinal, "Cannot create an aggregator during pipeline execution. Aggregators should be registered during pipeline construction.");
        DoFn.DelegatingAggregator<? super AggInputT, AggOutputT> aggregator = new DoFn.DelegatingAggregator<AggInputT, AggOutputT>(name, combiner);
        this.aggregators.put(name, aggregator);
        return aggregator;
    }

    public final <AggInputT> Aggregator<AggInputT, AggInputT> createAggregator(String name, SerializableFunction<Iterable<AggInputT>, AggInputT> combiner) {
        Preconditions.checkNotNull(combiner, "combiner cannot be null.");
        return this.createAggregator(name, Combine.IterableCombineFn.of(combiner));
    }

    void prepareForProcessing() {
        this.aggregatorsAreFinal = true;
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface FinishBundle {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ProcessElement {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface StartBundle {
    }

    public static interface ExtraContextFactory<InputT, OutputT> {
        public BoundedWindow window();

        public WindowingInternals<InputT, OutputT> windowingInternals();
    }

    public abstract class ProcessContext
    extends Context {
        public abstract InputT element();

        public abstract <T> T sideInput(PCollectionView<T> var1);

        public abstract Instant timestamp();

        public abstract PaneInfo pane();
    }

    public abstract class Context {
        public abstract PipelineOptions getPipelineOptions();

        public abstract void output(OutputT var1);

        public abstract void outputWithTimestamp(OutputT var1, Instant var2);

        public abstract <T> void sideOutput(TupleTag<T> var1, T var2);

        public abstract <T> void sideOutputWithTimestamp(TupleTag<T> var1, T var2, Instant var3);
    }
}

