/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.transforms.Top;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.util.common.Counter;
import com.google.cloud.dataflow.sdk.util.common.CounterProvider;
import java.io.Serializable;
import java.util.Comparator;

public class Max {
    private Max() {
    }

    public static Combine.Globally<Integer, Integer> integersGlobally() {
        return Combine.globally(new MaxIntegerFn()).named("Max.Globally");
    }

    public static <K> Combine.PerKey<K, Integer, Integer> integersPerKey() {
        return Combine.perKey(new MaxIntegerFn()).named("Max.PerKey");
    }

    public static Combine.Globally<Long, Long> longsGlobally() {
        return Combine.globally(new MaxLongFn()).named("Max.Globally");
    }

    public static <K> Combine.PerKey<K, Long, Long> longsPerKey() {
        return Combine.perKey(new MaxLongFn()).named("Max.PerKey");
    }

    public static Combine.Globally<Double, Double> doublesGlobally() {
        return Combine.globally(new MaxDoubleFn()).named("Max.Globally");
    }

    public static <K> Combine.PerKey<K, Double, Double> doublesPerKey() {
        return Combine.perKey(new MaxDoubleFn()).named("Max.PerKey");
    }

    public static <T extends Comparable<? super T>> Combine.Globally<T, T> globally() {
        return Combine.globally(MaxFn.naturalOrder()).named("Max.Globally");
    }

    public static <K, T extends Comparable<? super T>> Combine.PerKey<K, T, T> perKey() {
        return Combine.perKey(MaxFn.naturalOrder()).named("Max.PerKey");
    }

    public static <T, ComparatorT extends Comparator<? super T> & Serializable> Combine.Globally<T, T> globally(ComparatorT comparator) {
        return Combine.globally(MaxFn.of(comparator)).named("Max.Globally");
    }

    public static <K, T, ComparatorT extends Comparator<? super T> & Serializable> Combine.PerKey<K, T, T> perKey(ComparatorT comparator) {
        return Combine.perKey(MaxFn.of(comparator)).named("Max.PerKey");
    }

    public static class MaxDoubleFn
    extends MaxFn<Double>
    implements CounterProvider<Double> {
        public MaxDoubleFn() {
            super(Double.NEGATIVE_INFINITY, new Top.Largest(), null);
        }

        @Override
        public Counter<Double> getCounter(String name) {
            return Counter.doubles(name, Counter.AggregationKind.MAX);
        }
    }

    public static class MaxLongFn
    extends MaxFn<Long>
    implements CounterProvider<Long> {
        public MaxLongFn() {
            super(Long.MIN_VALUE, new Top.Largest(), null);
        }

        @Override
        public Counter<Long> getCounter(String name) {
            return Counter.longs(name, Counter.AggregationKind.MAX);
        }
    }

    public static class MaxIntegerFn
    extends MaxFn<Integer>
    implements CounterProvider<Integer> {
        public MaxIntegerFn() {
            super(Integer.MIN_VALUE, new Top.Largest(), null);
        }

        @Override
        public Counter<Integer> getCounter(String name) {
            return Counter.ints(name, Counter.AggregationKind.MAX);
        }
    }

    public static class MaxFn<T>
    extends Combine.BinaryCombineFn<T> {
        private final T identity;
        private final Comparator<? super T> comparator;

        private <ComparatorT extends Comparator<? super T> & Serializable> MaxFn(T identity, ComparatorT comparator) {
            this.identity = identity;
            this.comparator = comparator;
        }

        public static <T, ComparatorT extends Comparator<? super T> & Serializable> MaxFn<T> of(T identity, ComparatorT comparator) {
            return new MaxFn<T>(identity, comparator);
        }

        public static <T, ComparatorT extends Comparator<? super T> & Serializable> MaxFn<T> of(ComparatorT comparator) {
            return new MaxFn<Object>(null, comparator);
        }

        public static <T extends Comparable<? super T>> MaxFn<T> naturalOrder(T identity) {
            return new MaxFn<T>(identity, new Top.Largest());
        }

        public static <T extends Comparable<? super T>> MaxFn<T> naturalOrder() {
            return new MaxFn<Object>(null, new Top.Largest());
        }

        @Override
        public T identity() {
            return this.identity;
        }

        @Override
        public T apply(T left, T right) {
            return this.comparator.compare(left, right) >= 0 ? left : right;
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("comparer", this.comparator.getClass()).withLabel("Record Comparer"));
        }

        /* synthetic */ MaxFn(Object x0, Comparator x1, 1 x2) {
            this(x0, x1);
        }
    }
}

