/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms;

import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.BigEndianLongCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.CoderRegistry;
import com.google.cloud.dataflow.sdk.coders.DoubleCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public class Mean {
    private Mean() {
    }

    public static <NumT extends Number> Combine.Globally<NumT, Double> globally() {
        return Combine.globally(new MeanFn()).named("Mean.Globally");
    }

    public static <K, NumT extends Number> Combine.PerKey<K, NumT, Double> perKey() {
        return Combine.perKey(new MeanFn()).named("Mean.PerKey");
    }

    static class CountSumCoder<NumT extends Number>
    extends AtomicCoder<CountSum<NumT>> {
        private static final Coder<Long> LONG_CODER = BigEndianLongCoder.of();
        private static final Coder<Double> DOUBLE_CODER = DoubleCoder.of();

        CountSumCoder() {
        }

        @Override
        public void encode(CountSum<NumT> value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
            Coder.Context nestedContext = context.nested();
            LONG_CODER.encode(value.count, outStream, nestedContext);
            DOUBLE_CODER.encode(value.sum, outStream, nestedContext);
        }

        @Override
        public CountSum<NumT> decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
            Coder.Context nestedContext = context.nested();
            return new CountSum(LONG_CODER.decode(inStream, nestedContext), DOUBLE_CODER.decode(inStream, nestedContext));
        }
    }

    static class CountSum<NumT extends Number>
    implements Combine.AccumulatingCombineFn.Accumulator<NumT, CountSum<NumT>, Double> {
        long count = 0L;
        double sum = 0.0;

        public CountSum() {
            this(0L, 0.0);
        }

        public CountSum(long count, double sum) {
            this.count = count;
            this.sum = sum;
        }

        @Override
        public void addInput(NumT element) {
            ++this.count;
            this.sum += ((Number)element).doubleValue();
        }

        @Override
        public void mergeAccumulator(CountSum<NumT> accumulator) {
            this.count += accumulator.count;
            this.sum += accumulator.sum;
        }

        @Override
        public Double extractOutput() {
            return this.count == 0L ? Double.NaN : this.sum / (double)this.count;
        }

        public boolean equals(Object other) {
            if (!(other instanceof CountSum)) {
                return false;
            }
            CountSum otherCountSum = (CountSum)other;
            return this.count == otherCountSum.count && this.sum == otherCountSum.sum;
        }

        public int hashCode() {
            return Objects.hash(this.count, this.sum);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("count", this.count).add("sum", this.sum).toString();
        }
    }

    static class MeanFn<NumT extends Number>
    extends Combine.AccumulatingCombineFn<NumT, CountSum<NumT>, Double> {
        @Override
        public CountSum<NumT> createAccumulator() {
            return new CountSum();
        }

        @Override
        public Coder<CountSum<NumT>> getAccumulatorCoder(CoderRegistry registry, Coder<NumT> inputCoder) {
            return new CountSumCoder();
        }
    }
}

