/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.join;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.IterableCoder;
import com.google.cloud.dataflow.sdk.coders.StandardCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterators;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.PeekingIterator;
import com.google.cloud.dataflow.sdk.transforms.join.CoGbkResultSchema;
import com.google.cloud.dataflow.sdk.transforms.join.RawUnionValue;
import com.google.cloud.dataflow.sdk.transforms.join.UnionCoder;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.util.common.Reiterator;
import com.google.cloud.dataflow.sdk.values.TupleTag;
import com.google.cloud.dataflow.sdk.values.TupleTagList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoGbkResult {
    private final List<Iterable<?>> valueMap;
    private final CoGbkResultSchema schema;
    private static final int DEFAULT_IN_MEMORY_ELEMENT_COUNT = 10000;
    private static final Logger LOG = LoggerFactory.getLogger(CoGbkResult.class);
    private int nextTestUnionId = 0;

    public CoGbkResult(CoGbkResultSchema schema, Iterable<RawUnionValue> taggedValues) {
        this(schema, taggedValues, 10000);
    }

    public CoGbkResult(CoGbkResultSchema schema, Iterable<RawUnionValue> taggedValues, int inMemoryElementCount) {
        this.schema = schema;
        this.valueMap = new ArrayList();
        for (int unionTag = 0; unionTag < schema.size(); ++unionTag) {
            this.valueMap.add(new ArrayList());
        }
        Iterator<RawUnionValue> taggedIter = taggedValues.iterator();
        int elementCount = 0;
        while (taggedIter.hasNext() && (elementCount++ < inMemoryElementCount || !(taggedIter instanceof Reiterator))) {
            RawUnionValue value = taggedIter.next();
            int unionTag = value.getUnionTag();
            if (schema.size() <= unionTag) {
                throw new IllegalStateException("union tag " + unionTag + " has no corresponding tuple tag in the result schema");
            }
            List valueList = (List)this.valueMap.get(unionTag);
            valueList.add(value.getValue());
        }
        if (taggedIter.hasNext()) {
            LOG.info("CoGbkResult has more than " + inMemoryElementCount + " elements," + " reiteration (which may be slow) is required.");
            Reiterator tail = (Reiterator)taggedIter;
            Boolean[] containsTag = new Boolean[schema.size()];
            for (int unionTag = 0; unionTag < schema.size(); ++unionTag) {
                int unionTag0 = unionTag;
                this.updateUnionTag(tail, containsTag, unionTag, unionTag0);
            }
        }
    }

    private <T> void updateUnionTag(final Reiterator<RawUnionValue> tail, final Boolean[] containsTag, int unionTag, final int unionTag0) {
        final Iterable<?> head = this.valueMap.get(unionTag);
        this.valueMap.set(unionTag, new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.concat(head.iterator(), new UnionValueIterator(unionTag0, tail.copy(), containsTag));
            }
        });
    }

    public boolean isEmpty() {
        for (Iterable<?> tagValues : this.valueMap) {
            if (!tagValues.iterator().hasNext()) continue;
            return false;
        }
        return true;
    }

    public CoGbkResultSchema getSchema() {
        return this.schema;
    }

    public String toString() {
        return this.valueMap.toString();
    }

    public <V> Iterable<V> getAll(TupleTag<V> tag) {
        int index = this.schema.getIndex(tag);
        if (index < 0) {
            throw new IllegalArgumentException("TupleTag " + tag + " is not in the schema");
        }
        Iterable<?> unions = this.valueMap.get(index);
        return unions;
    }

    public <V> V getOnly(TupleTag<V> tag) {
        return this.innerGetOnly(tag, null, false);
    }

    public <V> V getOnly(TupleTag<V> tag, V defaultValue) {
        return this.innerGetOnly(tag, defaultValue, true);
    }

    public static <V> CoGbkResult of(TupleTag<V> tag, List<V> data) {
        return CoGbkResult.empty().and(tag, data);
    }

    public <V> CoGbkResult and(TupleTag<V> tag, List<V> data) {
        if (this.nextTestUnionId != this.schema.size()) {
            throw new IllegalArgumentException("Attempting to call and() on a CoGbkResult apparently not created by of().");
        }
        ArrayList valueMap = new ArrayList(this.valueMap);
        valueMap.add(data);
        return new CoGbkResult(new CoGbkResultSchema(this.schema.getTupleTagList().and(tag)), (List<Iterable<?>>)valueMap, this.nextTestUnionId + 1);
    }

    public static <V> CoGbkResult empty() {
        return new CoGbkResult(new CoGbkResultSchema(TupleTagList.empty()), new ArrayList());
    }

    private CoGbkResult(CoGbkResultSchema schema, List<Iterable<?>> valueMap, int nextTestUnionId) {
        this(schema, valueMap);
        this.nextTestUnionId = nextTestUnionId;
    }

    private CoGbkResult(CoGbkResultSchema schema, List<Iterable<?>> valueMap) {
        this.schema = schema;
        this.valueMap = valueMap;
    }

    private <V> V innerGetOnly(TupleTag<V> tag, V defaultValue, boolean useDefault) {
        int index = this.schema.getIndex(tag);
        if (index < 0) {
            throw new IllegalArgumentException("TupleTag " + tag + " is not in the schema");
        }
        Iterator<?> unions = this.valueMap.get(index).iterator();
        if (!unions.hasNext()) {
            if (useDefault) {
                return defaultValue;
            }
            throw new IllegalArgumentException("TupleTag " + tag + " corresponds to an empty result, and no default was provided");
        }
        Object value = unions.next();
        if (unions.hasNext()) {
            throw new IllegalArgumentException("TupleTag " + tag + " corresponds to a non-singleton result");
        }
        return (V)value;
    }

    private static class UnionValueIterator<V>
    implements Iterator<V> {
        private final int tag;
        private final PeekingIterator<RawUnionValue> unions;
        private final Boolean[] containsTag;

        private UnionValueIterator(int tag, Iterator<RawUnionValue> unions, Boolean[] containsTag) {
            this.tag = tag;
            this.unions = Iterators.peekingIterator(unions);
            this.containsTag = containsTag;
        }

        @Override
        public boolean hasNext() {
            if (this.containsTag[this.tag] == Boolean.FALSE) {
                return false;
            }
            this.advance();
            if (this.unions.hasNext()) {
                return true;
            }
            for (int i = 0; i < this.containsTag.length; ++i) {
                if (this.containsTag[i] != null) continue;
                this.containsTag[i] = false;
            }
            return false;
        }

        @Override
        public V next() {
            this.advance();
            return (V)this.unions.next().getValue();
        }

        private void advance() {
            while (this.unions.hasNext()) {
                int curTag = this.unions.peek().getUnionTag();
                this.containsTag[curTag] = true;
                if (curTag == this.tag) break;
                this.unions.next();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class CoGbkResultCoder
    extends StandardCoder<CoGbkResult> {
        private final CoGbkResultSchema schema;
        private final UnionCoder unionCoder;

        public static CoGbkResultCoder of(CoGbkResultSchema schema, UnionCoder unionCoder) {
            return new CoGbkResultCoder(schema, unionCoder);
        }

        @JsonCreator
        public static CoGbkResultCoder of(@JsonProperty(value="component_encodings") List<Coder<?>> components, @JsonProperty(value="co_gbk_result_schema") CoGbkResultSchema schema) {
            Preconditions.checkArgument(components.size() == 1, "Expecting 1 component, got " + components.size());
            return new CoGbkResultCoder(schema, (UnionCoder)components.get(0));
        }

        private CoGbkResultCoder(CoGbkResultSchema tupleTags, UnionCoder unionCoder) {
            this.schema = tupleTags;
            this.unionCoder = unionCoder;
        }

        @Override
        public List<? extends Coder<?>> getCoderArguments() {
            return null;
        }

        @Override
        public List<? extends Coder<?>> getComponents() {
            return Arrays.asList(this.unionCoder);
        }

        @Override
        public CloudObject asCloudObject() {
            CloudObject result = super.asCloudObject();
            Structs.addObject((Map<String, Object>)((Object)result), "co_gbk_result_schema", (Map<String, Object>)((Object)this.schema.asCloudObject()));
            return result;
        }

        @Override
        public void encode(CoGbkResult value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
            if (!this.schema.equals(value.getSchema())) {
                throw new CoderException("input schema does not match coder schema");
            }
            for (int unionTag = 0; unionTag < this.schema.size(); ++unionTag) {
                this.tagListCoder(unionTag).encode((Iterable)value.valueMap.get(unionTag), outStream, Coder.Context.NESTED);
            }
        }

        @Override
        public CoGbkResult decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
            ArrayList<Object> valueMap = new ArrayList<Object>();
            for (int unionTag = 0; unionTag < this.schema.size(); ++unionTag) {
                valueMap.add(this.tagListCoder(unionTag).decode(inStream, Coder.Context.NESTED));
            }
            return new CoGbkResult(this.schema, valueMap);
        }

        private IterableCoder tagListCoder(int unionTag) {
            return IterableCoder.of(this.unionCoder.getComponents().get(unionTag));
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CoGbkResultCoder)) {
                return false;
            }
            CoGbkResultCoder other = (CoGbkResultCoder)object;
            return this.schema.equals(other.schema) && this.unionCoder.equals(other.unionCoder);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.schema);
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            this.verifyDeterministic("CoGbkResult requires the union coder to be deterministic", this.unionCoder);
        }
    }
}

