/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.join;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.StandardCoder;
import com.google.cloud.dataflow.sdk.transforms.join.RawUnionValue;
import com.google.cloud.dataflow.sdk.util.VarInt;
import com.google.cloud.dataflow.sdk.util.common.ElementByteSizeObserver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

class UnionCoder
extends StandardCoder<RawUnionValue> {
    private final List<Coder<?>> elementCoders;

    public static UnionCoder of(List<Coder<?>> elementCoders) {
        return new UnionCoder(elementCoders);
    }

    @JsonCreator
    public static UnionCoder jsonOf(@JsonProperty(value="component_encodings") List<Coder<?>> elements) {
        return UnionCoder.of(elements);
    }

    private int getIndexForEncoding(RawUnionValue union) {
        if (union == null) {
            throw new IllegalArgumentException("cannot encode a null tagged union");
        }
        int index = union.getUnionTag();
        if (index < 0 || index >= this.elementCoders.size()) {
            throw new IllegalArgumentException("union value index " + index + " not in range [0.." + (this.elementCoders.size() - 1) + "]");
        }
        return index;
    }

    @Override
    public void encode(RawUnionValue union, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        int index = this.getIndexForEncoding(union);
        VarInt.encode(index, outStream);
        Coder<?> coder = this.elementCoders.get(index);
        coder.encode(union.getValue(), outStream, context);
    }

    @Override
    public RawUnionValue decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
        int index = VarInt.decodeInt(inStream);
        Object value = this.elementCoders.get(index).decode(inStream, context);
        return new RawUnionValue(index, value);
    }

    @Override
    public List<? extends Coder<?>> getCoderArguments() {
        return null;
    }

    @Override
    public List<? extends Coder<?>> getComponents() {
        return this.elementCoders;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(RawUnionValue union, Coder.Context context) {
        int index = this.getIndexForEncoding(union);
        Coder<?> coder = this.elementCoders.get(index);
        return coder.isRegisterByteSizeObserverCheap(union.getValue(), context);
    }

    @Override
    public void registerByteSizeObserver(RawUnionValue union, ElementByteSizeObserver observer, Coder.Context context) throws Exception {
        int index = this.getIndexForEncoding(union);
        observer.update(VarInt.getLength(index));
        Coder<?> coder = this.elementCoders.get(index);
        coder.registerByteSizeObserver(union.getValue(), observer, context);
    }

    private UnionCoder(List<Coder<?>> elementCoders) {
        this.elementCoders = elementCoders;
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.verifyDeterministic("UnionCoder is only deterministic if all element coders are", this.elementCoders);
    }
}

