/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.coders.InstantCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.transforms.Min;
import com.google.cloud.dataflow.sdk.transforms.SerializableFunction;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.util.TimeDomain;
import com.google.cloud.dataflow.sdk.util.state.AccumulatorCombiningState;
import com.google.cloud.dataflow.sdk.util.state.CombiningState;
import com.google.cloud.dataflow.sdk.util.state.MergingStateAccessor;
import com.google.cloud.dataflow.sdk.util.state.StateAccessor;
import com.google.cloud.dataflow.sdk.util.state.StateMerging;
import com.google.cloud.dataflow.sdk.util.state.StateTag;
import com.google.cloud.dataflow.sdk.util.state.StateTags;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormat;
import org.joda.time.format.PeriodFormatter;

@Experimental(value=Experimental.Kind.TRIGGER)
public abstract class AfterDelayFromFirstElement<W extends BoundedWindow>
extends Trigger.OnceTrigger<W> {
    protected static final List<SerializableFunction<Instant, Instant>> IDENTITY = ImmutableList.of();
    protected static final StateTag<Object, AccumulatorCombiningState<Instant, Combine.Holder<Instant>, Instant>> DELAYED_UNTIL_TAG = StateTags.makeSystemTagInternal(StateTags.combiningValueFromInputInternal("delayed", InstantCoder.of(), Min.MinFn.naturalOrder()));
    private static final PeriodFormatter PERIOD_FORMATTER = PeriodFormat.wordBased((Locale)Locale.ENGLISH);
    protected final List<SerializableFunction<Instant, Instant>> timestampMappers;
    private final TimeDomain timeDomain;

    @Nullable
    public abstract Instant getCurrentTime(Trigger.TriggerContext var1);

    protected abstract AfterDelayFromFirstElement<W> newWith(List<SerializableFunction<Instant, Instant>> var1);

    public AfterDelayFromFirstElement(TimeDomain timeDomain, List<SerializableFunction<Instant, Instant>> timestampMappers) {
        super(null);
        this.timestampMappers = timestampMappers;
        this.timeDomain = timeDomain;
    }

    private Instant getTargetTimestamp(Trigger.OnElementContext c) {
        return this.computeTargetTimestamp(c.currentProcessingTime());
    }

    public AfterDelayFromFirstElement<W> alignedTo(Duration size, Instant offset) {
        return this.newWith(new AlignFn(size, offset));
    }

    public AfterDelayFromFirstElement<W> alignedTo(Duration size) {
        return this.alignedTo(size, new Instant(0L));
    }

    public AfterDelayFromFirstElement<W> plusDelayOf(Duration delay) {
        return this.newWith(new DelayFn(delay));
    }

    @Deprecated
    public Trigger.OnceTrigger<W> mappedTo(SerializableFunction<Instant, Instant> timestampMapper) {
        return this.newWith(timestampMapper);
    }

    @Override
    public boolean isCompatible(Trigger<?> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        AfterDelayFromFirstElement that = (AfterDelayFromFirstElement)other;
        return this.timestampMappers.equals(that.timestampMappers);
    }

    private AfterDelayFromFirstElement<W> newWith(SerializableFunction<Instant, Instant> timestampMapper) {
        return this.newWith((List<SerializableFunction<Instant, Instant>>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.timestampMappers)).add(timestampMapper)).build()));
    }

    @Override
    public void prefetchOnElement(StateAccessor<?> state) {
        state.access(DELAYED_UNTIL_TAG).readLater();
    }

    @Override
    public void onElement(Trigger.OnElementContext c) throws Exception {
        CombiningState delayUntilState = c.state().access(DELAYED_UNTIL_TAG);
        Instant oldDelayUntil = (Instant)delayUntilState.read();
        if (oldDelayUntil != null) {
            return;
        }
        Instant targetTimestamp = this.getTargetTimestamp(c);
        delayUntilState.add(targetTimestamp);
        c.setTimer(targetTimestamp, this.timeDomain);
    }

    @Override
    public void prefetchOnMerge(MergingStateAccessor<?, W> state) {
        super.prefetchOnMerge(state);
        StateMerging.prefetchCombiningValues(state, DELAYED_UNTIL_TAG);
    }

    @Override
    public void onMerge(Trigger.OnMergeContext c) throws Exception {
        if (c.trigger().isFinished()) {
            StateMerging.clear(c.state(), DELAYED_UNTIL_TAG);
            return;
        }
        StateMerging.mergeCombiningValues(c.state(), DELAYED_UNTIL_TAG);
        Instant earliestTargetTime = (Instant)c.state().access(DELAYED_UNTIL_TAG).read();
        if (earliestTargetTime != null) {
            c.setTimer(earliestTargetTime, this.timeDomain);
        }
    }

    @Override
    public void prefetchShouldFire(StateAccessor<?> state) {
        state.access(DELAYED_UNTIL_TAG).readLater();
    }

    @Override
    public void clear(Trigger.TriggerContext c) throws Exception {
        c.state().access(DELAYED_UNTIL_TAG).clear();
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(W window) {
        return BoundedWindow.TIMESTAMP_MAX_VALUE;
    }

    @Override
    public boolean shouldFire(Trigger.TriggerContext context) throws Exception {
        Instant delayedUntil = (Instant)context.state().access(DELAYED_UNTIL_TAG).read();
        return delayedUntil != null && this.getCurrentTime(context) != null && this.getCurrentTime(context).isAfter((ReadableInstant)delayedUntil);
    }

    @Override
    protected void onOnlyFiring(Trigger.TriggerContext context) throws Exception {
        this.clear(context);
    }

    protected Instant computeTargetTimestamp(Instant time) {
        Instant result = time;
        for (SerializableFunction<Instant, Instant> timestampMapper : this.timestampMappers) {
            result = timestampMapper.apply(result);
        }
        return result;
    }

    static final class AlignFn
    implements SerializableFunction<Instant, Instant> {
        private final Duration size;
        private final Instant offset;

        public AlignFn(Duration size, Instant offset) {
            this.size = size;
            this.offset = offset;
        }

        @Override
        public Instant apply(Instant point) {
            long millisSinceStart = new Duration((ReadableInstant)this.offset, (ReadableInstant)point).getMillis() % this.size.getMillis();
            return millisSinceStart == 0L ? point : point.plus((ReadableDuration)this.size).minus(millisSinceStart);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof AlignFn)) {
                return false;
            }
            AlignFn other = (AlignFn)object;
            return other.size.equals((Object)this.size) && other.offset.equals((Object)this.offset);
        }

        public int hashCode() {
            return Objects.hash(this.size, this.offset);
        }
    }

    private static final class DelayFn
    implements SerializableFunction<Instant, Instant> {
        private final Duration delay;

        public DelayFn(Duration delay) {
            this.delay = delay;
        }

        @Override
        public Instant apply(Instant input) {
            return input.plus((ReadableDuration)this.delay);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DelayFn)) {
                return false;
            }
            return this.delay.equals((Object)((DelayFn)object).delay);
        }

        public int hashCode() {
            return Objects.hash(this.delay);
        }

        public String toString() {
            return PERIOD_FORMATTER.print((ReadablePeriod)this.delay.toPeriod());
        }
    }
}

