/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Joiner;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.transforms.windowing.AfterFirst;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Repeatedly;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.util.ExecutableTrigger;
import java.util.Arrays;
import java.util.List;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.TRIGGER)
public class AfterEach<W extends BoundedWindow>
extends Trigger<W> {
    private AfterEach(List<Trigger<W>> subTriggers) {
        super(subTriggers);
        Preconditions.checkArgument(subTriggers.size() > 1);
    }

    @SafeVarargs
    public static <W extends BoundedWindow> Trigger<W> inOrder(Trigger<W> ... triggers) {
        return new AfterEach<W>(Arrays.asList(triggers));
    }

    @Override
    public void onElement(Trigger.OnElementContext c) throws Exception {
        if (!c.trigger().isMerging()) {
            c.trigger().firstUnfinishedSubTrigger().invokeOnElement(c);
        } else {
            for (ExecutableTrigger subTrigger : c.trigger().subTriggers()) {
                subTrigger.invokeOnElement(c);
            }
        }
    }

    @Override
    public void onMerge(Trigger.OnMergeContext context) throws Exception {
        boolean priorTriggersAllFinished = true;
        for (ExecutableTrigger subTrigger : context.trigger().subTriggers()) {
            if (priorTriggersAllFinished) {
                subTrigger.invokeOnMerge(context);
                priorTriggersAllFinished &= ((Trigger.OnMergeContext)context.forTrigger(subTrigger)).trigger().isFinished();
                continue;
            }
            subTrigger.invokeClear(context);
        }
        this.updateFinishedState(context);
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(W window) {
        return ((Trigger)this.subTriggers.get(0)).getWatermarkThatGuaranteesFiring(window);
    }

    @Override
    public Trigger<W> getContinuationTrigger(List<Trigger<W>> continuationTriggers) {
        return Repeatedly.forever(new AfterFirst<W>(continuationTriggers));
    }

    @Override
    public boolean shouldFire(Trigger.TriggerContext context) throws Exception {
        ExecutableTrigger firstUnfinished = context.trigger().firstUnfinishedSubTrigger();
        return firstUnfinished.invokeShouldFire(context);
    }

    @Override
    public void onFire(Trigger.TriggerContext context) throws Exception {
        context.trigger().firstUnfinishedSubTrigger().invokeOnFire(context);
        if (context.trigger().isMerging()) {
            for (ExecutableTrigger subTrigger : context.trigger().subTriggers()) {
                subTrigger.invokeClear(context);
            }
        }
        this.updateFinishedState(context);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("AfterEach.inOrder(");
        Joiner.on(", ").appendTo(builder, (Iterable<?>)this.subTriggers);
        builder.append(")");
        return builder.toString();
    }

    private void updateFinishedState(Trigger.TriggerContext context) {
        context.trigger().setFinished(context.trigger().firstUnfinishedSubTrigger() == null);
    }
}

