/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.transforms.windowing.IntervalWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.WindowFn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MergeOverlappingIntervalWindows {
    public static void mergeWindows(WindowFn.MergeContext c) throws Exception {
        ArrayList<IntervalWindow> sortedWindows = new ArrayList<IntervalWindow>();
        for (IntervalWindow window : c.windows()) {
            sortedWindows.add(window);
        }
        Collections.sort(sortedWindows);
        ArrayList<MergeCandidate> merges = new ArrayList<MergeCandidate>();
        MergeCandidate current = new MergeCandidate();
        for (IntervalWindow window : sortedWindows) {
            if (current.intersects(window)) {
                current.add(window);
                continue;
            }
            merges.add(current);
            current = new MergeCandidate(window);
        }
        merges.add(current);
        for (MergeCandidate merge : merges) {
            merge.apply(c);
        }
    }

    private static class MergeCandidate {
        private IntervalWindow union;
        private final List<IntervalWindow> parts;

        public MergeCandidate() {
            this.parts = new ArrayList<IntervalWindow>();
        }

        public MergeCandidate(IntervalWindow window) {
            this.union = window;
            this.parts = new ArrayList<IntervalWindow>(Arrays.asList(window));
        }

        public boolean intersects(IntervalWindow window) {
            return this.union == null || this.union.intersects(window);
        }

        public void add(IntervalWindow window) {
            this.union = this.union == null ? window : this.union.span(window);
            this.parts.add(window);
        }

        public void apply(WindowFn.MergeContext c) throws Exception {
            if (this.parts.size() > 1) {
                c.merge(this.parts, this.union);
            }
        }

        public String toString() {
            return "MergeCandidate[union=" + this.union + ", parts=" + this.parts + "]";
        }
    }
}

