/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.util.ExecutableTrigger;
import java.util.Arrays;
import java.util.List;
import org.joda.time.Instant;

public class Repeatedly<W extends BoundedWindow>
extends Trigger<W> {
    private static final int REPEATED = 0;

    public static <W extends BoundedWindow> Repeatedly<W> forever(Trigger<W> repeated) {
        return new Repeatedly<W>(repeated);
    }

    private Repeatedly(Trigger<W> repeated) {
        super(Arrays.asList(repeated));
    }

    @Override
    public void onElement(Trigger.OnElementContext c) throws Exception {
        this.getRepeated(c).invokeOnElement(c);
    }

    @Override
    public void onMerge(Trigger.OnMergeContext c) throws Exception {
        this.getRepeated(c).invokeOnMerge(c);
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(W window) {
        return ((Trigger)this.subTriggers.get(0)).getWatermarkThatGuaranteesFiring(window);
    }

    @Override
    public Trigger<W> getContinuationTrigger(List<Trigger<W>> continuationTriggers) {
        return new Repeatedly<W>(continuationTriggers.get(0));
    }

    @Override
    public boolean shouldFire(Trigger.TriggerContext context) throws Exception {
        return this.getRepeated(context).invokeShouldFire(context);
    }

    @Override
    public void onFire(Trigger.TriggerContext context) throws Exception {
        this.getRepeated(context).invokeOnFire(context);
        if (context.trigger().isFinished(0)) {
            context.forTrigger(this.getRepeated(context)).trigger().resetTree();
        }
    }

    @Override
    public String toString() {
        return String.format("Repeatedly.forever(%s)", this.subTriggers.get(0));
    }

    private ExecutableTrigger<W> getRepeated(Trigger.TriggerContext context) {
        return context.trigger().subTrigger(0);
    }
}

